/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem;

import gregtech.api.GTValues;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.impl.ElectricItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.api.items.metaitem.stats.IItemMaxStackSizeProvider;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.common.ConfigHolder;
import gregtech.integration.baubles.BaublesModule;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;

public class ElectricStats
implements IItemComponent,
IItemCapabilityProvider,
IItemMaxStackSizeProvider,
IItemBehaviour,
ISubItemHandler {
    public static final ElectricStats EMPTY = new ElectricStats(0L, 0L, false, false);
    public final long maxCharge;
    public final int tier;
    public final boolean chargeable;
    public final boolean dischargeable;

    public ElectricStats(long maxCharge, long tier, boolean chargeable, boolean dischargeable) {
        this.maxCharge = maxCharge;
        this.tier = (int)tier;
        this.chargeable = chargeable;
        this.dischargeable = dischargeable;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null && electricItem.canProvideChargeExternally() && player.func_70093_af()) {
            if (!world.field_72995_K) {
                boolean isInDischargeMode = ElectricStats.isInDischargeMode(itemStack);
                String locale = "metaitem.electric.discharge_mode." + (isInDischargeMode ? "disabled" : "enabled");
                player.func_146105_b((ITextComponent)new TextComponentTranslation(locale, new Object[0]), true);
                ElectricStats.setInDischargeMode(itemStack, !isInDischargeMode);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    @Override
    public void onUpdate(ItemStack itemStack, Entity entity) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (electricItem != null && electricItem.canProvideChargeExternally() && ElectricStats.isInDischargeMode(itemStack) && electricItem.getCharge() > 0L) {
                InventoryPlayer inventoryPlayer = entityPlayer.field_71071_by;
                long transferLimit = electricItem.getTransferLimit();
                if (Loader.isModLoaded((String)"baubles")) {
                    inventoryPlayer = BaublesModule.getBaublesWrappedInventory(entityPlayer);
                }
                for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
                    ItemStack itemInSlot = inventoryPlayer.func_70301_a(i);
                    IElectricItem slotElectricItem = (IElectricItem)itemInSlot.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                    IEnergyStorage feEnergyItem = (IEnergyStorage)itemInSlot.getCapability(CapabilityEnergy.ENERGY, null);
                    if (slotElectricItem != null && !slotElectricItem.canProvideChargeExternally()) {
                        long chargedAmount = ElectricStats.chargeElectricItem(transferLimit, electricItem, slotElectricItem);
                        if (chargedAmount <= 0L || (transferLimit -= chargedAmount) != 0L) continue;
                        break;
                    }
                    if (!ConfigHolder.compat.energy.nativeEUToFE || feEnergyItem == null || feEnergyItem.getEnergyStored() >= feEnergyItem.getMaxEnergyStored()) continue;
                    int energyMissing = feEnergyItem.getMaxEnergyStored() - feEnergyItem.getEnergyStored();
                    long euToCharge = FeCompat.toEu(energyMissing, ConfigHolder.compat.energy.feToEuRatio);
                    long energyToTransfer = Math.min(euToCharge, transferLimit);
                    long maxDischargeAmount = Math.min(energyToTransfer, electricItem.discharge(energyToTransfer, electricItem.getTier(), false, true, true));
                    FeCompat.insertEu(feEnergyItem, maxDischargeAmount);
                    electricItem.discharge(maxDischargeAmount, electricItem.getTier(), false, true, false);
                }
            }
        }
    }

    private static long chargeElectricItem(long maxDischargeAmount, IElectricItem source, IElectricItem target) {
        long maxDischarged = source.discharge(maxDischargeAmount, source.getTier(), false, false, true);
        long maxReceived = target.charge(maxDischarged, source.getTier(), false, true);
        if (maxReceived > 0L) {
            long resultDischarged = source.discharge(maxReceived, source.getTier(), false, true, false);
            target.charge(resultDischarged, source.getTier(), false, false);
            return resultDischarged;
        }
        return 0L;
    }

    private static void setInDischargeMode(ItemStack itemStack, boolean isDischargeMode) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (isDischargeMode) {
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                itemStack.func_77982_d(tagCompound);
            }
            tagCompound.func_74757_a("DischargeMode", true);
        } else if (tagCompound != null) {
            tagCompound.func_82580_o("DischargeMode");
            if (tagCompound.func_82582_d()) {
                itemStack.func_77982_d(null);
            }
        }
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null && electricItem.canProvideChargeExternally()) {
            ElectricStats.addTotalChargeTooltip(lines, electricItem.getMaxCharge(), electricItem.getTier());
            if (ElectricStats.isInDischargeMode(itemStack)) {
                lines.add(I18n.func_135052_a((String)"metaitem.electric.discharge_mode.enabled", (Object[])new Object[0]));
            } else {
                lines.add(I18n.func_135052_a((String)"metaitem.electric.discharge_mode.disabled", (Object[])new Object[0]));
            }
            lines.add(I18n.func_135052_a((String)"metaitem.electric.discharge_mode.tooltip", (Object[])new Object[0]));
        }
    }

    private static void addTotalChargeTooltip(List<String> tooltip, long maxCharge, int tier) {
        String unit;
        long chargeTime;
        Instant end;
        Instant start = Instant.now();
        Duration duration = Duration.between(start, end = Instant.now().plusSeconds((long)((double)maxCharge * 1.0 / (double)GTValues.V[tier] / 20.0)));
        if (duration.getSeconds() <= 180L) {
            chargeTime = duration.getSeconds();
            unit = I18n.func_135052_a((String)"metaitem.battery.charge_unit.second", (Object[])new Object[0]);
        } else if (duration.toMinutes() <= 180L) {
            chargeTime = duration.toMinutes();
            unit = I18n.func_135052_a((String)"metaitem.battery.charge_unit.minute", (Object[])new Object[0]);
        } else {
            chargeTime = duration.toHours();
            unit = I18n.func_135052_a((String)"metaitem.battery.charge_unit.hour", (Object[])new Object[0]);
        }
        tooltip.add(I18n.func_135052_a((String)"metaitem.battery.charge_time", (Object[])new Object[]{chargeTime, unit, GTValues.VNF[tier]}));
    }

    private static boolean isInDischargeMode(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound != null && tagCompound.func_74767_n("DischargeMode");
    }

    @Override
    public int getMaxStackSize(ItemStack itemStack, int defaultValue) {
        ElectricItem electricItem = (ElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null || electricItem.getCharge() == 0L) {
            return defaultValue;
        }
        return 1;
    }

    @Override
    public String getItemSubType(ItemStack itemStack) {
        return "";
    }

    @Override
    public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        ItemStack copy = itemStack.func_77946_l();
        IElectricItem electricItem = (IElectricItem)copy.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null) {
            electricItem.charge(electricItem.getMaxCharge(), electricItem.getTier(), true, false);
            subItems.add((Object)copy);
        } else {
            subItems.add((Object)itemStack);
        }
    }

    @Override
    public ICapabilityProvider createProvider(ItemStack itemStack) {
        return new ElectricItem(itemStack, this.maxCharge, this.tier, this.chargeable, this.dischargeable);
    }

    public static ElectricStats createElectricItem(long maxCharge, long tier) {
        return new ElectricStats(maxCharge, tier, true, false);
    }

    public static ElectricStats createRechargeableBattery(long maxCharge, int tier) {
        return new ElectricStats(maxCharge, tier, true, true);
    }

    public static ElectricStats createBattery(long maxCharge, int tier, boolean rechargeable) {
        return new ElectricStats(maxCharge, tier, rechargeable, true);
    }
}

