/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.behavior;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.gui.widget.monitor.WidgetPluginConfig;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityMonitorScreen;
import gregtech.core.network.packets.PacketPluginSynced;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class MonitorPluginBaseBehavior
implements IItemBehaviour,
ItemUIFactory,
IDirtyNotifiable {
    protected MetaTileEntityMonitorScreen screen;
    private NBTTagCompound nbtTagCompound;

    public static MonitorPluginBaseBehavior getBehavior(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof MetaItem) {
            MetaItem item = (MetaItem)itemStack.func_77973_b();
            for (IItemBehaviour behaviour : item.getBehaviours(itemStack)) {
                if (!(behaviour instanceof MonitorPluginBaseBehavior)) continue;
                return (MonitorPluginBaseBehavior)behaviour;
            }
        }
        return null;
    }

    public MetaTileEntityMonitorScreen getScreen() {
        return this.screen;
    }

    public abstract MonitorPluginBaseBehavior createPlugin();

    public WidgetPluginConfig customUI(WidgetPluginConfig widgetGroup, IUIHolder holder, EntityPlayer entityPlayer) {
        return widgetGroup;
    }

    public boolean hasUI() {
        return false;
    }

    public void writeToNBT(NBTTagCompound data) {
    }

    public void readFromNBT(NBTTagCompound data) {
        this.nbtTagCompound = data;
    }

    public final void writePluginData(int id, @NotNull Consumer<PacketBuffer> buf) {
        if (this.screen != null && this.screen.getWorld() != null && !this.screen.getWorld().field_72995_K) {
            this.screen.writeCustomData(GregtechDataCodes.UPDATE_PLUGIN_DATA, packetBuffer -> {
                packetBuffer.func_150787_b(id);
                buf.accept((PacketBuffer)packetBuffer);
            });
        }
    }

    public void readPluginData(int id, PacketBuffer buf) {
    }

    public final void writePluginAction(int id, @NotNull Consumer<PacketBuffer> dataWriter) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        dataWriter.accept(buffer);
        GregTechAPI.networkHandler.sendToServer(new PacketPluginSynced(this.getScreen().getWorld().field_73011_w.getDimension(), this.getScreen().getPos(), id, buffer));
    }

    public void readPluginAction(EntityPlayerMP player, int id, PacketBuffer buf) {
    }

    public void writeInitialSyncData(PacketBuffer buf) {
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
    }

    @Override
    public void markAsDirty() {
        if (this.screen != null) {
            this.screen.pluginDirty();
        } else if (this.nbtTagCompound != null) {
            this.writeToNBT(this.nbtTagCompound);
        }
    }

    public boolean onClickLogic(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, boolean isRight, double x, double y) {
        return false;
    }

    public void update() {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPlugin(float partialTicks, RayTraceResult rayTraceResult) {
    }

    public void onMonitorValid(MetaTileEntityMonitorScreen screen, boolean valid) {
        this.screen = valid ? screen : null;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (hand != EnumHand.MAIN_HAND) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
            }
            ItemStack itemStack = player.func_184586_b(hand);
            MonitorPluginBaseBehavior behavior = MonitorPluginBaseBehavior.getBehavior(itemStack);
            if (behavior != null && behavior.hasUI()) {
                PlayerInventoryHolder holder = new PlayerInventoryHolder(player, hand);
                holder.openUI();
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public final ModularUI createUI(PlayerInventoryHolder playerInventoryHolder, EntityPlayer entityPlayer) {
        ItemStack itemStack = playerInventoryHolder.getCurrentItem();
        MonitorPluginBaseBehavior behavior = MonitorPluginBaseBehavior.getBehavior(itemStack);
        if (behavior != null) {
            behavior = behavior.createPlugin();
            behavior.readFromNBT(itemStack.func_190925_c("monitor_plugin"));
            return ModularUI.builder(GuiTextures.BOXED_BACKGROUND, 260, 210).widget(behavior.customUI(new WidgetPluginConfig().setBackGround(GuiTextures.BACKGROUND), playerInventoryHolder, entityPlayer)).bindCloseListener(this::markAsDirty).build(playerInventoryHolder, entityPlayer);
        }
        return null;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"metaitem.plugin.tooltips.1", (Object[])new Object[0]));
    }
}

