/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.items.armor.ArmorUtils;
import gregtech.api.items.armor.ISpecialArmorLogic;
import gregtech.api.items.metaitem.ElectricStats;
import gregtech.api.items.metaitem.stats.IItemHUDProvider;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class ArmorLogicSuite
implements ISpecialArmorLogic,
IItemHUDProvider {
    protected final int energyPerUse;
    protected final int tier;
    protected final long maxCapacity;
    protected final EntityEquipmentSlot SLOT;

    protected ArmorLogicSuite(int energyPerUse, long maxCapacity, int tier, EntityEquipmentSlot slot) {
        this.energyPerUse = energyPerUse;
        this.maxCapacity = maxCapacity;
        this.tier = tier;
        this.SLOT = slot;
    }

    @Override
    public abstract void onArmorTick(World var1, EntityPlayer var2, ItemStack var3);

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        IElectricItem item = (IElectricItem)armor.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        int damageLimit = Integer.MAX_VALUE;
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (this.energyPerUse > 0) {
            damageLimit = (int)Math.min((double)damageLimit, (double)item.getCharge() * 1.0 / (double)this.energyPerUse * 25.0);
        }
        return new ISpecialArmor.ArmorProperties(0, (double)this.getAbsorption(armor) * this.getDamageAbsorption(), damageLimit);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        IElectricItem item = (IElectricItem)armor.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return 0;
        }
        if (item.getCharge() >= (long)this.energyPerUse) {
            return (int)Math.round((double)(20.0f * this.getAbsorption(armor)) * this.getDamageAbsorption());
        }
        return (int)Math.round((double)(4.0f * this.getAbsorption(armor)) * this.getDamageAbsorption());
    }

    @Override
    public void addToolComponents(ArmorMetaItem.ArmorMetaValueItem mvi) {
        mvi.addComponents(new ElectricStats(this.maxCapacity, this.tier, true, false){

            @Override
            public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
                return ArmorLogicSuite.this.onRightClick(world, player, hand);
            }

            @Override
            public void addInformation(ItemStack itemStack, List<String> lines) {
                ArmorLogicSuite.this.addInfo(itemStack, lines);
            }
        });
    }

    public void addInfo(ItemStack itemStack, List<String> lines) {
        int armor = (int)Math.round((double)(20.0f * this.getAbsorption(itemStack)) * this.getDamageAbsorption());
        if (armor > 0) {
            lines.add(I18n.func_135052_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{armor, I18n.func_135052_a((String)"attribute.name.generic.armor", (Object[])new Object[0])}));
        }
    }

    public ActionResult<ItemStack> onRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack armor;
        if (player.func_184586_b(hand).func_77973_b() instanceof ArmorMetaItem && (armor = player.func_184586_b(hand)).func_77973_b() instanceof ArmorMetaItem && ((ItemStack)player.field_71071_by.field_70460_b.get(this.SLOT.func_188454_b())).func_190926_b() && !player.func_70093_af()) {
            player.field_71071_by.field_70460_b.set(this.SLOT.func_188454_b(), (Object)armor.func_77946_l());
            player.func_184611_a(hand, ItemStack.field_190927_a);
            player.func_184185_a(new SoundEvent(new ResourceLocation("item.armor.equip_generic")), 1.0f, 1.0f);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)armor);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        return this.SLOT;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "";
    }

    public double getDamageAbsorption() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void addCapacityHUD(ItemStack stack, ArmorUtils.ModularHUD hud) {
        IElectricItem cont = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (cont == null) {
            return;
        }
        if (cont.getCharge() == 0L) {
            return;
        }
        float energyMultiplier = (float)cont.getCharge() * 100.0f / (float)cont.getMaxCharge();
        hud.newString(I18n.func_135052_a((String)"metaarmor.hud.energy_lvl", (Object[])new Object[]{String.format("%.1f", Float.valueOf(energyMultiplier)) + "%"}));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldDrawHUD() {
        return this.SLOT == EntityEquipmentSlot.CHEST;
    }

    public int getEnergyPerUse() {
        return this.energyPerUse;
    }

    protected float getAbsorption(ItemStack itemStack) {
        switch (this.getEquipmentSlot(itemStack)) {
            case HEAD: 
            case FEET: {
                return 0.15f;
            }
            case CHEST: {
                return 0.4f;
            }
            case LEGS: {
                return 0.3f;
            }
        }
        return 0.0f;
    }
}

