/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.GregTechAPI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.integration.IntegrationModule;
import gregtech.integration.jei.JustEnoughItemsModule;
import gregtech.integration.jei.recipe.RecipeMapCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.DoubleSupplier;
import net.minecraft.util.text.TextComponentTranslation;

public class RecipeProgressWidget
extends ProgressWidget {
    private final RecipeMap<?> recipeMap;

    public RecipeProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, RecipeMap<?> recipeMap) {
        super(progressSupplier, x, y, width, height);
        this.recipeMap = recipeMap;
        this.setHoverTextConsumer(list -> list.add(new TextComponentTranslation("gui.widget.recipeProgressWidget.default_tooltip", new Object[0])));
    }

    public RecipeProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, TextureArea fullImage, ProgressWidget.MoveType moveType, RecipeMap<?> recipeMap) {
        super(progressSupplier, x, y, width, height, fullImage, moveType);
        this.recipeMap = recipeMap;
        this.setHoverTextConsumer(list -> list.add(new TextComponentTranslation("gui.widget.recipeProgressWidget.default_tooltip", new Object[0])));
    }

    public RecipeProgressWidget(int ticksPerCycle, int x, int y, int width, int height, TextureArea fullImage, ProgressWidget.MoveType moveType, RecipeMap<?> recipeMap) {
        super(ticksPerCycle, x, y, width, height, fullImage, moveType);
        this.recipeMap = recipeMap;
        this.setHoverTextConsumer(list -> list.add(new TextComponentTranslation("gui.widget.recipeProgressWidget.default_tooltip", new Object[0])));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        Collection<RecipeMapCategory> categories;
        if (!GregTechAPI.moduleManager.isModuleEnabled("jei_integration")) {
            return false;
        }
        if (this.isMouseOverElement(mouseX, mouseY) && (categories = RecipeMapCategory.getCategoriesFor(this.recipeMap)) != null && !categories.isEmpty()) {
            ArrayList<String> categoryID = new ArrayList<String>();
            if (this.recipeMap == RecipeMaps.FURNACE_RECIPES) {
                categoryID.add("minecraft.smelting");
            } else {
                for (RecipeMapCategory category : categories) {
                    categoryID.add(category.getUid());
                }
            }
            if (JustEnoughItemsModule.jeiRuntime == null) {
                IntegrationModule.logger.error("GTCEu JEI integration has crashed, this is not a good thing");
                return false;
            }
            JustEnoughItemsModule.jeiRuntime.getRecipesGui().showCategories(categoryID);
            return true;
        }
        return false;
    }
}

