/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Mouse;

public class AdvancedTextWidget
extends Widget {
    protected int maxWidthLimit;
    @SideOnly(value=Side.CLIENT)
    private WrapScreen wrapScreen;
    protected final Consumer<List<ITextComponent>> textSupplier;
    protected BiConsumer<String, Widget.ClickData> clickHandler;
    private List<ITextComponent> displayText = new ArrayList<ITextComponent>();
    private final int color;

    public AdvancedTextWidget(int xPosition, int yPosition, Consumer<List<ITextComponent>> text, int color) {
        super(new Position(xPosition, yPosition), Size.ZERO);
        this.textSupplier = text;
        this.color = color;
    }

    public static ITextComponent withButton(ITextComponent textComponent, String componentData) {
        Style style = textComponent.func_150256_b();
        style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "@!" + componentData));
        if (style.func_150215_a() == null) {
            style.func_150238_a(TextFormatting.YELLOW);
        }
        return textComponent;
    }

    public static ITextComponent withHoverTextTranslate(ITextComponent textComponent, String hoverTranslation) {
        Style style = textComponent.func_150256_b();
        TextComponentTranslation translation = new TextComponentTranslation(hoverTranslation, new Object[0]);
        translation.func_150256_b().func_150238_a(TextFormatting.GRAY);
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)translation));
        return textComponent;
    }

    public AdvancedTextWidget setMaxWidthLimit(int maxWidthLimit) {
        this.maxWidthLimit = maxWidthLimit;
        if (AdvancedTextWidget.isClientSide()) {
            this.updateComponentTextSize();
        }
        return this;
    }

    public AdvancedTextWidget setClickHandler(BiConsumer<String, Widget.ClickData> clickHandler) {
        this.clickHandler = clickHandler;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private WrapScreen getWrapScreen() {
        if (this.wrapScreen == null) {
            this.wrapScreen = new WrapScreen();
        }
        return this.wrapScreen;
    }

    @SideOnly(value=Side.CLIENT)
    private void resizeWrapScreen() {
        if (this.sizes != null) {
            this.getWrapScreen().func_146280_a(Minecraft.func_71410_x(), this.sizes.getScreenWidth(), this.sizes.getScreenHeight());
        }
    }

    @Override
    public void initWidget() {
        super.initWidget();
        if (AdvancedTextWidget.isClientSide()) {
            this.resizeWrapScreen();
        }
    }

    @Override
    protected void onPositionUpdate() {
        super.onPositionUpdate();
        if (AdvancedTextWidget.isClientSide()) {
            this.resizeWrapScreen();
        }
    }

    @Override
    public void detectAndSendChanges() {
        ArrayList<ITextComponent> textBuffer = new ArrayList<ITextComponent>();
        this.textSupplier.accept(textBuffer);
        if (!this.displayText.equals(textBuffer)) {
            this.displayText = textBuffer;
            this.writeUpdateInfo(1, buffer -> {
                buffer.func_150787_b(this.displayText.size());
                for (ITextComponent textComponent : this.displayText) {
                    buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent));
                }
            });
        }
    }

    protected ITextComponent getTextUnderMouse(int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Position position = this.getPosition();
        int selectedLine = (mouseY - position.y) / (fontRenderer.field_78288_b + 2);
        if (mouseX >= position.x && selectedLine >= 0 && selectedLine < this.displayText.size()) {
            ITextComponent selectedComponent = this.displayText.get(selectedLine);
            int mouseOffset = mouseX - position.x;
            int currentOffset = 0;
            for (ITextComponent lineComponent : selectedComponent) {
                if ((currentOffset += fontRenderer.func_78256_a(lineComponent.func_150261_e())) < mouseOffset) continue;
                return lineComponent;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateComponentTextSize() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int maxStringWidth = 0;
        int totalHeight = 0;
        for (ITextComponent textComponent : this.displayText) {
            maxStringWidth = Math.max(maxStringWidth, fontRenderer.func_78256_a(textComponent.func_150254_d()));
            totalHeight += fontRenderer.field_78288_b + 2;
        }
        this.setSize(new Size(maxStringWidth, totalHeight -= 2));
        if (this.uiAccess != null) {
            this.uiAccess.notifySizeChange();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void formatDisplayText() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int maxTextWidthResult = this.maxWidthLimit == 0 ? Integer.MAX_VALUE : this.maxWidthLimit;
        this.displayText = this.displayText.stream().flatMap(c -> GuiUtilRenderComponents.func_178908_a((ITextComponent)c, (int)maxTextWidthResult, (FontRenderer)fontRenderer, (boolean)true, (boolean)true).stream()).collect(Collectors.toList());
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.displayText.clear();
            int count = buffer.func_150792_a();
            for (int i = 0; i < count; ++i) {
                String jsonText = buffer.func_150789_c(Short.MAX_VALUE);
                this.displayText.add(ITextComponent.Serializer.func_150699_a((String)jsonText));
            }
            this.formatDisplayText();
            this.updateComponentTextSize();
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            Widget.ClickData clickData = Widget.ClickData.readFromBuf(buffer);
            String componentData = buffer.func_150789_c(128);
            if (this.clickHandler != null) {
                this.clickHandler.accept(componentData, clickData);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean handleCustomComponentClick(ITextComponent textComponent) {
        Style style = textComponent.func_150256_b();
        if (style.func_150235_h() != null) {
            ClickEvent clickEvent = style.func_150235_h();
            String componentText = clickEvent.func_150668_b();
            if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL && componentText.startsWith("@!")) {
                String rawText = componentText.substring(2);
                Widget.ClickData clickData = new Widget.ClickData(Mouse.getEventButton(), AdvancedTextWidget.isShiftDown(), AdvancedTextWidget.isCtrlDown());
                this.writeClientAction(1, buf -> {
                    clickData.writeToBuf((PacketBuffer)buf);
                    buf.func_180714_a(rawText);
                });
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        ITextComponent textComponent = this.getTextUnderMouse(mouseX, mouseY);
        if (textComponent != null && (this.handleCustomComponentClick(textComponent) || this.getWrapScreen().func_175276_a(textComponent))) {
            AdvancedTextWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Position position = this.getPosition();
        for (int i = 0; i < this.displayText.size(); ++i) {
            fontRenderer.func_78276_b(this.displayText.get(i).func_150254_d(), position.x, position.y + i * (fontRenderer.field_78288_b + 2), this.color);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        ITextComponent component = this.getTextUnderMouse(mouseX, mouseY);
        if (component != null) {
            this.getWrapScreen().func_175272_a(component, mouseX, mouseY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class WrapScreen
    extends GuiScreen {
        private WrapScreen() {
        }

        public void func_175272_a(@NotNull ITextComponent component, int x, int y) {
            super.func_175272_a(component, x, y);
        }

        public boolean func_175276_a(@NotNull ITextComponent component) {
            return super.func_175276_a(component);
        }

        protected void drawHoveringText(@NotNull List<String> textLines, int x, int y, @NotNull FontRenderer font) {
            GuiUtils.drawHoveringText(textLines, (int)x, (int)y, (int)this.field_146294_l, (int)this.field_146295_m, (int)256, (FontRenderer)font);
        }
    }
}

