/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.impl;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.FakeModularGuiContainer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FakeModularGui
implements IRenderContext {
    public final ModularUI modularUI;
    public FakeModularGuiContainer container;
    protected Minecraft mc;
    protected FontRenderer fr;

    public FakeModularGui(ModularUI modularUI, FakeModularGuiContainer fakeModularUIContainer) {
        this.modularUI = modularUI;
        this.container = fakeModularUIContainer;
        this.modularUI.updateScreenSize(this.modularUI.getWidth(), this.modularUI.getHeight());
        this.mc = Minecraft.func_71410_x();
        this.fr = this.mc.field_71466_p;
    }

    public void updateScreen() {
        this.modularUI.guiWidgets.values().forEach(Widget::updateScreen);
    }

    public void handleWidgetUpdate(int windowId, int widgetId, PacketBuffer updateData) {
        if (windowId == this.container.windowId) {
            Widget widget = (Widget)this.modularUI.guiWidgets.get((Object)widgetId);
            int updateId = updateData.func_150792_a();
            if (widget != null) {
                widget.readUpdateInfo(updateId, updateData);
            }
        }
    }

    public void drawScreen(double x, double y, float partialTicks) {
        int i;
        float halfW = (float)this.modularUI.getWidth() / 2.0f;
        float halfH = (float)this.modularUI.getHeight() / 2.0f;
        float scale = 0.5f / Math.max(halfW, halfH);
        int mouseX = (int)(x / (double)scale + (double)(halfW > halfH ? 0.0f : halfW - halfH));
        int mouseY = (int)(y / (double)scale + (double)(halfH > halfW ? 0.0f : halfH - halfW));
        GlStateManager.func_179109_b((float)(-scale * halfW), (float)(-scale * halfH), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179131_c((float)this.modularUI.getRColorForOverlay(), (float)this.modularUI.getGColorForOverlay(), (float)this.modularUI.getBColorForOverlay(), (float)1.0f);
        this.modularUI.backgroundPath.draw(0.0, 0.0, this.modularUI.getWidth(), this.modularUI.getHeight());
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.001);
        GlStateManager.func_179132_a((boolean)false);
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        for (i = 0; i < this.container.inventorySlots.size(); ++i) {
            FakeModularGui.renderSlot(this.container.inventorySlots.get(i), this.fr);
        }
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)0.0f);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        for (i = 0; i < this.container.inventorySlots.size(); ++i) {
            Slot slot = this.container.inventorySlots.get(i);
            if (slot.func_75211_c().func_190926_b() || slot.field_75223_e >= mouseX || mouseX >= slot.field_75223_e + 18 || slot.field_75221_f >= mouseY || mouseY >= slot.field_75221_f + 18) continue;
            this.renderToolTip(slot.func_75211_c(), slot.field_75223_e, slot.field_75221_f);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
    }

    public static void renderSlot(Slot slot, FontRenderer fr) {
        ItemStack stack = slot.func_75211_c();
        if (!stack.func_190926_b() && slot.func_111238_b()) {
            String text;
            GlStateManager.func_179101_C();
            RenderHelper.func_74519_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0E-5);
            GlStateManager.func_179109_b((float)slot.field_75223_e, (float)slot.field_75221_f, (float)0.0f);
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            renderItem.func_180450_b(stack, 0, 0);
            renderItem.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, 0, 0, null);
            String string = text = stack.func_190916_E() > 1 ? Integer.toString(stack.func_190916_E()) : null;
            if (!stack.func_190926_b()) {
                EntityPlayerSP entityplayersp;
                float f3;
                if (stack.func_190916_E() != 1) {
                    String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179084_k();
                    fr.func_175063_a(s, (float)(17 - fr.func_78256_a(s)), 9.0f, 0xFFFFFF);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179147_l();
                }
                if (stack.func_77973_b().showDurabilityBar(stack)) {
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferbuilder = tessellator.func_178180_c();
                    double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                    int rgbfordisplay = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                    int i = Math.round(13.0f - (float)health * 13.0f);
                    FakeModularGui.draw(bufferbuilder, 2, 13, 13, 2, 0, 0, 0, 255);
                    FakeModularGui.draw(bufferbuilder, 2, 13, i, 1, rgbfordisplay >> 16 & 0xFF, rgbfordisplay >> 8 & 0xFF, rgbfordisplay & 0xFF, 255);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179145_e();
                }
                float f = f3 = (entityplayersp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : entityplayersp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
                if (f3 > 0.0f) {
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179090_x();
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferBuilder = tessellator.func_178180_c();
                    FakeModularGui.draw(bufferBuilder, 0, MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179145_e();
                }
            }
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void renderToolTip(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        GuiUtils.drawHoveringText(this.getItemToolTip(stack), (int)x, (int)y, (int)this.modularUI.getScreenWidth(), (int)this.modularUI.getScreenHeight(), (int)-1, (FontRenderer)(font == null ? this.fr : font));
        GuiUtils.postItemToolTip();
    }

    protected List<String> getItemToolTip(ItemStack itemStack) {
        List list = itemStack.func_82840_a((EntityPlayer)this.mc.field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        list.set(0, itemStack.func_77973_b().getForgeRarity(itemStack).getColor() + (String)list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        return list;
    }

    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)this.modularUI.getRColorForOverlay(), (float)this.modularUI.getGColorForOverlay(), (float)this.modularUI.getBColorForOverlay(), (float)1.0f);
        for (Widget widget : this.modularUI.guiWidgets.values()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)this.modularUI.getRColorForOverlay(), (float)this.modularUI.getGColorForOverlay(), (float)this.modularUI.getBColorForOverlay());
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            widget.drawInBackground(mouseX, mouseY, partialTicks, this);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        for (Widget widget : this.modularUI.guiWidgets.values()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            widget.drawInForeground(mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (int i = this.modularUI.guiWidgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.modularUI.guiWidgets.get((Object)i);
            if (!widget.isVisible() || !widget.isActive() || widget instanceof INativeWidget || !widget.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return;
        }
    }
}

