/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids.store;

import gregtech.api.fluids.FluidState;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FluidStorageKey {
    private static final Map<ResourceLocation, FluidStorageKey> keys = new Object2ObjectOpenHashMap();
    private final ResourceLocation resourceLocation;
    private final MaterialIconType iconType;
    private final UnaryOperator<String> registryNameOperator;
    private final Function<Material, String> translationKeyFunction;
    private final int hashCode;
    private final FluidState defaultFluidState;
    private final int registrationPriority;

    public FluidStorageKey(@NotNull ResourceLocation resourceLocation, @NotNull MaterialIconType iconType, @NotNull @NotNull UnaryOperator<@NotNull String> registryNameOperator, @NotNull @NotNull Function<@NotNull Material, @NotNull String> translationKeyFunction) {
        this(resourceLocation, iconType, registryNameOperator, translationKeyFunction, null);
    }

    public FluidStorageKey(@NotNull ResourceLocation resourceLocation, @NotNull MaterialIconType iconType, @NotNull @NotNull UnaryOperator<@NotNull String> registryNameOperator, @NotNull @NotNull Function<@NotNull Material, @NotNull String> translationKeyFunction, @Nullable FluidState defaultFluidState) {
        this(resourceLocation, iconType, registryNameOperator, translationKeyFunction, defaultFluidState, 0);
    }

    public FluidStorageKey(@NotNull ResourceLocation resourceLocation, @NotNull MaterialIconType iconType, @NotNull @NotNull UnaryOperator<@NotNull String> registryNameOperator, @NotNull @NotNull Function<@NotNull Material, @NotNull String> translationKeyFunction, @Nullable FluidState defaultFluidState, int registrationPriority) {
        this.resourceLocation = resourceLocation;
        this.iconType = iconType;
        this.registryNameOperator = registryNameOperator;
        this.translationKeyFunction = translationKeyFunction;
        this.hashCode = resourceLocation.hashCode();
        this.defaultFluidState = defaultFluidState;
        this.registrationPriority = registrationPriority;
        if (keys.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Cannot create duplicate keys");
        }
        keys.put(resourceLocation, this);
    }

    @Nullable
    public static FluidStorageKey getByName(@NotNull ResourceLocation location) {
        return keys.get(location);
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @NotNull
    public MaterialIconType getIconType() {
        return this.iconType;
    }

    @NotNull
    public String getRegistryNameFor(@NotNull String baseName) {
        return (String)this.registryNameOperator.apply(baseName);
    }

    @NotNull
    public String getTranslationKeyFor(@NotNull Material material) {
        return this.translationKeyFunction.apply(material);
    }

    @Nullable
    public FluidState getDefaultFluidState() {
        return this.defaultFluidState;
    }

    public int getRegistrationPriority() {
        return this.registrationPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStorageKey fluidKey = (FluidStorageKey)o;
        return this.resourceLocation.equals((Object)fluidKey.getResourceLocation());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    public String toString() {
        return "FluidStorageKey{" + this.resourceLocation + '}';
    }
}

