/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids.store;

import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.store.FluidStorageKey;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FluidStorage {
    private final Map<FluidStorageKey, Fluid> map = new Object2ObjectOpenHashMap();
    private Map<FluidStorageKey, FluidBuilder> toRegister = new Object2ObjectOpenHashMap();
    private boolean registered = false;

    public void enqueueRegistration(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        if (this.registered) {
            throw new IllegalStateException("Cannot enqueue a builder after registration");
        }
        if (this.toRegister.containsKey(key)) {
            throw new IllegalArgumentException("FluidStorageKey " + key + " is already queued");
        }
        this.toRegister.put(key, builder);
    }

    @Nullable
    public FluidBuilder getQueuedBuilder(@NotNull FluidStorageKey key) {
        if (this.registered) {
            throw new IllegalArgumentException("FluidStorage has already been registered");
        }
        return this.toRegister.get(key);
    }

    @ApiStatus.Internal
    public void registerFluids(@NotNull Material material) {
        if (this.registered) {
            throw new IllegalStateException("FluidStorage has already been registered");
        }
        if (this.toRegister.isEmpty() && this.map.isEmpty()) {
            this.enqueueRegistration(FluidStorageKeys.LIQUID, new FluidBuilder());
        }
        this.toRegister.entrySet().stream().sorted(Comparator.comparingInt(e -> -((FluidStorageKey)e.getKey()).getRegistrationPriority())).forEach(entry -> {
            Fluid fluid = ((FluidBuilder)entry.getValue()).build(material.getModid(), material, (FluidStorageKey)entry.getKey());
            if (!this.storeNoOverwrites((FluidStorageKey)entry.getKey(), fluid)) {
                GTLog.logger.error("{} already has an associated fluid for material {}", (Object)material);
            }
        });
        this.toRegister = null;
        this.registered = true;
    }

    @Nullable
    public Fluid get(@NotNull FluidStorageKey key) {
        return this.map.get(key);
    }

    public boolean storeNoOverwrites(@NotNull FluidStorageKey key, @NotNull Fluid fluid) {
        if (this.map.containsKey(key)) {
            return false;
        }
        this.store(key, fluid);
        return true;
    }

    public void store(@NotNull FluidStorageKey key, @NotNull Fluid fluid) {
        this.map.put(key, fluid);
    }
}

