/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids;

import com.google.common.collect.BiMap;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.common.blocks.MetaBlocks;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTFluidRegistration {
    public static final GTFluidRegistration INSTANCE = new GTFluidRegistration();
    private static final Collection<ResourceLocation> fluidSprites = new ObjectOpenHashSet();
    @Nullable
    private static BiMap<String, Fluid> MASTER_FLUID_REFERENCE;
    @Nullable
    private static BiMap<String, String> DEFAULT_FLUID_NAME;

    private static void fixFluidRegistryName(@NotNull Fluid fluid, @NotNull String modid) {
        String defaultName;
        Field field;
        if ("gregtech".equals(modid)) {
            return;
        }
        if (MASTER_FLUID_REFERENCE == null) {
            try {
                field = FluidRegistry.class.getDeclaredField("masterFluidReference");
                field.setAccessible(true);
                MASTER_FLUID_REFERENCE = (BiMap)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException("Could not reflect the Forge Master Fluid Registry", e);
            }
        }
        Objects.requireNonNull(MASTER_FLUID_REFERENCE);
        if (DEFAULT_FLUID_NAME == null) {
            try {
                field = FluidRegistry.class.getDeclaredField("defaultFluidName");
                field.setAccessible(true);
                DEFAULT_FLUID_NAME = (BiMap)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException("Could not reflect the Forge Default Fluid Name map", e);
            }
        }
        Objects.requireNonNull(DEFAULT_FLUID_NAME);
        String masterKey = (String)MASTER_FLUID_REFERENCE.inverse().get((Object)fluid);
        if (masterKey != null && masterKey.startsWith("gregtech:")) {
            MASTER_FLUID_REFERENCE.inverse().put((Object)fluid, (Object)(modid + ':' + fluid.getName()));
        }
        if ((defaultName = (String)DEFAULT_FLUID_NAME.get((Object)fluid.getName())).startsWith("gregtech:")) {
            DEFAULT_FLUID_NAME.put((Object)fluid.getName(), (Object)(modid + ':' + fluid.getName()));
        }
    }

    @ApiStatus.Internal
    public void register() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            FluidProperty property = material.getProperty(PropertyKey.FLUID);
            if (property == null) continue;
            property.getStorage().registerFluids(material);
        }
    }

    @ApiStatus.Internal
    public void registerSprites(@NotNull TextureMap textureMap) {
        for (ResourceLocation spriteLocation : fluidSprites) {
            textureMap.func_174942_a(spriteLocation);
        }
    }

    public void registerFluid(@NotNull Fluid fluid, @NotNull String modid, boolean generateBucket) {
        boolean didExist = FluidRegistry.getFluid((String)fluid.getName()) != null;
        FluidRegistry.registerFluid((Fluid)fluid);
        if (!didExist) {
            fluidSprites.add(fluid.getStill());
            fluidSprites.add(fluid.getFlowing());
            GTFluidRegistration.fixFluidRegistryName(fluid, modid);
        }
        if (generateBucket) {
            FluidRegistry.addBucketForFluid((Fluid)fluid);
        }
    }

    public void registerFluidBlock(@NotNull BlockFluidBase block) {
        MetaBlocks.FLUID_BLOCKS.add(block);
    }
}

