/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids;

import com.google.common.base.Preconditions;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.GTFluid;
import gregtech.api.fluids.GTFluidBlock;
import gregtech.api.fluids.GTFluidMaterial;
import gregtech.api.fluids.GTFluidRegistration;
import gregtech.api.fluids.attribute.AttributedFluid;
import gregtech.api.fluids.attribute.FluidAttribute;
import gregtech.api.fluids.store.FluidStorageKey;
import gregtech.api.unification.FluidUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import io.github.drmanganese.topaddons.reference.Colors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidBuilder {
    private static final int INFER_TEMPERATURE = -1;
    private static final int INFER_COLOR = -1;
    private static final int INFER_DENSITY = -1;
    private static final int INFER_LUMINOSITY = -1;
    private static final int INFER_VISCOSITY = -1;
    private String name = null;
    private String translationKey = null;
    private final Collection<FluidAttribute> attributes = new ArrayList<FluidAttribute>();
    private FluidState state = null;
    private int temperature = -1;
    private int color = -1;
    private boolean isColorEnabled = true;
    private int density = -1;
    private int luminosity = -1;
    private int viscosity = -1;
    private ResourceLocation still = null;
    private ResourceLocation flowing = null;
    private boolean hasCustomStill = false;
    private boolean hasCustomFlowing = false;
    private boolean hasFluidBlock = false;
    private boolean hasBucket = true;
    private String alternativeName = null;

    @NotNull
    public FluidBuilder name(@NotNull String name) {
        this.name = name;
        return this;
    }

    @NotNull
    public FluidBuilder translation(@NotNull String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    @NotNull
    public FluidBuilder state(@NotNull FluidState state) {
        this.state = state;
        return this;
    }

    @NotNull
    public FluidBuilder temperature(int temperature) {
        Preconditions.checkArgument((temperature > 0 ? 1 : 0) != 0, (Object)"temperature must be > 0");
        this.temperature = temperature;
        return this;
    }

    @NotNull
    public FluidBuilder color(int color) {
        this.color = GTUtility.convertRGBtoARGB(color);
        if (this.color == -1) {
            return this.disableColor();
        }
        return this;
    }

    @NotNull
    public FluidBuilder disableColor() {
        this.isColorEnabled = false;
        return this;
    }

    @NotNull
    public FluidBuilder density(int mcDensity) {
        this.density = mcDensity;
        return this;
    }

    @NotNull
    public FluidBuilder density(double density) {
        return this.density(FluidBuilder.convertToMCDensity(density));
    }

    private static int convertToMCDensity(double density) {
        if (density > 0.001225) {
            return (int)(1000.0 * density);
        }
        if (density < 0.001225) {
            return (int)(-0.1 / density);
        }
        return 0;
    }

    @NotNull
    public FluidBuilder luminosity(int luminosity) {
        Preconditions.checkArgument((luminosity >= 0 && luminosity < 16 ? 1 : 0) != 0, (Object)"luminosity must be >= 0 and < 16");
        this.luminosity = luminosity;
        return this;
    }

    @NotNull
    public FluidBuilder viscosity(int mcViscosity) {
        Preconditions.checkArgument((mcViscosity >= 0 ? 1 : 0) != 0, (Object)"viscosity must be >= 0");
        this.viscosity = mcViscosity;
        return this;
    }

    @NotNull
    public FluidBuilder viscosity(double viscosity) {
        return this.viscosity(FluidBuilder.convertViscosity(viscosity));
    }

    private static int convertViscosity(double viscosity) {
        return (int)(viscosity * 10000.0);
    }

    @NotNull
    public FluidBuilder attribute(@NotNull FluidAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    @NotNull
    public FluidBuilder attributes(FluidAttribute ... attributes) {
        Collections.addAll(this.attributes, attributes);
        return this;
    }

    @NotNull
    public FluidBuilder alternativeName(@NotNull String name) {
        this.alternativeName = name;
        return this;
    }

    @NotNull
    public FluidBuilder customStill() {
        this.hasCustomStill = true;
        this.isColorEnabled = false;
        return this;
    }

    @NotNull
    public FluidBuilder customFlow() {
        this.hasCustomFlowing = true;
        this.isColorEnabled = false;
        return this;
    }

    @NotNull
    public FluidBuilder textures(boolean hasCustomStill, boolean hasCustomFlowing) {
        this.hasCustomStill = hasCustomStill;
        this.hasCustomFlowing = hasCustomFlowing;
        this.isColorEnabled = false;
        return this;
    }

    @NotNull
    public FluidBuilder block() {
        this.hasFluidBlock = true;
        return this;
    }

    @NotNull
    public FluidBuilder disableBucket() {
        this.hasBucket = false;
        return this;
    }

    @NotNull
    public Fluid build(@NotNull String modid, @Nullable Material material, @Nullable FluidStorageKey key) {
        Fluid fluid;
        this.determineName(material, key);
        this.determineTextures(material, key, modid);
        if (this.name == null) {
            throw new IllegalStateException("Could not determine fluid name");
        }
        if (this.state == null) {
            this.state = key != null && key.getDefaultFluidState() != null ? key.getDefaultFluidState() : FluidState.LIQUID;
        }
        if ((fluid = FluidRegistry.getFluid((String)this.name)) == null && this.alternativeName != null) {
            fluid = FluidRegistry.getFluid((String)this.alternativeName);
        }
        boolean needsRegistration = false;
        if (fluid == null) {
            needsRegistration = true;
            if (material == null) {
                fluid = new GTFluid(this.name, this.still, this.flowing, this.state);
            } else if (key != null) {
                if (this.translationKey == null) {
                    this.translationKey = key.getTranslationKeyFor(material);
                }
                fluid = new GTFluid.GTMaterialFluid(this.name, this.still, this.flowing, this.state, this.translationKey, material);
            } else {
                throw new IllegalArgumentException("Fluids with materials must have a FluidStorageKey");
            }
        }
        if (fluid instanceof AttributedFluid) {
            AttributedFluid attrFluid = (AttributedFluid)fluid;
            this.attributes.forEach(attrFluid::addAttribute);
        } else if (!this.attributes.isEmpty()) {
            GTLog.logger.warn("Unable to set Fluid Attributes for Fluid {}, as it is owned by another mod! Skipping...");
        }
        this.determineTemperature(material);
        fluid.setTemperature(this.temperature);
        this.determineColor(material);
        if (this.isColorEnabled) {
            fluid.setColor(this.color);
        }
        this.determineDensity();
        fluid.setDensity(this.density);
        this.determineLuminosity(material);
        fluid.setLuminosity(this.luminosity);
        this.determineViscosity(material);
        fluid.setViscosity(this.viscosity);
        if (needsRegistration) {
            GTFluidRegistration.INSTANCE.registerFluid(fluid, modid, this.hasBucket);
        } else if (this.hasBucket) {
            FluidRegistry.addBucketForFluid((Fluid)fluid);
        }
        if (material != null) {
            FluidUnifier.registerFluid(fluid, material);
        }
        FluidTooltipUtil.registerTooltip(fluid, FluidTooltipUtil.createFluidTooltip(material, fluid, this.state));
        if (this.hasFluidBlock) {
            if (fluid.getBlock() == null) {
                GTFluidBlock block;
                if (material == null) {
                    GTFluidMaterial materialLiquid = new GTFluidMaterial(GTUtility.getMapColor(this.color), false);
                    block = new GTFluidBlock(fluid, materialLiquid, false, false, false);
                } else {
                    GTFluidMaterial materialLiquid = new GTFluidMaterial(GTUtility.getMapColor(this.color), material.hasFlag(MaterialFlags.STICKY));
                    block = new GTFluidBlock(fluid, materialLiquid, material);
                }
                block.setRegistryName(modid, "fluid." + this.name);
                GTFluidRegistration.INSTANCE.registerFluidBlock((BlockFluidBase)block);
                fluid.setBlock((Block)block);
            } else {
                Block block = fluid.getBlock();
                if (block instanceof BlockFluidBase) {
                    BlockFluidBase fluidBlock = (BlockFluidBase)block;
                    fluidBlock.setDensity(fluid.getDensity());
                    fluidBlock.setTemperature(fluid.getTemperature());
                    fluidBlock.setMaxScaledLight(fluid.getLuminosity());
                    fluidBlock.setTickRate(fluid.getViscosity() / 200);
                } else {
                    GTLog.logger.warn("Unable to set custom Fluid Block stats for Fluid {}, Fluid Block owned by other mod with unknown type!", (Object)fluid.getName());
                }
            }
        }
        if (Loader.isModLoaded((String)"topaddons")) {
            int displayColor = this.isColorEnabled || material == null ? this.color : material.getMaterialRGB();
            Colors.FLUID_NAME_COLOR_MAP.put(this.name, displayColor);
        }
        return fluid;
    }

    private void determineName(@Nullable Material material, @Nullable FluidStorageKey key) {
        if (this.name != null) {
            return;
        }
        if (material == null || key == null) {
            throw new IllegalArgumentException("Fluid must have a name");
        }
        this.name = key.getRegistryNameFor(material.getName());
    }

    private void determineTextures(@Nullable Material material, @Nullable FluidStorageKey key, @NotNull String modid) {
        this.still = material != null && key != null ? (this.hasCustomStill ? new ResourceLocation(modid, "blocks/fluids/fluid." + this.name) : key.getIconType().getBlockTexturePath(material.getMaterialIconSet())) : new ResourceLocation(modid, "blocks/fluids/fluid." + this.name);
        this.flowing = this.hasCustomFlowing ? new ResourceLocation(modid, "blocks/fluids/fluid." + this.name + "_flow") : this.still;
    }

    private void determineTemperature(@Nullable Material material) {
        if (this.temperature != -1) {
            return;
        }
        if (material == null) {
            this.temperature = 293;
        } else {
            BlastProperty property = material.getProperty(PropertyKey.BLAST);
            if (property == null) {
                int n;
                switch (this.state) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LIQUID: {
                        if (material.hasProperty(PropertyKey.DUST)) {
                            n = 1200;
                            break;
                        }
                        n = 293;
                        break;
                    }
                    case GAS: {
                        n = 293;
                        break;
                    }
                    case PLASMA: {
                        n = material.hasFluid() && material.getFluid() != null ? 10000 + material.getFluid().getTemperature() : 10000;
                    }
                }
                this.temperature = n;
            } else {
                int n;
                int n2 = property.getBlastTemperature();
                switch (this.state) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LIQUID: {
                        n = 0;
                        break;
                    }
                    case GAS: {
                        n = 100;
                        break;
                    }
                    case PLASMA: {
                        n = 10000;
                    }
                }
                this.temperature = n2 + n;
            }
        }
    }

    private void determineColor(@Nullable Material material) {
        if (this.color != -1) {
            return;
        }
        if (this.isColorEnabled && material != null) {
            this.color = GTUtility.convertRGBtoARGB(material.getMaterialRGB());
        }
    }

    private void determineDensity() {
        int n;
        if (this.density != -1) {
            return;
        }
        switch (this.state) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LIQUID: {
                n = 1000;
                break;
            }
            case GAS: {
                n = -100;
                break;
            }
            case PLASMA: {
                n = -100000;
            }
        }
        this.density = n;
    }

    private void determineLuminosity(@Nullable Material material) {
        if (this.luminosity != -1) {
            return;
        }
        if (this.state == FluidState.PLASMA) {
            this.luminosity = 15;
        } else if (material != null) {
            if (material.hasFlag(MaterialFlags.GLOWING)) {
                this.luminosity = 15;
            } else if (this.state == FluidState.LIQUID && material.hasProperty(PropertyKey.DUST)) {
                this.luminosity = 10;
            }
        }
    }

    private void determineViscosity(@Nullable Material material) {
        int n;
        if (this.viscosity != -1) {
            return;
        }
        switch (this.state) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LIQUID: {
                if (material != null && material.hasFlag(MaterialFlags.STICKY)) {
                    n = 2000;
                    break;
                }
                n = 1000;
                break;
            }
            case GAS: {
                n = 200;
                break;
            }
            case PLASMA: {
                n = 10;
            }
        }
        this.viscosity = n;
    }
}

