/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverRayTracer;
import gregtech.api.cover.CoverUtil;
import gregtech.api.cover.CoverableView;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.RenderUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CoverHolder
extends CoverableView {
    public static final Transformation REVERSE_HORIZONTAL_ROTATION = new Rotation(Math.PI, new Vector3(0.0, 1.0, 0.0)).at(Vector3.center);
    public static final Transformation REVERSE_VERTICAL_ROTATION = new Rotation(Math.PI, new Vector3(1.0, 0.0, 0.0)).at(Vector3.center);

    public void addCover(@NotNull EnumFacing var1, @NotNull Cover var2);

    public boolean canPlaceCoverOnSide(@NotNull EnumFacing var1);

    public boolean acceptsCovers();

    public void removeCover(@NotNull EnumFacing var1);

    default public void dropAllCovers() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.dropCover(side);
        }
    }

    default public void dropCover(@NotNull EnumFacing side) {
        Cover cover = this.getCoverAtSide(side);
        if (cover == null) {
            return;
        }
        List<ItemStack> drops = cover.getDrops();
        cover.onRemoval();
        for (ItemStack dropStack : drops) {
            Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)dropStack);
        }
    }

    default public void updateCovers() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Cover cover = this.getCoverAtSide(facing);
            if (!(cover instanceof ITickable)) continue;
            ITickable tickable = (ITickable)cover;
            tickable.func_73660_a();
        }
    }

    public void writeCustomData(int var1, @NotNull @NotNull Consumer<@NotNull PacketBuffer> var2);

    public double getCoverPlateThickness();

    public boolean shouldRenderCoverBackSides();

    @SideOnly(value=Side.CLIENT)
    public int getPaintingColorForRendering();

    @SideOnly(value=Side.CLIENT)
    default public void renderCovers(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, @NotNull BlockRenderLayer layer) {
        renderState.lightMatrix.locate((IBlockAccess)this.getWorld(), this.getPos());
        double coverPlateThickness = this.getCoverPlateThickness();
        IVertexOperation[] platePipeline = new IVertexOperation[]{renderState.lightMatrix, new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))};
        IVertexOperation[] coverPipeline = new IVertexOperation[]{renderState.lightMatrix};
        for (EnumFacing sideFacing : EnumFacing.values()) {
            Cover cover = this.getCoverAtSide(sideFacing);
            if (cover == null) continue;
            Cuboid6 plateBox = CoverUtil.getCoverPlateBox(sideFacing, coverPlateThickness);
            if (cover.canRenderInLayer(layer) && coverPlateThickness > 0.0) {
                renderState.preRenderWorld((IBlockAccess)this.getWorld(), this.getPos());
                cover.renderCoverPlate(renderState, translation, platePipeline, plateBox, layer);
            }
            if (!cover.canRenderInLayer(layer)) continue;
            cover.renderCover(renderState, RenderUtil.adjustTrans(translation, sideFacing, 2), coverPipeline, plateBox, layer);
            if (coverPlateThickness != 0.0 || !this.shouldRenderCoverBackSides() || !cover.canRenderBackside()) continue;
            Matrix4 backTranslation = translation.copy();
            if (sideFacing.func_176740_k().func_176720_b()) {
                REVERSE_VERTICAL_ROTATION.apply(backTranslation);
            } else {
                REVERSE_HORIZONTAL_ROTATION.apply(backTranslation);
            }
            backTranslation.translate((double)(-sideFacing.func_82601_c()), (double)(-sideFacing.func_96559_d()), (double)(-sideFacing.func_82599_e()));
            cover.renderCover(renderState, backTranslation, coverPipeline, plateBox, layer);
        }
    }

    default public void addCoverCollisionBoundingBox(@NotNull List<? super IndexedCuboid6> collisionList) {
        double plateThickness = this.getCoverPlateThickness();
        if (plateThickness > 0.0) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (this.getCoverAtSide(side) == null) continue;
                Cuboid6 coverBox = CoverUtil.getCoverPlateBox(side, plateThickness);
                CoverRayTracer.CoverSideData coverSideData = new CoverRayTracer.CoverSideData(side);
                collisionList.add((IndexedCuboid6)new IndexedCuboid6((Object)coverSideData, coverBox));
            }
        }
    }

    default public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }
}

