/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl.miner;

import gregtech.api.capability.impl.miner.MinerLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.renderer.ICubeRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class MultiblockMinerLogic
extends MinerLogic {
    private static final int CHUNK_LENGTH = 16;
    private final RecipeMap<?> blockDropRecipeMap;
    private int voltageTier;
    private int overclockAmount = 0;
    private boolean isChunkMode;
    private boolean isSilkTouchMode;

    public MultiblockMinerLogic(MetaTileEntity metaTileEntity, int fortune, int speed, int maximumRadius, RecipeMap<?> blockDropRecipeMap) {
        super(metaTileEntity, fortune, speed, maximumRadius, null);
        this.blockDropRecipeMap = blockDropRecipeMap;
    }

    @Override
    protected boolean drainStorages(boolean simulate) {
        return super.drainStorages(simulate) && this.miner.drainFluid(simulate);
    }

    @Override
    protected void getSmallOreBlockDrops(NonNullList<ItemStack> blockDrops, WorldServer world, BlockPos blockToMine, IBlockState blockState) {
        super.getSmallOreBlockDrops(blockDrops, world, blockToMine, blockState);
    }

    @Override
    protected void getRegularBlockDrops(NonNullList<ItemStack> blockDrops, WorldServer world, BlockPos blockToMine, @NotNull IBlockState blockState) {
        if (!this.isSilkTouchMode) {
            MultiblockMinerLogic.applyTieredHammerNoRandomDrops(blockState, blockDrops, 3, this.blockDropRecipeMap, this.voltageTier);
        } else {
            super.getRegularBlockDrops(blockDrops, world, blockToMine, blockState);
        }
    }

    @Override
    public void initPos(@NotNull BlockPos pos, int currentRadius) {
        if (!this.isChunkMode) {
            super.initPos(pos, currentRadius);
        } else {
            WorldServer world = (WorldServer)this.metaTileEntity.getWorld();
            Chunk origin = world.func_175726_f(this.metaTileEntity.getPos());
            ChunkPos startPos = world.func_72964_e(origin.field_76635_g - currentRadius / 16, origin.field_76647_h - currentRadius / 16).func_76632_l();
            this.getX().set(startPos.func_180334_c());
            this.getY().set(this.metaTileEntity.getPos().func_177956_o() - 1);
            this.getZ().set(startPos.func_180333_d());
            this.getStartX().set(startPos.func_180334_c());
            this.getStartY().set(this.metaTileEntity.getPos().func_177956_o());
            this.getStartZ().set(startPos.func_180333_d());
            this.getMineX().set(startPos.func_180334_c());
            this.getMineY().set(this.metaTileEntity.getPos().func_177956_o() - 1);
            this.getMineZ().set(startPos.func_180333_d());
            this.getPipeY().set(this.metaTileEntity.getPos().func_177956_o() - 1);
        }
    }

    public void setVoltageTier(int tier) {
        this.voltageTier = tier;
    }

    public void setOverclockAmount(int amount) {
        this.overclockAmount = amount;
    }

    public int getOverclockAmount() {
        return this.overclockAmount;
    }

    public boolean isChunkMode() {
        return this.isChunkMode;
    }

    public void setChunkMode(boolean isChunkMode) {
        if (!this.isWorking()) {
            this.isChunkMode = isChunkMode;
            if (!this.metaTileEntity.getWorld().field_72995_K) {
                this.resetArea();
            }
        }
    }

    public boolean isSilkTouchMode() {
        return this.isSilkTouchMode;
    }

    public void setSilkTouchMode(boolean isSilkTouchMode) {
        if (!this.isWorking()) {
            this.isSilkTouchMode = isSilkTouchMode;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ICubeRenderer getPipeTexture() {
        return ((MultiblockControllerBase)this.metaTileEntity).getBaseTexture(null);
    }

    @Override
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        data.func_74757_a("isChunkMode", this.isChunkMode);
        data.func_74757_a("isSilkTouchMode", this.isSilkTouchMode);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound data) {
        this.isChunkMode = data.func_74767_n("isChunkMode");
        this.isSilkTouchMode = data.func_74767_n("isSilkTouchMode");
        super.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isChunkMode);
        buf.writeBoolean(this.isSilkTouchMode);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isChunkMode = buf.readBoolean();
        this.isSilkTouchMode = buf.readBoolean();
    }
}

