/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl.miner;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IMiner;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MinerLogic {
    private static final short MAX_SPEED = Short.MAX_VALUE;
    private static final byte POWER = 5;
    private static final byte TICK_TOLERANCE = 20;
    private static final double DIVIDEND = 32767.0 * Math.pow(20.0, 5.0);
    protected final MetaTileEntity metaTileEntity;
    protected final IMiner miner;
    private final int fortune;
    private final int speed;
    private final int maximumRadius;
    private final ICubeRenderer PIPE_TEXTURE;
    private final LinkedList<BlockPos> blocksToMine = new LinkedList();
    private final AtomicInteger x = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger y = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger z = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger startX = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger startZ = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger startY = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger pipeY = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger mineX = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger mineZ = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger mineY = new AtomicInteger(Integer.MAX_VALUE);
    private int pipeLength = 0;
    private int currentRadius;
    private boolean isDone;
    private boolean isActive = false;
    private boolean isWorkingEnabled = true;
    protected boolean wasActiveAndNeedsUpdate;
    private final IBlockState oreReplacementBlock = MinerLogic.findMiningReplacementBlock();

    public MinerLogic(@NotNull MetaTileEntity metaTileEntity, int fortune, int speed, int maximumRadius, ICubeRenderer pipeTexture) {
        this.metaTileEntity = metaTileEntity;
        this.miner = (IMiner)((Object)metaTileEntity);
        this.fortune = fortune;
        this.speed = speed;
        this.currentRadius = maximumRadius;
        this.maximumRadius = maximumRadius;
        this.isDone = false;
        this.PIPE_TEXTURE = pipeTexture;
    }

    private static IBlockState findMiningReplacementBlock() {
        String[] blockDescription = StringUtils.split((String)ConfigHolder.machines.replaceMinedBlocksWith, (String)":");
        Block replacementBlock = blockDescription.length == 2 ? Block.func_149684_b((String)ConfigHolder.machines.replaceMinedBlocksWith) : Block.func_149684_b((String)String.format("%s:%s", blockDescription[0], blockDescription[1]));
        if (replacementBlock == null) {
            GTLog.logger.error("Miner Config Replacement block was null, replacing with Cobblestone");
            return Blocks.field_150347_e.func_176223_P();
        }
        if (blockDescription.length > 2 && !blockDescription[2].isEmpty()) {
            return replacementBlock.func_176223_P().func_177230_c().func_176203_a(Integer.parseInt(blockDescription[2]));
        }
        return replacementBlock.func_176223_P();
    }

    public void performMining() {
        if (this.metaTileEntity.getWorld().field_72995_K) {
            return;
        }
        if (!this.isWorkingEnabled) {
            return;
        }
        if (!this.checkCanMine()) {
            return;
        }
        if (!this.miner.isInventoryFull()) {
            this.drainStorages(false);
            if (!this.isActive) {
                this.setActive(true);
            }
        } else if (this.isActive) {
            this.setActive(false);
        }
        WorldServer world = (WorldServer)this.metaTileEntity.getWorld();
        if (this.mineY.get() < this.pipeY.get()) {
            world.func_175655_b(new BlockPos(this.metaTileEntity.getPos().func_177958_n(), this.pipeY.get(), this.metaTileEntity.getPos().func_177952_p()), false);
            this.pipeY.decrementAndGet();
            this.incrementPipeLength();
        }
        this.checkBlocksToMine();
        if (this.metaTileEntity.getOffsetTimer() % (long)this.speed == 0L && !this.blocksToMine.isEmpty()) {
            NonNullList blockDrops = NonNullList.func_191196_a();
            IBlockState blockState = this.metaTileEntity.getWorld().func_180495_p(this.blocksToMine.getFirst());
            while (!GTUtility.isOre(GTUtility.toItem(blockState))) {
                this.blocksToMine.removeFirst();
                if (this.blocksToMine.isEmpty()) break;
                blockState = this.metaTileEntity.getWorld().func_180495_p(this.blocksToMine.getFirst());
            }
            if (!this.blocksToMine.isEmpty() & GTUtility.isOre(GTUtility.toItem(blockState))) {
                this.getSmallOreBlockDrops((NonNullList<ItemStack>)blockDrops, world, this.blocksToMine.getFirst(), blockState);
                this.getRegularBlockDrops((NonNullList<ItemStack>)blockDrops, world, this.blocksToMine.getFirst(), blockState);
                this.mineAndInsertItems((NonNullList<ItemStack>)blockDrops, world);
            }
        }
        if (this.blocksToMine.isEmpty()) {
            this.x.set(this.mineX.get());
            this.y.set(this.mineY.get());
            this.z.set(this.mineZ.get());
            this.blocksToMine.addAll(this.getBlocksToMine());
            if (this.blocksToMine.isEmpty()) {
                this.isDone = true;
                this.wasActiveAndNeedsUpdate = true;
                this.setActive(false);
            }
        }
    }

    protected boolean checkCanMine() {
        if (this.checkShouldStop()) {
            if (!this.isDone && MinerLogic.checkCoordinatesInvalid(this.x, this.y, this.z)) {
                this.initPos(this.metaTileEntity.getPos(), this.currentRadius);
            }
            return false;
        }
        return true;
    }

    protected boolean checkShouldStop() {
        return this.isDone || MinerLogic.checkCoordinatesInvalid(this.x, this.y, this.z) || !this.drainStorages(true);
    }

    protected void onMineOperation() {
    }

    protected boolean drainStorages(boolean simulate) {
        return this.miner.drainEnergy(simulate);
    }

    protected void getSmallOreBlockDrops(NonNullList<ItemStack> blockDrops, WorldServer world, BlockPos blockToMine, IBlockState blockState) {
    }

    protected void getRegularBlockDrops(NonNullList<ItemStack> blockDrops, WorldServer world, BlockPos blockToMine, @NotNull IBlockState blockState) {
        blockState.func_177230_c().getDrops(blockDrops, (IBlockAccess)world, blockToMine, blockState, 0);
    }

    private void mineAndInsertItems(NonNullList<ItemStack> blockDrops, WorldServer world) {
        if (GTTransferUtils.addItemsToItemHandler((IItemHandler)this.metaTileEntity.getExportItems(), true, blockDrops)) {
            GTTransferUtils.addItemsToItemHandler((IItemHandler)this.metaTileEntity.getExportItems(), false, blockDrops);
            world.func_175656_a(this.blocksToMine.getFirst(), this.oreReplacementBlock);
            this.mineX.set(this.blocksToMine.getFirst().func_177958_n());
            this.mineZ.set(this.blocksToMine.getFirst().func_177952_p());
            this.mineY.set(this.blocksToMine.getFirst().func_177956_o());
            this.blocksToMine.removeFirst();
            this.onMineOperation();
            if (this.miner.isInventoryFull()) {
                this.miner.setInventoryFull(false);
            }
        } else {
            this.miner.setInventoryFull(true);
        }
    }

    public void initPos(@NotNull BlockPos pos, int currentRadius) {
        this.x.set(pos.func_177958_n() - currentRadius);
        this.z.set(pos.func_177952_p() - currentRadius);
        this.y.set(pos.func_177956_o() - 1);
        this.startX.set(pos.func_177958_n() - currentRadius);
        this.startZ.set(pos.func_177952_p() - currentRadius);
        this.startY.set(pos.func_177956_o());
        this.pipeY.set(pos.func_177956_o() - 1);
        this.mineX.set(pos.func_177958_n() - currentRadius);
        this.mineZ.set(pos.func_177952_p() - currentRadius);
        this.mineY.set(pos.func_177956_o() - 1);
    }

    private static boolean checkCoordinatesInvalid(@NotNull AtomicInteger x, @NotNull AtomicInteger y, @NotNull AtomicInteger z) {
        return x.get() == Integer.MAX_VALUE && y.get() == Integer.MAX_VALUE && z.get() == Integer.MAX_VALUE;
    }

    public void checkBlocksToMine() {
        if (this.blocksToMine.isEmpty()) {
            this.blocksToMine.addAll(this.getBlocksToMine());
        }
    }

    public void resetArea() {
        this.initPos(this.metaTileEntity.getPos(), this.currentRadius);
        if (this.isDone) {
            this.setWorkingEnabled(false);
        }
        this.isDone = false;
        this.blocksToMine.clear();
        this.checkBlocksToMine();
        this.resetPipeLength();
    }

    private LinkedList<BlockPos> getBlocksToMine() {
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        double quotient = MinerLogic.getQuotient(MinerLogic.getMeanTickTime(this.metaTileEntity.getWorld()));
        int calcAmount = quotient < 1.0 ? 1 : (int)Math.min(quotient, 32767.0);
        int calculated = 0;
        while (calculated < calcAmount) {
            if (this.y.get() > 0) {
                if (this.z.get() <= this.startZ.get() + this.currentRadius * 2) {
                    if (this.x.get() <= this.startX.get() + this.currentRadius * 2) {
                        BlockPos blockPos = new BlockPos(this.x.get(), this.y.get(), this.z.get());
                        IBlockState state = this.metaTileEntity.getWorld().func_180495_p(blockPos);
                        if (state.func_177230_c().field_149782_v >= 0.0f && this.metaTileEntity.getWorld().func_175625_s(blockPos) == null && GTUtility.isOre(GTUtility.toItem(state))) {
                            blocks.addLast(blockPos);
                        }
                        this.x.incrementAndGet();
                    } else {
                        this.x.set(this.startX.get());
                        this.z.incrementAndGet();
                    }
                } else {
                    this.z.set(this.startZ.get());
                    this.y.decrementAndGet();
                }
            } else {
                return blocks;
            }
            if (blocks.isEmpty()) continue;
            ++calculated;
        }
        return blocks;
    }

    private static long mean(@NotNull long[] values) {
        if ((long)values.length == 0L) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private static double getMeanTickTime(@NotNull World world) {
        return (double)MinerLogic.mean(Objects.requireNonNull(world.func_73046_m()).field_71311_j) * 1.0E-6;
    }

    private static double getQuotient(double base) {
        return DIVIDEND / Math.pow(base, 5.0);
    }

    protected static void applyTieredHammerNoRandomDrops(@NotNull IBlockState blockState, List<ItemStack> drops, int fortuneLevel, @NotNull RecipeMap<?> map, int tier) {
        ItemStack itemStack = GTUtility.toItem(blockState);
        Recipe recipe = map.findRecipe(Long.MAX_VALUE, Collections.singletonList(itemStack), Collections.emptyList());
        if (recipe != null && !recipe.getOutputs().isEmpty()) {
            drops.clear();
            for (ItemStack outputStack : recipe.getResultItemOutputs(GTUtility.getTierByVoltage(recipe.getEUt()), tier, map)) {
                if (OreDictUnifier.getPrefix(outputStack = outputStack.func_77946_l()) == OrePrefix.crushed && fortuneLevel > 0) {
                    outputStack.func_190917_f(outputStack.func_190916_E() * fortuneLevel);
                }
                drops.add(outputStack);
            }
        }
    }

    private void incrementPipeLength() {
        ++this.pipeLength;
        this.metaTileEntity.writeCustomData(GregtechDataCodes.PUMP_HEAD_LEVEL, b -> b.writeInt(this.pipeLength));
        this.metaTileEntity.markDirty();
    }

    private void resetPipeLength() {
        this.pipeLength = 0;
        this.metaTileEntity.writeCustomData(GregtechDataCodes.PUMP_HEAD_LEVEL, b -> b.writeInt(this.pipeLength));
        this.metaTileEntity.markDirty();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPipe(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.PIPE_IN_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
        for (int i = 0; i < this.pipeLength; ++i) {
            translation.translate(0.0, -1.0, 0.0);
            this.getPipeTexture().render(renderState, translation, pipeline, IMiner.PIPE_CUBOID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected ICubeRenderer getPipeTexture() {
        return this.PIPE_TEXTURE;
    }

    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        data.func_74782_a("xPos", (NBTBase)new NBTTagInt(this.x.get()));
        data.func_74782_a("yPos", (NBTBase)new NBTTagInt(this.y.get()));
        data.func_74782_a("zPos", (NBTBase)new NBTTagInt(this.z.get()));
        data.func_74782_a("mxPos", (NBTBase)new NBTTagInt(this.mineX.get()));
        data.func_74782_a("myPos", (NBTBase)new NBTTagInt(this.mineY.get()));
        data.func_74782_a("mzPos", (NBTBase)new NBTTagInt(this.mineZ.get()));
        data.func_74782_a("sxPos", (NBTBase)new NBTTagInt(this.startX.get()));
        data.func_74782_a("syPos", (NBTBase)new NBTTagInt(this.startY.get()));
        data.func_74782_a("szPos", (NBTBase)new NBTTagInt(this.startZ.get()));
        data.func_74782_a("tempY", (NBTBase)new NBTTagInt(this.pipeY.get()));
        data.func_74782_a("isActive", (NBTBase)new NBTTagInt(this.isActive ? 1 : 0));
        data.func_74782_a("isWorkingEnabled", (NBTBase)new NBTTagInt(this.isWorkingEnabled ? 1 : 0));
        data.func_74782_a("wasActiveAndNeedsUpdate", (NBTBase)new NBTTagInt(this.wasActiveAndNeedsUpdate ? 1 : 0));
        data.func_74782_a("pipeLength", (NBTBase)new NBTTagInt(this.pipeLength));
        data.func_74782_a("currentRadius", (NBTBase)new NBTTagInt(this.currentRadius));
        data.func_74782_a("isDone", (NBTBase)new NBTTagInt(this.isDone ? 1 : 0));
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        this.x.set(data.func_74762_e("xPos"));
        this.y.set(data.func_74762_e("yPos"));
        this.z.set(data.func_74762_e("zPos"));
        this.mineX.set(data.func_74762_e("mxPos"));
        this.mineY.set(data.func_74762_e("myPos"));
        this.mineZ.set(data.func_74762_e("mzPos"));
        this.startX.set(data.func_74762_e("sxPos"));
        this.startY.set(data.func_74762_e("syPos"));
        this.startZ.set(data.func_74762_e("szPos"));
        this.pipeY.set(data.func_74762_e("tempY"));
        this.setActive(data.func_74762_e("isActive") != 0);
        this.setWorkingEnabled(data.func_74762_e("isWorkingEnabled") != 0);
        this.setWasActiveAndNeedsUpdate(data.func_74762_e("wasActiveAndNeedsUpdate") != 0);
        this.pipeLength = data.func_74762_e("pipeLength");
        this.currentRadius = data.func_74762_e("currentRadius");
        this.isDone = data.func_74762_e("isDone") != 0;
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        buf.writeInt(this.pipeLength);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
        buf.writeBoolean(this.wasActiveAndNeedsUpdate);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        this.pipeLength = buf.readInt();
        this.setActive(buf.readBoolean());
        this.setWorkingEnabled(buf.readBoolean());
        this.setWasActiveAndNeedsUpdate(buf.readBoolean());
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == GregtechDataCodes.PUMP_HEAD_LEVEL) {
            this.pipeLength = buf.readInt();
            this.metaTileEntity.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.metaTileEntity.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.metaTileEntity.scheduleRenderUpdate();
        }
    }

    public AtomicInteger getX() {
        return this.x;
    }

    public AtomicInteger getY() {
        return this.y;
    }

    public AtomicInteger getZ() {
        return this.z;
    }

    public AtomicInteger getMineX() {
        return this.mineX;
    }

    public AtomicInteger getMineY() {
        return this.mineY;
    }

    public AtomicInteger getMineZ() {
        return this.mineZ;
    }

    public AtomicInteger getStartX() {
        return this.startX;
    }

    public AtomicInteger getStartY() {
        return this.startY;
    }

    public AtomicInteger getStartZ() {
        return this.startZ;
    }

    public AtomicInteger getPipeY() {
        return this.pipeY;
    }

    public int getMaximumRadius() {
        return this.maximumRadius;
    }

    public int getCurrentRadius() {
        return this.currentRadius;
    }

    public void setCurrentRadius(int currentRadius) {
        this.currentRadius = currentRadius;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        if (this.isActive != isActive) {
            this.isActive = isActive;
            this.metaTileEntity.markDirty();
            if (this.metaTileEntity.getWorld() != null && !this.metaTileEntity.getWorld().field_72995_K) {
                this.metaTileEntity.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(isActive));
            }
        }
    }

    public void setWorkingEnabled(boolean isWorkingEnabled) {
        if (this.isWorkingEnabled != isWorkingEnabled) {
            this.isWorkingEnabled = isWorkingEnabled;
            this.metaTileEntity.markDirty();
            if (this.metaTileEntity.getWorld() != null && !this.metaTileEntity.getWorld().field_72995_K) {
                if (!isWorkingEnabled) {
                    this.resetArea();
                }
                this.metaTileEntity.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(isWorkingEnabled));
            }
        }
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public boolean isWorking() {
        return this.isActive && this.isWorkingEnabled;
    }

    public boolean wasActiveAndNeedsUpdate() {
        return this.wasActiveAndNeedsUpdate;
    }

    public void setWasActiveAndNeedsUpdate(boolean wasActiveAndNeedsUpdate) {
        this.wasActiveAndNeedsUpdate = wasActiveAndNeedsUpdate;
    }

    public int getFortune() {
        return this.fortune;
    }

    public int getSpeed() {
        return this.speed;
    }
}

