/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IFilter;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public final class SingleFluidFilter
implements IFilter<FluidStack> {
    private final FluidStack fluid;
    private final boolean blacklist;

    public SingleFluidFilter(@NotNull FluidStack fluid, boolean blacklist) {
        this.fluid = fluid;
        this.blacklist = blacklist;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluid;
    }

    public boolean isWhitelist() {
        return !this.blacklist;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean test(@NotNull FluidStack fluid) {
        return this.fluid.isFluidEqual(fluid) != this.blacklist;
    }

    @Override
    public int getPriority() {
        return this.blacklist ? IFilter.blacklistPriority(1) : IFilter.whitelistPriority(1);
    }

    @Override
    public IFilter<FluidStack> negate() {
        return new SingleFluidFilter(this.fluid, !this.blacklist);
    }

    public String toString() {
        return "SingleFluidFilter{fluid=" + this.fluid + ", blacklist=" + this.blacklist + '}';
    }
}

