/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IRotorHolder;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.util.TextFormattingUtil;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MultiblockFuelRecipeLogic
extends MultiblockRecipeLogic {
    protected long totalContinuousRunningTime;

    public MultiblockFuelRecipeLogic(RecipeMapMultiblockController tileEntity) {
        super(tileEntity);
    }

    @Override
    protected void modifyOverclockPre(@NotNull int[] values, @NotNull IRecipePropertyStorage storage) {
        Tuple<Integer, Double> maintenanceValues = this.getMaintenanceValues();
        if ((Double)maintenanceValues.func_76340_b() != 1.0) {
            values[1] = (int)Math.round((double)values[1] / (Double)maintenanceValues.func_76340_b());
        }
    }

    @Override
    protected void modifyOverclockPost(int[] overclockResults, @NotNull IRecipePropertyStorage storage) {
        Tuple<Integer, Double> maintenanceValues = this.getMaintenanceValues();
        if ((Integer)maintenanceValues.func_76341_a() > 0) {
            overclockResults[1] = (int)((double)overclockResults[1] * (1.0 - 0.1 * (double)((Integer)maintenanceValues.func_76341_a()).intValue()));
        }
        overclockResults[0] = -overclockResults[0];
    }

    @Override
    @NotNull
    public ParallelLogicType getParallelLogicType() {
        return ParallelLogicType.MULTIPLY;
    }

    @Override
    protected boolean hasEnoughPower(@NotNull int[] resultOverclock) {
        return true;
    }

    @Override
    public void update() {
        super.update();
        this.totalContinuousRunningTime = this.workingEnabled && this.isActive && this.progressTime > 0 ? ++this.totalContinuousRunningTime : 0L;
    }

    @Override
    public int getParallelLimit() {
        return Integer.MAX_VALUE;
    }

    protected long boostProduction(long production) {
        return production;
    }

    @Override
    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        long euToDraw = this.boostProduction(recipeEUt);
        long resultEnergy = this.getEnergyStored() - euToDraw;
        if (resultEnergy >= 0L && resultEnergy <= this.getEnergyCapacity()) {
            if (!simulate) {
                this.getEnergyContainer().changeEnergy(-euToDraw);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getInfoProviderEUt() {
        return (int)this.boostProduction(super.getInfoProviderEUt());
    }

    @Override
    public boolean consumesEnergy() {
        return false;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.totalContinuousRunningTime = 0L;
    }

    public String getRecipeFluidInputInfo() {
        Recipe recipe;
        IRotorHolder rotorHolder = null;
        MetaTileEntity metaTileEntity = this.metaTileEntity;
        if (metaTileEntity instanceof MultiblockWithDisplayBase) {
            MultiblockWithDisplayBase multiblockWithDisplayBase = (MultiblockWithDisplayBase)metaTileEntity;
            List<IRotorHolder> abilities = multiblockWithDisplayBase.getAbilities(MultiblockAbility.ROTOR_HOLDER);
            IRotorHolder iRotorHolder = rotorHolder = abilities.size() > 0 ? abilities.get(0) : null;
        }
        if (this.previousRecipe == null) {
            recipe = this.findRecipe(Integer.MAX_VALUE, this.getInputInventory(), this.getInputTank());
            if (recipe == null) {
                return null;
            }
        } else {
            recipe = this.previousRecipe;
        }
        FluidStack requiredFluidInput = recipe.getFluidInputs().get(0).getInputFluidStack();
        int ocAmount = (int)(this.getMaxVoltage() / (long)recipe.getEUt());
        int neededAmount = ocAmount * requiredFluidInput.amount;
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            neededAmount = (int)((float)neededAmount / ((float)rotorHolder.getTotalEfficiency() / 100.0f));
        } else if (rotorHolder != null && !rotorHolder.hasRotor()) {
            return null;
        }
        return TextFormatting.RED + TextFormattingUtil.formatNumbers(neededAmount) + "L";
    }

    public FluidStack getInputFluidStack() {
        if (this.previousRecipe == null) {
            Recipe recipe = this.findRecipe(Integer.MAX_VALUE, this.getInputInventory(), this.getInputTank());
            return recipe == null ? null : this.getInputTank().drain(new FluidStack(recipe.getFluidInputs().get(0).getInputFluidStack().getFluid(), Integer.MAX_VALUE), false);
        }
        FluidStack fuelStack = this.previousRecipe.getFluidInputs().get(0).getInputFluidStack();
        return this.getInputTank().drain(new FluidStack(fuelStack.getFluid(), Integer.MAX_VALUE), false);
    }

    @Override
    public boolean isAllowOverclocking() {
        return false;
    }
}

