/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IFilter;
import gregtech.api.capability.IFilteredFluidContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTFluidHandlerItemStack
extends FluidHandlerItemStack
implements IFilteredFluidContainer {
    @Nullable
    private IFilter<FluidStack> filter;
    private boolean canFill = true;
    private boolean canDrain = true;
    @Nullable
    private IFluidTankProperties[] properties;

    public GTFluidHandlerItemStack(@NotNull ItemStack container, int capacity) {
        super(container, capacity);
    }

    @Override
    @Nullable
    public IFilter<FluidStack> getFilter() {
        return this.filter;
    }

    @NotNull
    public GTFluidHandlerItemStack setFilter(@Nullable IFilter<FluidStack> filter) {
        this.filter = filter;
        return this;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public GTFluidHandlerItemStack setCanFill(boolean canFill) {
        this.canFill = canFill;
        return this;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public GTFluidHandlerItemStack setCanDrain(boolean canDrain) {
        this.canDrain = canDrain;
        return this;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.properties == null) {
            this.properties = new IFluidTankProperties[]{new TankProperties()};
            return this.properties;
        }
        return this.properties;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained = super.drain(resource, doDrain);
        this.removeTagWhenEmpty(doDrain);
        return drained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        this.removeTagWhenEmpty(doDrain);
        return drained;
    }

    private void removeTagWhenEmpty(boolean doDrain) {
        if (doDrain && this.getFluid() == null) {
            this.container.func_77982_d(null);
        }
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.canFill() && (this.filter == null || this.filter.test(fluid));
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.canDrain();
    }

    private final class TankProperties
    implements IFluidTankProperties {
        private TankProperties() {
        }

        @Nullable
        public FluidStack getContents() {
            return GTFluidHandlerItemStack.this.getFluid();
        }

        public int getCapacity() {
            return GTFluidHandlerItemStack.this.capacity;
        }

        public boolean canFill() {
            return GTFluidHandlerItemStack.this.canFill();
        }

        public boolean canDrain() {
            return GTFluidHandlerItemStack.this.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return GTFluidHandlerItemStack.this.canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return GTFluidHandlerItemStack.this.canDrainFluidType(fluidStack);
        }
    }
}

