/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.ICleanroomReceiver;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.IParallelableRecipeLogic;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.recipeproperties.CleanroomProperty;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeLogic
extends MTETrait
implements IWorkable,
IParallelableRecipeLogic {
    private static final String ALLOW_OVERCLOCKING = "AllowOverclocking";
    private static final String OVERCLOCK_VOLTAGE = "OverclockVoltage";
    private final RecipeMap<?> recipeMap;
    protected Recipe previousRecipe;
    private boolean allowOverclocking = true;
    protected int parallelRecipesPerformed;
    private long overclockVoltage = 0L;
    protected int[] overclockResults;
    protected boolean canRecipeProgress = true;
    protected int progressTime;
    protected int maxProgressTime;
    protected int recipeEUt;
    protected List<FluidStack> fluidOutputs;
    protected NonNullList<ItemStack> itemOutputs;
    protected boolean isActive;
    protected boolean workingEnabled = true;
    protected boolean hasNotEnoughEnergy;
    protected boolean wasActiveAndNeedsUpdate;
    protected boolean isOutputsFull;
    protected boolean invalidInputsForRecipes;
    protected boolean hasPerfectOC = false;
    private int parallelLimit = 1;

    public AbstractRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap) {
        super(tileEntity);
        this.recipeMap = recipeMap;
    }

    public AbstractRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, boolean hasPerfectOC) {
        super(tileEntity);
        this.recipeMap = recipeMap;
        this.hasPerfectOC = hasPerfectOC;
    }

    protected abstract long getEnergyInputPerSecond();

    protected abstract long getEnergyStored();

    protected abstract long getEnergyCapacity();

    protected abstract boolean drawEnergy(int var1, boolean var2);

    public abstract long getMaxVoltage();

    protected long getMaxParallelVoltage() {
        return this.getMaxVoltage();
    }

    protected IItemHandlerModifiable getInputInventory() {
        return this.metaTileEntity.getImportItems();
    }

    protected IItemHandlerModifiable getOutputInventory() {
        return this.metaTileEntity.getExportItems();
    }

    protected IMultipleTankHandler getInputTank() {
        return this.metaTileEntity.getImportFluids();
    }

    protected IMultipleTankHandler getOutputTank() {
        return this.metaTileEntity.getExportFluids();
    }

    public boolean consumesEnergy() {
        return true;
    }

    @Override
    @NotNull
    public final String getName() {
        return "RecipeMapWorkable";
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC) {
            return (T)GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC.cast((Object)this);
        }
        return null;
    }

    @Override
    public void update() {
        World world = this.getMetaTileEntity().getWorld();
        if (world != null && !world.field_72995_K) {
            if (this.workingEnabled) {
                if (this.getMetaTileEntity().getOffsetTimer() % 20L == 0L) {
                    this.canRecipeProgress = this.canProgressRecipe();
                }
                if (this.progressTime > 0) {
                    this.updateRecipeProgress();
                }
                if (this.progressTime == 0 && this.shouldSearchForRecipes()) {
                    this.trySearchNewRecipe();
                }
            }
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
                this.setActive(false);
            }
        }
    }

    @Override
    @Nullable
    public RecipeMap<?> getRecipeMap() {
        return this.recipeMap;
    }

    @Nullable
    public Recipe getPreviousRecipe() {
        return this.previousRecipe;
    }

    protected boolean shouldSearchForRecipes() {
        return this.canWorkWithInputs() && this.canFitNewOutputs();
    }

    protected boolean hasNotifiedInputs() {
        return this.metaTileEntity.getNotifiedItemInputList().size() > 0 || this.metaTileEntity.getNotifiedFluidInputList().size() > 0;
    }

    protected boolean hasNotifiedOutputs() {
        return this.metaTileEntity.getNotifiedItemOutputList().size() > 0 || this.metaTileEntity.getNotifiedFluidOutputList().size() > 0;
    }

    protected boolean canFitNewOutputs() {
        if (this.isOutputsFull && !this.hasNotifiedOutputs()) {
            return false;
        }
        this.isOutputsFull = false;
        this.metaTileEntity.getNotifiedItemOutputList().clear();
        this.metaTileEntity.getNotifiedFluidOutputList().clear();
        return true;
    }

    protected boolean canWorkWithInputs() {
        if (this.invalidInputsForRecipes && !this.hasNotifiedInputs()) {
            return false;
        }
        this.isOutputsFull = false;
        this.invalidInputsForRecipes = false;
        this.metaTileEntity.getNotifiedItemInputList().clear();
        this.metaTileEntity.getNotifiedFluidInputList().clear();
        return true;
    }

    @Override
    public void invalidateInputs() {
        this.invalidInputsForRecipes = true;
    }

    @Override
    public void invalidateOutputs() {
        this.isOutputsFull = true;
    }

    @Override
    public void setParallelRecipesPerformed(int amount) {
        this.parallelRecipesPerformed = amount;
    }

    protected void updateRecipeProgress() {
        if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
            this.drawEnergy(this.recipeEUt, false);
            if (++this.progressTime > this.maxProgressTime) {
                this.completeRecipe();
            }
            if (this.hasNotEnoughEnergy && this.getEnergyInputPerSecond() > 19L * (long)this.recipeEUt) {
                this.hasNotEnoughEnergy = false;
            }
        } else if (this.recipeEUt > 0) {
            this.hasNotEnoughEnergy = true;
            this.decreaseProgress();
        }
    }

    protected void decreaseProgress() {
        if (this.progressTime >= 2) {
            this.progressTime = ConfigHolder.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progressTime - 2);
        }
    }

    protected boolean canProgressRecipe() {
        if (this.previousRecipe == null) {
            return true;
        }
        return this.checkCleanroomRequirement(this.previousRecipe);
    }

    public void forceRecipeRecheck() {
        this.previousRecipe = null;
        this.trySearchNewRecipe();
    }

    protected void trySearchNewRecipe() {
        long maxVoltage = this.getMaxVoltage();
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        Recipe currentRecipe = this.checkPreviousRecipe() ? this.previousRecipe : this.findRecipe(maxVoltage, importInventory, importFluids);
        if (currentRecipe != null) {
            this.previousRecipe = currentRecipe;
        }
        boolean bl = this.invalidInputsForRecipes = currentRecipe == null;
        if (currentRecipe != null && this.checkRecipe(currentRecipe)) {
            this.prepareRecipe(currentRecipe);
        }
    }

    protected boolean checkPreviousRecipe() {
        if (this.previousRecipe == null) {
            return false;
        }
        if ((long)this.previousRecipe.getEUt() > this.getMaxVoltage()) {
            return false;
        }
        return this.previousRecipe.matches(false, this.getInputInventory(), this.getInputTank());
    }

    public boolean checkRecipe(@NotNull Recipe recipe) {
        return this.checkCleanroomRequirement(recipe);
    }

    protected boolean checkCleanroomRequirement(@NotNull Recipe recipe) {
        CleanroomType requiredType = recipe.getProperty(CleanroomProperty.getInstance(), null);
        if (requiredType == null) {
            return true;
        }
        MetaTileEntity mte = this.getMetaTileEntity();
        if (mte instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)((Object)mte);
            if (ConfigHolder.machines.cleanMultiblocks && mte instanceof IMultiblockController) {
                return true;
            }
            ICleanroomProvider cleanroomProvider = receiver.getCleanroom();
            if (cleanroomProvider == null) {
                return false;
            }
            return cleanroomProvider.isClean() && cleanroomProvider.checkCleanroomType(requiredType);
        }
        return false;
    }

    public boolean prepareRecipe(Recipe recipe, IItemHandlerModifiable inputInventory, IMultipleTankHandler inputFluidInventory) {
        recipe = Recipe.trimRecipeOutputs(recipe, this.getRecipeMap(), this.metaTileEntity.getItemOutputLimit(), this.metaTileEntity.getFluidOutputLimit());
        if ((recipe = this.findParallelRecipe(recipe, inputInventory, inputFluidInventory, this.getOutputInventory(), this.getOutputTank(), this.getMaxParallelVoltage(), this.getParallelLimit())) != null && this.setupAndConsumeRecipeInputs(recipe, inputInventory, inputFluidInventory)) {
            this.setupRecipe(recipe);
            return true;
        }
        return false;
    }

    public boolean prepareRecipe(Recipe recipe) {
        return this.prepareRecipe(recipe, this.getInputInventory(), this.getInputTank());
    }

    public int getParallelLimit() {
        return this.parallelLimit;
    }

    public void setParallelLimit(int amount) {
        this.parallelLimit = amount;
    }

    @Override
    @NotNull
    public ParallelLogicType getParallelLogicType() {
        return ParallelLogicType.MULTIPLY;
    }

    protected static int getMinTankCapacity(@NotNull IMultipleTankHandler tanks) {
        if (tanks.getTanks() == 0) {
            return 0;
        }
        int result = Integer.MAX_VALUE;
        for (IFluidTank iFluidTank : tanks.getFluidTanks()) {
            result = Math.min(iFluidTank.getCapacity(), result);
        }
        return result;
    }

    @Nullable
    protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        RecipeMap<?> map = this.getRecipeMap();
        if (map == null || !this.isRecipeMapValid(map)) {
            return null;
        }
        return map.findRecipe(maxVoltage, inputs, fluidInputs);
    }

    public boolean isRecipeMapValid(@NotNull RecipeMap<?> recipeMap) {
        return true;
    }

    protected static boolean areItemStacksEqual(@NotNull ItemStack stackA, @NotNull ItemStack stackB) {
        return stackA.func_190926_b() && stackB.func_190926_b() || ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    protected boolean setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory, @NotNull IMultipleTankHandler importFluids) {
        this.overclockResults = this.calculateOverclock(recipe);
        this.modifyOverclockPost(this.overclockResults, recipe.getRecipePropertyStorage());
        if (!this.hasEnoughPower(this.overclockResults)) {
            return false;
        }
        IItemHandlerModifiable exportInventory = this.getOutputInventory();
        IMultipleTankHandler exportFluids = this.getOutputTank();
        if (!this.metaTileEntity.canVoidRecipeItemOutputs() && !GTTransferUtils.addItemsToItemHandler((IItemHandler)exportInventory, true, recipe.getAllItemOutputs())) {
            this.isOutputsFull = true;
            return false;
        }
        if (!this.metaTileEntity.canVoidRecipeFluidOutputs() && !GTTransferUtils.addFluidsToFluidHandler(exportFluids, true, recipe.getAllFluidOutputs())) {
            this.isOutputsFull = true;
            return false;
        }
        this.isOutputsFull = false;
        if (recipe.matches(true, importInventory, importFluids)) {
            this.metaTileEntity.addNotifiedInput(importInventory);
            return true;
        }
        return false;
    }

    protected boolean setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory) {
        return this.setupAndConsumeRecipeInputs(recipe, importInventory, this.getInputTank());
    }

    protected boolean hasEnoughPower(@NotNull int[] resultOverclock) {
        int totalEUt = resultOverclock[0] * resultOverclock[1];
        if (totalEUt >= 0) {
            int capacity = (long)totalEUt > this.getEnergyCapacity() / 2L ? resultOverclock[0] : totalEUt;
            return this.getEnergyStored() >= (long)capacity;
        }
        int power = resultOverclock[0];
        return this.getEnergyStored() - (long)power <= this.getEnergyCapacity();
    }

    protected void modifyOverclockPost(int[] overclockResults, @NotNull IRecipePropertyStorage storage) {
    }

    @NotNull
    protected int[] calculateOverclock(@NotNull Recipe recipe) {
        return this.performOverclocking(recipe);
    }

    protected int @NotNull [] performOverclocking(@NotNull Recipe recipe) {
        int[] values = new int[]{recipe.getEUt(), recipe.getDuration(), this.getNumberOfOCs(recipe.getEUt())};
        this.modifyOverclockPre(values, recipe.getRecipePropertyStorage());
        if (values[2] <= 0) {
            return new int[]{values[0], values[1]};
        }
        return this.runOverclockingLogic(recipe.getRecipePropertyStorage(), values[0], this.getMaximumOverclockVoltage(), values[1], values[2]);
    }

    protected int getNumberOfOCs(int recipeEUt) {
        if (!this.isAllowOverclocking()) {
            return 0;
        }
        byte recipeTier = GTUtility.getTierByVoltage(recipeEUt);
        int maximumTier = this.getOverclockForTier(this.getMaximumOverclockVoltage());
        if (maximumTier <= 1) {
            return 0;
        }
        int numberOfOCs = maximumTier - recipeTier;
        if (recipeTier == 0) {
            --numberOfOCs;
        }
        return numberOfOCs;
    }

    protected void modifyOverclockPre(@NotNull int[] values, @NotNull IRecipePropertyStorage storage) {
    }

    @NotNull
    protected int[] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int duration, int amountOC) {
        return OverclockingLogic.standardOverclockingLogic(Math.abs(recipeEUt), maxVoltage, duration, amountOC, this.getOverclockingDurationDivisor(), this.getOverclockingVoltageMultiplier());
    }

    protected double getOverclockingDurationDivisor() {
        return this.hasPerfectOC ? 4.0 : 2.0;
    }

    protected double getOverclockingVoltageMultiplier() {
        return 4.0;
    }

    protected int getOverclockForTier(long voltage) {
        return GTUtility.getTierByVoltage(voltage);
    }

    public String[] getAvailableOverclockingTiers() {
        int maxTier = this.getOverclockForTier(this.getMaxVoltage());
        String[] result = new String[maxTier + 1];
        result[0] = "gregtech.gui.overclock.off";
        if (maxTier >= 0) {
            System.arraycopy(GTValues.VNF, 1, result, 1, maxTier);
        }
        return result;
    }

    protected void setupRecipe(Recipe recipe) {
        this.progressTime = 1;
        this.setMaxProgress(this.overclockResults[1]);
        this.recipeEUt = this.overclockResults[0];
        byte recipeTier = GTUtility.getTierByVoltage(recipe.getEUt());
        int machineTier = this.getOverclockForTier(this.getMaximumOverclockVoltage());
        this.fluidOutputs = GTUtility.copyFluidList(recipe.getResultFluidOutputs(recipeTier, machineTier, this.getRecipeMap()));
        this.itemOutputs = GTUtility.copyStackList(recipe.getResultItemOutputs(recipeTier, machineTier, this.getRecipeMap()));
        if (this.wasActiveAndNeedsUpdate) {
            this.wasActiveAndNeedsUpdate = false;
        } else {
            this.setActive(true);
        }
    }

    protected void completeRecipe() {
        this.outputRecipeOutputs();
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0;
        this.fluidOutputs = null;
        this.itemOutputs = null;
        this.hasNotEnoughEnergy = false;
        this.wasActiveAndNeedsUpdate = true;
        this.parallelRecipesPerformed = 0;
        this.overclockResults = new int[]{0, 0};
    }

    protected void outputRecipeOutputs() {
        GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), false, this.itemOutputs);
        GTTransferUtils.addFluidsToFluidHandler(this.getOutputTank(), false, this.fluidOutputs);
    }

    public double getProgressPercent() {
        return this.getMaxProgress() == 0 ? 0.0 : (double)this.getProgress() / ((double)this.getMaxProgress() * 1.0);
    }

    @Override
    public int getProgress() {
        return this.progressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgressTime;
    }

    public int getRecipeEUt() {
        return this.recipeEUt;
    }

    public int getInfoProviderEUt() {
        return this.getRecipeEUt();
    }

    public int getPreviousRecipeDuration() {
        return this.getPreviousRecipe() == null ? 0 : this.getPreviousRecipe().getDuration();
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgressTime = maxProgress;
        this.metaTileEntity.markDirty();
    }

    protected void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.metaTileEntity.markDirty();
            World world = this.metaTileEntity.getWorld();
            if (world != null && !world.field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        this.metaTileEntity.markDirty();
        World world = this.metaTileEntity.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    public boolean isHasNotEnoughEnergy() {
        return this.hasNotEnoughEnergy;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isWorking() {
        return this.isActive && !this.hasNotEnoughEnergy && this.workingEnabled;
    }

    public void setAllowOverclocking(boolean allowOverclocking) {
        this.allowOverclocking = allowOverclocking;
        this.overclockVoltage = allowOverclocking ? this.getMaximumOverclockVoltage() : GTValues.V[0];
        this.metaTileEntity.markDirty();
    }

    public boolean isAllowOverclocking() {
        return this.allowOverclocking;
    }

    public void setMaximumOverclockVoltage(long overclockVoltage) {
        this.overclockVoltage = overclockVoltage;
        this.allowOverclocking = overclockVoltage != GTValues.V[0];
        this.metaTileEntity.markDirty();
    }

    public long getMaximumOverclockVoltage() {
        return this.overclockVoltage;
    }

    public int getOverclockTier() {
        if (!this.isAllowOverclocking()) {
            return 0;
        }
        return this.getOverclockForTier(this.overclockVoltage);
    }

    public void setOverclockTier(int tier) {
        this.setMaximumOverclockVoltage(GTValues.V[tier]);
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.getMetaTileEntity().scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
            this.getMetaTileEntity().scheduleRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        this.isActive = buf.readBoolean();
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("WorkEnabled", this.workingEnabled);
        compound.func_74757_a("CanRecipeProgress", this.canRecipeProgress);
        compound.func_74757_a(ALLOW_OVERCLOCKING, this.allowOverclocking);
        compound.func_74772_a(OVERCLOCK_VOLTAGE, this.overclockVoltage);
        if (this.progressTime > 0) {
            compound.func_74768_a("Progress", this.progressTime);
            compound.func_74768_a("MaxProgress", this.maxProgressTime);
            compound.func_74768_a("RecipeEUt", this.recipeEUt);
            NBTTagList itemOutputsList = new NBTTagList();
            for (ItemStack itemOutput : this.itemOutputs) {
                itemOutputsList.func_74742_a((NBTBase)itemOutput.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList fluidOutputsList = new NBTTagList();
            for (FluidStack fluidOutput : this.fluidOutputs) {
                fluidOutputsList.func_74742_a((NBTBase)fluidOutput.writeToNBT(new NBTTagCompound()));
            }
            compound.func_74782_a("ItemOutputs", (NBTBase)itemOutputsList);
            compound.func_74782_a("FluidOutputs", (NBTBase)fluidOutputsList);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        this.workingEnabled = compound.func_74767_n("WorkEnabled");
        this.canRecipeProgress = compound.func_74767_n("CanRecipeProgress");
        this.progressTime = compound.func_74762_e("Progress");
        this.allowOverclocking = compound.func_74767_n(ALLOW_OVERCLOCKING);
        this.overclockVoltage = compound.func_74763_f(OVERCLOCK_VOLTAGE);
        this.isActive = false;
        if (this.progressTime > 0) {
            this.isActive = true;
            this.maxProgressTime = compound.func_74762_e("MaxProgress");
            this.recipeEUt = compound.func_74762_e("RecipeEUt");
            NBTTagList itemOutputsList = compound.func_150295_c("ItemOutputs", 10);
            this.itemOutputs = NonNullList.func_191196_a();
            for (int i = 0; i < itemOutputsList.func_74745_c(); ++i) {
                this.itemOutputs.add((Object)new ItemStack(itemOutputsList.func_150305_b(i)));
            }
            NBTTagList fluidOutputsList = compound.func_150295_c("FluidOutputs", 10);
            this.fluidOutputs = new ArrayList<FluidStack>();
            for (int i = 0; i < fluidOutputsList.func_74745_c(); ++i) {
                this.fluidOutputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidOutputsList.func_150305_b(i)));
            }
        }
    }
}

