/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block.machines;

import com.google.common.base.Preconditions;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineItemBlock
extends ItemBlock {
    private static final Set<CreativeTabs> ADDITIONAL_CREATIVE_TABS = new ObjectArraySet();

    public static void addCreativeTab(CreativeTabs creativeTab) {
        Preconditions.checkNotNull((Object)creativeTab, (Object)"creativeTab");
        if (creativeTab == GregTechAPI.TAB_GREGTECH_MACHINES) {
            throw new IllegalArgumentException("Adding " + GregTechAPI.TAB_GREGTECH_MACHINES.field_78034_o + " as additional creative tab is redundant.");
        }
        if (creativeTab == CreativeTabs.field_78027_g) {
            throw new IllegalArgumentException("Adding " + CreativeTabs.field_78027_g.field_78034_o + " as additional creative tab is redundant.");
        }
        ADDITIONAL_CREATIVE_TABS.add(creativeTab);
    }

    public MachineItemBlock(BlockMachine block) {
        super((Block)block);
        this.func_77627_a(true);
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(stack);
        return metaTileEntity == null ? "unnamed" : metaTileEntity.getMetaName();
    }

    public boolean placeBlockAt(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        IPipeTile pipeTile;
        BlockPos possiblePipe;
        Block block;
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(stack);
        boolean superVal = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState.func_177226_a((IProperty)BlockMachine.OPAQUE, (Comparable)Boolean.valueOf(metaTileEntity != null && metaTileEntity.isOpaqueCube())));
        if (superVal && !world.field_72995_K && (block = world.func_180495_p(possiblePipe = pos.func_177972_a(side.func_176734_d())).func_177230_c()) instanceof BlockPipe && (pipeTile = ((BlockPipe)block).getPipeTileEntity((IBlockAccess)world, possiblePipe)) != null && ((BlockPipe)block).canPipeConnectToBlock(pipeTile, side.func_176734_d(), world.func_175625_s(pos))) {
            pipeTile.setConnection(side, true, false);
        }
        return superVal;
    }

    @Nullable
    public String getCreatorModId(@NotNull ItemStack itemStack) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(itemStack);
        if (metaTileEntity == null) {
            return "gregtech";
        }
        ResourceLocation metaTileEntityId = metaTileEntity.metaTileEntityId;
        return metaTileEntityId.func_110624_b();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable NBTTagCompound nbt) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(stack);
        return metaTileEntity == null ? null : metaTileEntity.initItemStackCapabilities(stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) != null;
    }

    @NotNull
    public ItemStack getContainerItem(@NotNull ItemStack itemStack) {
        IFluidHandlerItem handler;
        if (!this.hasContainerItem(itemStack)) {
            return ItemStack.field_190927_a;
        }
        if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            FluidStack drained = handler.drain(1000, true);
            if (drained == null || drained.amount != 1000) {
                return ItemStack.field_190927_a;
            }
            return handler.getContainer().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        String tierlessTooltipLocale;
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(stack);
        if (metaTileEntity == null) {
            return;
        }
        String tooltipLocale = metaTileEntity.getMetaName() + ".tooltip";
        if (I18n.func_188566_a((String)tooltipLocale)) {
            Collections.addAll(tooltip, LocalizationUtils.formatLines(tooltipLocale, new Object[0]));
        }
        if (metaTileEntity instanceof ITieredMetaTileEntity && !tooltipLocale.equals(tierlessTooltipLocale = ((ITieredMetaTileEntity)((Object)metaTileEntity)).getTierlessTooltipKey()) && I18n.func_188566_a((String)tierlessTooltipLocale)) {
            Collections.addAll(tooltip, LocalizationUtils.formatLines(tierlessTooltipLocale, new Object[0]));
        }
        metaTileEntity.addInformation(stack, worldIn, tooltip, flagIn.func_194127_a());
        if (metaTileEntity.showToolUsages()) {
            if (TooltipHelper.isShiftDown()) {
                metaTileEntity.addToolUsages(stack, worldIn, tooltip, flagIn.func_194127_a());
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.show_tooltips", (Object[])new Object[0]));
            }
        }
        if (ConfigHolder.misc.debug) {
            tooltip.add(String.format("MetaTileEntity Id: %s", metaTileEntity.metaTileEntityId.toString()));
        }
    }

    public CreativeTabs[] getCreativeTabs() {
        CreativeTabs[] tabs = ADDITIONAL_CREATIVE_TABS.toArray(new CreativeTabs[ADDITIONAL_CREATIVE_TABS.size() + 1]);
        tabs[tabs.length - 1] = this.func_77640_w();
        return tabs;
    }

    public int getItemStackLimit(@NotNull ItemStack stack) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(stack);
        return metaTileEntity != null ? metaTileEntity.getItemStackLimit(stack) : super.getItemStackLimit(stack);
    }
}

