/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block;

import gregtech.api.block.UnlistedBooleanProperty;
import gregtech.api.block.VariantBlock;
import gregtech.client.model.ActiveVariantBlockBakedModel;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import team.chisel.ctm.client.state.CTMExtendedState;

public class VariantActiveBlock<T extends Enum<T>>
extends VariantBlock<T> {
    private static final Int2ObjectMap<ObjectSet<BlockPos>> ACTIVE_BLOCKS = new Int2ObjectOpenHashMap();
    private static final ReadWriteLock ACTIVE_BLOCKS_LOCK = new ReentrantReadWriteLock();
    public static final PropertyBool ACTIVE_DEPRECATED = PropertyBool.func_177716_a((String)"active");
    public static final UnlistedBooleanProperty ACTIVE = new UnlistedBooleanProperty("active");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBlockActive(int dimension, BlockPos pos) {
        ACTIVE_BLOCKS_LOCK.readLock().lock();
        try {
            ObjectSet set = (ObjectSet)ACTIVE_BLOCKS.get(dimension);
            boolean bl = set != null && set.contains((Object)pos);
            return bl;
        }
        finally {
            ACTIVE_BLOCKS_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBlockActive(int dimension, BlockPos pos, boolean active) {
        ACTIVE_BLOCKS_LOCK.writeLock().lock();
        try {
            ObjectSet set = (ObjectSet)ACTIVE_BLOCKS.get(dimension);
            if (active) {
                if (set == null) {
                    set = new ObjectOpenHashSet();
                    ACTIVE_BLOCKS.put(dimension, (Object)set);
                }
                set.add((Object)pos);
            } else if (set != null) {
                set.remove((Object)pos);
            }
        }
        finally {
            ACTIVE_BLOCKS_LOCK.writeLock().unlock();
        }
    }

    public VariantActiveBlock(Material materialIn) {
        super(materialIn);
    }

    @Override
    public IBlockState getState(T variant) {
        return super.getState(variant).func_177226_a((IProperty)ACTIVE_DEPRECATED, (Comparable)Boolean.valueOf(false));
    }

    protected boolean func_149700_E() {
        return false;
    }

    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(@NotNull IBlockState state, @NotNull BlockRenderLayer layer) {
        return layer == this.func_180664_k() || layer == BloomEffectUtil.getEffectiveBloomLayer(this.isBloomEnabled(this.getState(state)));
    }

    @Override
    @NotNull
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)ACTIVE_DEPRECATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE_DEPRECATED)).booleanValue()) {
            meta += 8;
        }
        return meta + ((Enum)((Object)state.func_177229_b((IProperty)this.VARIANT))).ordinal();
    }

    @Override
    @NotNull
    protected BlockStateContainer func_180661_e() {
        Class enumClass = VariantActiveBlock.getActualTypeParameter(this.getClass(), VariantActiveBlock.class);
        this.VARIANT = PropertyEnum.func_177709_a((String)"variant", enumClass);
        this.VALUES = (Enum[])enumClass.getEnumConstants();
        return new ExtendedBlockState((Block)this, new IProperty[]{this.VARIANT, ACTIVE_DEPRECATED}, new IUnlistedProperty[]{ACTIVE});
    }

    @NotNull
    public IExtendedBlockState getExtendedState(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        IExtendedBlockState ext = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)ACTIVE, (Object)(Minecraft.func_71410_x().field_71441_e != null && VariantActiveBlock.isBlockActive(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension(), pos) ? 1 : 0));
        if (Loader.isModLoaded((String)"ctm")) {
            return new CTMExtendedState((IBlockState)ext, world, pos);
        }
        return ext;
    }

    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        EnumMap models = new EnumMap(this.VALUES[0].getDeclaringClass());
        for (Enum value : this.VALUES) {
            ModelResourceLocation inactiveModel = this.model(false, value);
            ModelResourceLocation activeModel = this.model(true, value);
            ActiveVariantBlockBakedModel model = new ActiveVariantBlockBakedModel(inactiveModel, activeModel, () -> this.isBloomEnabled(value));
            models.put(value, model.getModelLocation());
            Item item = Item.func_150898_a((Block)this);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)value.ordinal(), (ModelResourceLocation)inactiveModel);
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{activeModel});
        }
        ModelLoader.setCustomStateMapper((Block)this, b -> b.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(s -> s, s -> (ModelResourceLocation)models.get(s.func_177229_b((IProperty)this.VARIANT)))));
    }

    private ModelResourceLocation model(boolean active, T variant) {
        return new ModelResourceLocation(Objects.requireNonNull(this.getRegistryName()), "active=" + active + ",variant=" + this.VARIANT.func_177702_a(variant));
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isBloomEnabled(T value) {
        return ConfigHolder.client.machinesEmissiveTextures;
    }
}

