/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.util;

import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.RegistrarSoulShards;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.api.ISoulCage;
import com.whammich.sstow.api.ISoulShard;
import com.whammich.sstow.api.ISoulWeapon;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.api.SoulShardsAPI;
import com.whammich.sstow.api.event.CageSpawnEvent;
import com.whammich.sstow.api.event.ShardTierChangeEvent;
import com.whammich.sstow.compat.CompatibilityType;
import com.whammich.sstow.item.ItemSoulShard;
import com.whammich.sstow.tile.TileEntityCage;
import com.whammich.sstow.util.EntityMapper;
import com.whammich.sstow.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="soulshardstow")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityKill(LivingDeathEvent event) {
        World world = event.getEntity().func_130014_f_();
        if (world.field_72995_K || !(event.getEntity() instanceof EntityLiving) || !(event.getSource().func_76346_g() instanceof EntityPlayer) || event.getSource().func_76346_g() instanceof FakePlayer) {
            return;
        }
        EntityLiving dead = (EntityLiving)event.getEntity();
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        ResourceLocation entName = EntityList.func_191301_a((Entity)dead);
        if (entName == null) {
            SoulShardsTOW.LOGGER.error("Player killed an entity with no mapped name: {}", (Object)dead);
            return;
        }
        ItemStack shard = Utils.getShardFromInv(player, entName);
        if (!ConfigHandler.entityList.contains(entName) || SoulShardsAPI.isEntityBlacklisted(dead)) {
            return;
        }
        if (!EntityMapper.isEntityValid(entName)) {
            return;
        }
        if (!ConfigHandler.countCageBornForShard && Utils.isCageBorn((EntityLivingBase)dead)) {
            return;
        }
        if (!ShardHelper.isBound(shard)) {
            ShardHelper.setBoundEntity(shard, entName);
        }
        int soulStealer = EnchantmentHelper.func_77506_a((Enchantment)RegistrarSoulShards.SOUL_STEALER, (ItemStack)player.func_184614_ca());
        soulStealer *= ConfigHandler.soulStealerBonus;
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ISoulWeapon) {
            soulStealer += ((ISoulWeapon)player.func_184614_ca().func_77973_b()).getBonusSouls(player.func_184614_ca());
        }
        Utils.increaseShardKillCount(shard, 1 + soulStealer);
    }

    @SubscribeEvent
    public static void checkExperienceDrop(LivingExperienceDropEvent event) {
        if (!ConfigHandler.enableExperienceDrop && Utils.isCageBorn(event.getEntityLiving())) {
            event.setDroppedExperience(0);
        }
    }

    @SubscribeEvent
    public static void tryHandleStructure(PlayerInteractEvent.RightClickBlock event) {
        if (ItemSoulShard.multiblock.isEmpty()) {
            ItemSoulShard.buildMultiblock();
        }
        IBlockState worldState = event.getWorld().func_180495_p(event.getPos());
        if (!event.getItemStack().func_190926_b() && ItemStack.func_179545_c((ItemStack)event.getItemStack(), (ItemStack)ConfigHandler.catalystItem) && worldState == ItemSoulShard.originBlock) {
            for (Pair<BlockPos, IBlockState> multiblockPair : ItemSoulShard.multiblock) {
                IBlockState offState = event.getWorld().func_180495_p(event.getPos().func_177971_a((Vec3i)multiblockPair.getLeft()));
                if (((IBlockState)multiblockPair.getRight()).equals(offState)) continue;
                return;
            }
            for (Pair<BlockPos, IBlockState> multiblockPair : ItemSoulShard.multiblock) {
                event.getWorld().func_175655_b(event.getPos().func_177971_a((Vec3i)multiblockPair.getLeft()), false);
            }
            if (!event.getWorld().field_72995_K) {
                InventoryHelper.func_180173_a((World)event.getWorld(), (double)event.getEntityPlayer().field_70165_t, (double)(event.getEntityPlayer().field_70163_u + 0.25), (double)event.getEntityPlayer().field_70161_v, (ItemStack)new ItemStack(RegistrarSoulShards.SOUL_SHARD));
            }
            if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                event.getItemStack().func_190918_g(1);
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void tryHandleCageInteract(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = event.getItemStack();
        if (tile != null && tile instanceof ISoulCage) {
            TileEntityCage cage = (TileEntityCage)tile;
            ItemStack cageStack = cage.getStackHandler().getStackInSlot(0);
            if (!heldItem.func_190926_b() && cageStack.func_190926_b() && ShardHelper.isBound(heldItem) && !player.func_70093_af()) {
                cage.getStackHandler().setStackInSlot(0, heldItem.func_77946_l());
                cage.setTier(ShardHelper.getTierFromShard(heldItem));
                cage.setEntName(ShardHelper.getBoundEntity(heldItem));
                if (!event.getWorld().field_72995_K) {
                    cage.setOwner(player.func_146103_bH().getId().toString());
                }
                heldItem.func_190918_g(1);
                player.func_184609_a(event.getHand());
            } else if (!cageStack.func_190926_b() && player.func_184614_ca().func_190926_b() && player.func_70093_af()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)cage.getStackHandler().getStackInSlot(0));
                cage.reset();
                player.func_184609_a(event.getHand());
            }
        }
    }

    @SubscribeEvent
    public static void onAnvil(AnvilUpdateEvent event) {
        if (!ConfigHandler.allowShardCombination) {
            return;
        }
        if (!event.getLeft().func_190926_b() && event.getLeft().func_77973_b() instanceof ISoulShard && !event.getRight().func_190926_b() && event.getRight().func_77973_b() instanceof ISoulShard && ShardHelper.isBound(event.getLeft()) && ShardHelper.getKillsFromShard(event.getRight()) > 0) {
            if (Utils.hasMaxedKills(event.getLeft())) {
                return;
            }
            if (!ShardHelper.getBoundEntity(event.getLeft()).equals((Object)ShardHelper.getBoundEntity(event.getRight()))) {
                return;
            }
            ItemStack output = event.getLeft().func_77946_l();
            Utils.increaseShardKillCount(output, ShardHelper.getKillsFromShard(event.getRight()));
            event.setOutput(output);
            event.setCost(ShardHelper.getTierFromShard(output) * 6);
        }
    }

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("soulshardstow")) {
            ConfigHandler.syncConfig();
            ConfigHandler.handleEntityList("Entity List");
            ConfigHandler.handleCatalyst();
        }
    }

    @SubscribeEvent
    public static void onCageSpawn(CageSpawnEvent event) {
        if (ConfigHandler.compatibilityType != CompatibilityType.HARDMODE) {
            return;
        }
        int currentKills = ShardHelper.getKillsFromShard(event.getShard());
        if (currentKills <= 0) {
            event.setCanceled(true);
            return;
        }
        ShardHelper.setKillsForShard(event.getShard(), currentKills - 1);
    }

    @SubscribeEvent
    public static void onTierChange(ShardTierChangeEvent event) {
        if (ConfigHandler.compatibilityType != CompatibilityType.HARDMODE) {
            return;
        }
        if (event.getNewTier() < ShardHelper.getTierFromShard(event.getShardStack())) {
            event.setCanceled(true);
        }
    }
}

