/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.api;

import com.whammich.sstow.api.ISoulShard;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ShardHelper {
    public static final String TIER = "Tier";
    public static final String KILL_COUNT = "KillCount";
    public static final String ENTITY = "Entity";

    public static int getTierFromShard(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISoulShard)) {
            return 0;
        }
        return ShardHelper.checkNBT(stack).func_77978_p().func_74762_e(TIER);
    }

    public static ItemStack setTierForShard(ItemStack stack, int tier) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISoulShard)) {
            return stack;
        }
        ShardHelper.checkNBT(stack).func_77978_p().func_74768_a(TIER, tier);
        return stack;
    }

    public static int getKillsFromShard(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISoulShard)) {
            return 0;
        }
        return ShardHelper.checkNBT(stack).func_77978_p().func_74762_e(KILL_COUNT);
    }

    public static ItemStack setKillsForShard(ItemStack stack, int kills) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISoulShard)) {
            return stack;
        }
        ShardHelper.checkNBT(stack).func_77978_p().func_74768_a(KILL_COUNT, kills);
        return stack;
    }

    public static ResourceLocation getBoundEntity(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISoulShard)) {
            return new ResourceLocation("blank", "blank");
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(ENTITY)) {
            return new ResourceLocation("blank", "blank");
        }
        return new ResourceLocation(ShardHelper.checkNBT(stack).func_77978_p().func_74779_i(ENTITY));
    }

    public static ItemStack setBoundEntity(ItemStack stack, ResourceLocation entity) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISoulShard)) {
            return stack;
        }
        ShardHelper.checkNBT(stack).func_77978_p().func_74778_a(ENTITY, entity.toString());
        return stack;
    }

    public static boolean isBound(ItemStack stack) {
        return !ShardHelper.getBoundEntity(stack).equals((Object)new ResourceLocation("blank", "blank"));
    }

    private static ItemStack checkNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack;
    }
}

