/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker.praescriptum;

import com.google.common.collect.ImmutableList;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.ingredients.output.ItemStackOutputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.recipe.Recipes;
import techreborn.compatmod.crafttweaker.ZenDocumentation;
import techreborn.compatmod.crafttweaker.praescriptum.CTPraescriptumRecipe;

@ZenClass(value="mods.techreborn.compressor")
public class CTCompressor
extends CTPraescriptumRecipe {
    @ZenMethod
    @ZenDocumentation(value="IItemStack output, IIngredient ingredient, int tickTime, int energyCostPerTick")
    public static void addRecipe(IItemStack output, IIngredient ingredient, int operationDuration, int energyCostPerTick) {
        ItemStackInputIngredient input = ingredient instanceof IItemStack ? ItemStackInputIngredient.of((ItemStack)ItemUtils.copyWithSize((ItemStack)CraftTweakerMC.getItemStack((IIngredient)ingredient), (int)ingredient.getAmount())) : OreDictionaryInputIngredient.of((String)((IOreDictEntry)ingredient).getName(), (int)ingredient.getAmount());
        Recipe recipe = CTCompressor.getRecipeHandler().createRecipe().withInput((Collection)ImmutableList.of((Object)input)).withOutput(CraftTweakerMC.getItemStack((IItemStack)output)).withEnergyCostPerTick(energyCostPerTick).withOperationDuration(operationDuration);
        CTCompressor.add(recipe);
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack output")
    public static void removeRecipe(IItemStack output) {
        ItemStack outStack = CraftTweakerMC.getItemStack((IItemStack)output);
        Recipe recipe = CTCompressor.getRecipeHandler().getRecipeByOutput(Collections.singleton(ItemStackOutputIngredient.of((ItemStack)outStack)));
        if (recipe != null) {
            CTCompressor.getRecipeHandler().removeRecipe(recipe);
        }
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack ingredient")
    public static void removeInputRecipe(IItemStack ingredient) {
        ItemStack input = CraftTweakerMC.getItemStack((IItemStack)ingredient);
        Recipe recipe = CTCompressor.getRecipeHandler().findRecipe(input);
        if (recipe != null) {
            CTCompressor.getRecipeHandler().removeRecipe(recipe);
        }
    }

    @ZenMethod
    public static void removeAll() {
        CTCompressor.removeAll(CTCompressor.getRecipeHandler());
    }

    public static RecipeHandler getRecipeHandler() {
        return Recipes.compressor;
    }
}

