/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import reborncore.common.registration.RebornRegistry;
import techreborn.compat.ICompatModule;
import techreborn.compatmod.crafttweaker.CTBlastFurnace;
import techreborn.compatmod.crafttweaker.CTDistillationTower;
import techreborn.compatmod.crafttweaker.CTFluidGen;
import techreborn.compatmod.crafttweaker.CTFluidReplicator;
import techreborn.compatmod.crafttweaker.CTFusionReactor;
import techreborn.compatmod.crafttweaker.CTImplosionCompressor;
import techreborn.compatmod.crafttweaker.CTIndustrialElectrolyzer;
import techreborn.compatmod.crafttweaker.CTIndustrialGrinder;
import techreborn.compatmod.crafttweaker.CTIndustrialSawmill;
import techreborn.compatmod.crafttweaker.CTRollingMachine;
import techreborn.compatmod.crafttweaker.CTScrapbox;
import techreborn.compatmod.crafttweaker.CTVacuumFreezer;
import techreborn.compatmod.crafttweaker.praescriptum.CTAlloySmelter;
import techreborn.compatmod.crafttweaker.praescriptum.CTAssemblingMachine;
import techreborn.compatmod.crafttweaker.praescriptum.CTCentrifuge;
import techreborn.compatmod.crafttweaker.praescriptum.CTChemicalReactor;
import techreborn.compatmod.crafttweaker.praescriptum.CTCompressor;
import techreborn.compatmod.crafttweaker.praescriptum.CTExtractor;
import techreborn.compatmod.crafttweaker.praescriptum.CTGrinder;
import techreborn.compatmod.crafttweaker.praescriptum.CTPlateBendingMachine;
import techreborn.compatmod.crafttweaker.praescriptum.CTSolidCanningMachine;
import techreborn.compatmod.crafttweaker.praescriptum.CTWireMill;

@RebornRegistry(modOnly="crafttweaker", modID="techreborn")
public class CraftTweakerCompat
implements ICompatModule {
    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        return CraftTweakerMC.getItemStack((IItemStack)iStack);
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return ((IOreDictEntry)iStack).getName();
        }
        if (iStack instanceof IItemStack) {
            return CraftTweakerMC.getItemStack((IItemStack)((IItemStack)iStack));
        }
        if (iStack instanceof IngredientStack) {
            IIngredient ingr = (IIngredient)ObfuscationReflectionHelper.getPrivateValue(IngredientStack.class, (Object)((IngredientStack)iStack), (String)"ingredient");
            return CraftTweakerCompat.toObject(ingr);
        }
        return null;
    }

    public static FluidStack toFluidStack(ILiquidStack iStack) {
        return CraftTweakerMC.getLiquidStack((ILiquidStack)iStack);
    }

    public void preInit(FMLPreInitializationEvent event) {
        CraftTweakerAPI.registerClass(CTBlastFurnace.class);
        CraftTweakerAPI.registerClass(CTIndustrialGrinder.class);
        CraftTweakerAPI.registerClass(CTImplosionCompressor.class);
        CraftTweakerAPI.registerClass(CTIndustrialElectrolyzer.class);
        CraftTweakerAPI.registerClass(CTIndustrialSawmill.class);
        CraftTweakerAPI.registerClass(CTFusionReactor.class);
        CraftTweakerAPI.registerClass(CTVacuumFreezer.class);
        CraftTweakerAPI.registerClass(CTFluidGen.class);
        CraftTweakerAPI.registerClass(CTRollingMachine.class);
        CraftTweakerAPI.registerClass(CTScrapbox.class);
        CraftTweakerAPI.registerClass(CTDistillationTower.class);
        CraftTweakerAPI.registerClass(CTFluidReplicator.class);
        CraftTweakerAPI.registerClass(CTAlloySmelter.class);
        CraftTweakerAPI.registerClass(CTAssemblingMachine.class);
        CraftTweakerAPI.registerClass(CTChemicalReactor.class);
        CraftTweakerAPI.registerClass(CTCompressor.class);
        CraftTweakerAPI.registerClass(CTExtractor.class);
        CraftTweakerAPI.registerClass(CTGrinder.class);
        CraftTweakerAPI.registerClass(CTPlateBendingMachine.class);
        CraftTweakerAPI.registerClass(CTSolidCanningMachine.class);
        CraftTweakerAPI.registerClass(CTWireMill.class);
        CraftTweakerAPI.registerClass(CTCentrifuge.class);
    }
}

