/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class NetworkDiagnosticsPartOverlayRenderer {
    private static final NetworkDiagnosticsPartOverlayRenderer _INSTANCE = new NetworkDiagnosticsPartOverlayRenderer();
    private final Set<PartPos> partPositions = Sets.newHashSet();

    private NetworkDiagnosticsPartOverlayRenderer() {
    }

    public static NetworkDiagnosticsPartOverlayRenderer getInstance() {
        return _INSTANCE;
    }

    public synchronized void addPos(PartPos pos) {
        this.partPositions.add(pos);
    }

    public synchronized void removePos(PartPos pos) {
        this.partPositions.remove(pos);
    }

    public synchronized void clearPositions() {
        this.partPositions.clear();
    }

    public synchronized boolean hasPartPos(PartPos pos) {
        return this.partPositions.contains(pos);
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        if (!this.partPositions.isEmpty()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float partialTicks = event.getPartialTicks();
            double offsetX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double offsetY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double offsetZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)6.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            ArrayList partList = Lists.newArrayList(this.partPositions);
            for (PartPos partPos : partList) {
                if (partPos.getPos().getDimensionId() != player.field_70170_p.field_73011_w.getDimension() || !(partPos.getPos().getBlockPos().func_177951_i((Vec3i)player.func_180425_c()) < 10000.0)) continue;
                PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
                AxisAlignedBB localPartBB = partStateHolder != null ? partStateHolder.getPart().getPartRenderPosition().getBoundingBox(partPos.getSide()) : Block.field_185505_j;
                AxisAlignedBB globalRenderBB = localPartBB.func_186670_a(partPos.getPos().getBlockPos()).func_72317_d(-offsetX, -offsetY, -offsetZ).func_72321_a(0.05, 0.05, 0.05).func_72321_a(-0.05, -0.05, -0.05);
                RenderGlobal.func_189697_a((AxisAlignedBB)globalRenderBB, (float)1.0f, (float)0.2f, (float)0.1f, (float)0.8f);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }
}

