/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;

public abstract class ValueTypeListProxyNbtValueListGeneric<N extends NBTBase, T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private final String key;
    private final NBTTagCompound tag;

    public ValueTypeListProxyNbtValueListGeneric(String name, T valueType, String key, NBTTagCompound tag) {
        super(name, valueType);
        this.key = key;
        this.tag = tag;
    }

    public String getKey() {
        return this.key;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    public int getLength() throws EvaluationException {
        try {
            return this.getLength(Optional.ofNullable(this.tag.func_74781_a(this.key)).orElse((NBTBase)this.getDefault()));
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    @Override
    public V get(int index) throws EvaluationException {
        try {
            if (index < this.getLength()) {
                return this.get(Optional.ofNullable(this.tag.func_74781_a(this.key)).orElse((NBTBase)this.getDefault()), index);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    protected abstract int getLength(N var1);

    protected abstract V get(N var1, int var2);

    protected abstract N getDefault();

    public static abstract class Factory<L extends ValueTypeListProxyNbtValueListGeneric<N, T, V>, N extends NBTBase, T extends IValueType<V>, V extends IValue>
    extends ValueTypeListProxyNBTFactorySimple<T, V, L> {
        @Override
        public String getName() {
            return "nbt.listValue";
        }

        @Override
        protected void serializeNbt(L value, NBTTagCompound tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            tag.func_74778_a("key", ((ValueTypeListProxyNbtValueListGeneric)value).getKey());
            tag.func_74782_a("tag", (NBTBase)((ValueTypeListProxyNbtValueListGeneric)value).getTag());
        }

        @Override
        protected L deserializeNbt(NBTTagCompound tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            return this.create(tag.func_74779_i("key"), tag.func_74775_l("tag"));
        }

        protected abstract L create(String var1, NBTTagCompound var2);
    }
}

