/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.ConfigRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.AdvancementsRFC;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.bafomdad.realfilingcabinet.utils.OreDictUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageUtils {
    public static void addStackManually(TileEntityRFC tile, EntityPlayer player, ItemStack stack) {
        boolean oreDict;
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        if (StorageUtils.testFluid(tile, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(EnumHand.MAIN_HAND, stack.func_77973_b().getContainerItem(stack));
            }
            return;
        }
        boolean bl = oreDict = tile instanceof TileFilingCabinet && !UpgradeHelper.getUpgrade((TileFilingCabinet)tile, "TAG_oredictUpgrade").isEmpty();
        if (oreDict) {
            OreDictUtils.recreateOreDictionary(stack);
            oreDict = OreDictUtils.hasOreDict();
        }
        for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
            ItemStack folderStack = tile.getInventory().getFolder(i);
            if (folderStack.func_190926_b()) continue;
            StorageUtils.testAdvancement(tile.getInventory().getFolder(i), player);
            if (oreDict && OreDictUtils.areItemsEqual(stack, tile.getInventory().getStackFromFolder(i))) {
                FolderUtils.get(folderStack).insert(stack, false, true);
            } else {
                FolderUtils.get(folderStack).insert(stack, false);
            }
            if (stack.func_190926_b()) break;
        }
    }

    public static void addAllStacksManually(TileEntityRFC tile, EntityPlayer player) {
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        boolean consume = false;
        for (ItemStack loopInv : player.field_71071_by.field_70462_a) {
            if (loopInv.func_190926_b()) continue;
            for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
                ItemStack folderStack = tile.getInventory().getStackFromFolder(i);
                if (folderStack.func_190926_b()) continue;
                StorageUtils.testAdvancement(tile.getInventory().getFolder(i), player);
                FolderUtils.get(tile.getInventory().getFolder(i)).insert(loopInv, false);
                consume = true;
            }
        }
        if (consume) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
            tile.func_70296_d();
        }
    }

    public static void extractStackManually(TileEntityRFC tile, EntityPlayer player) {
        boolean fluidUpgrade;
        ItemStack stack = tile.getFilter();
        boolean oreDict = tile instanceof TileFilingCabinet && !UpgradeHelper.getUpgrade((TileFilingCabinet)tile, "TAG_oredictUpgrade").isEmpty();
        boolean creative = tile instanceof TileFilingCabinet && UpgradeHelper.isCreative((TileFilingCabinet)tile);
        boolean bl = fluidUpgrade = tile instanceof TileFilingCabinet && !UpgradeHelper.getUpgrade((TileFilingCabinet)tile, "TAG_fluidUpgrade").isEmpty();
        if (!stack.func_190926_b()) {
            for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
                boolean sneak;
                ItemStack folder = tile.getInventory().getFolder(i);
                CapabilityFolder cap = FolderUtils.get(folder).getCap();
                if (cap == null) continue;
                if (cap.isFluidStack() && fluidUpgrade) {
                    ItemStack container = player.func_184614_ca();
                    if (!container.func_190926_b() && container.func_77973_b() == Items.field_151133_ar) {
                        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
                        if (fluid != null) {
                            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)container, (IFluidHandler)((TileFilingCabinet)tile).getFluidInventory(), (int)1000, (EntityPlayer)player, (boolean)true);
                            if (far.success) {
                                container.func_190918_g(1);
                                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)far.getResult());
                                tile.markBlockForUpdate();
                            }
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (!cap.isItemStack()) continue;
                boolean bl2 = sneak = player.func_70093_af() != ConfigRFC.invertShift;
                if (oreDict) {
                    OreDictUtils.recreateOreDictionary(stack);
                    if (!cap.getItemStack().func_190926_b() && OreDictUtils.areItemsEqual(stack, cap.getItemStack())) {
                        long count = cap.getCount();
                        if (count == 0L) continue;
                        long extract = sneak ? Math.min((long)stack.func_77976_d(), count) : 1L;
                        ItemStack stackExtract = new ItemStack(stack.func_77973_b(), (int)extract, stack.func_77952_i());
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackExtract);
                        if (!UpgradeHelper.isCreative((TileFilingCabinet)tile)) {
                            cap.setCount(count - extract);
                        }
                        tile.markBlockForUpdate();
                        return;
                    }
                }
                if (!ItemStack.func_179545_c((ItemStack)cap.getItemStack(), (ItemStack)stack) || cap.getCount() <= 0L) continue;
                if (folder.func_77952_i() == FolderType.NBT.ordinal() && !ItemStack.func_77970_a((ItemStack)cap.getItemStack(), (ItemStack)stack)) {
                    return;
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)((ItemStack)cap.extract(sneak ? (long)stack.func_77976_d() : 1L, false, creative)));
                tile.markBlockForUpdate();
                return;
            }
        }
    }

    public static void folderExtract(TileEntityRFC tile, EntityPlayer player) {
        if (tile instanceof TileFilingCabinet && !UpgradeHelper.getUpgrade((TileFilingCabinet)tile, "TAG_enderUpgrade").isEmpty()) {
            ItemStack enderFolder = new ItemStack(RFCItems.FOLDER, 1, FolderType.ENDER.ordinal());
            NBTUtils.setInt(enderFolder, "RFC_slotindex", 0);
            NBTUtils.setInt(enderFolder, "RFC_enderhash", ((TileFilingCabinet)tile).getHash());
            EnderUtils.setTileLoc((TileFilingCabinet)tile, enderFolder);
            player.func_184611_a(EnumHand.MAIN_HAND, enderFolder);
            return;
        }
        for (int i = tile.getInventory().getSlots() - 1; i >= 0; --i) {
            ItemStack folder = tile.getInventory().getFolder(i);
            if (folder.func_190926_b()) continue;
            tile.getInventory().setStackInSlot(i, ItemStack.field_190927_a);
            player.func_184611_a(EnumHand.MAIN_HAND, folder);
            tile.markBlockForUpdate();
            break;
        }
    }

    public static void cycleIndex(ItemStack stack, int wheel) {
        if (wheel > 0) {
            wheel = 1;
        }
        if (wheel < 0) {
            wheel = -1;
        }
        int index = StorageUtils.getIndex(stack);
        NBTUtils.setInt(stack, "RFC_slotindex", Math.floorMod(index + wheel, 8));
    }

    public static int getIndex(ItemStack stack) {
        return NBTUtils.getInt(stack, "RFC_slotindex", 0);
    }

    public static void testAdvancement(ItemStack dyedFolder, EntityPlayer player) {
        if (player instanceof EntityPlayerMP && dyedFolder.func_77973_b() == RFCItems.DYEDFOLDER && FolderUtils.get(dyedFolder).getFileSize() >= (long)ConfigRFC.folderSizeLimit) {
            AdvancementsRFC.advance((EntityPlayerMP)player, new ResourceLocation("realfilingcabinet", "limit_reach"), "code_triggered");
        }
    }

    private static boolean testFluid(TileEntityRFC tile, ItemStack toInsert) {
        IFluidHandler fluidHandler;
        int fluidAmount;
        if (!(tile instanceof TileFilingCabinet)) {
            return false;
        }
        if (UpgradeHelper.getUpgrade((TileFilingCabinet)tile, "TAG_fluidUpgrade").isEmpty()) {
            return false;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)toInsert);
        return fluid != null && (fluidAmount = (fluidHandler = ((TileFilingCabinet)tile).getFluidInventory()).fill(fluid, true)) > 0;
    }
}

