/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import java.text.NumberFormat;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SmeltingUtils {
    public static final int FUEL_TIME = 1600;
    public static final int SMELT_TIME = 100;

    public static boolean canSmelt(TileFilingCabinet tile) {
        return !UpgradeHelper.getUpgrade(tile, "TAG_smeltingUpgrade").isEmpty();
    }

    public static void createSmeltingJob(TileFilingCabinet tile) {
        int toSmelt = -1;
        int smeltResult = -1;
        block0: for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
            ItemStack result;
            if (tile.getInventory().getStackInSlot(i).func_190926_b() || SmeltingUtils.hasSmeltingJob(tile, i) || (result = FurnaceRecipes.func_77602_a().func_151395_a(tile.getInventory().getStackInSlot(i))).func_190926_b()) continue;
            toSmelt = i;
            for (int j = 0; j < tile.getInventory().getSlots(); ++j) {
                ItemStack loopStack = tile.getInventory().getStackFromFolder(j);
                if (loopStack.func_190926_b()) continue;
                if (!ItemStack.func_179545_c((ItemStack)loopStack, (ItemStack)result) || toSmelt == j) continue;
                smeltResult = j;
                continue block0;
            }
        }
        if (toSmelt >= 0 && smeltResult >= 0) {
            SmeltingUtils.addSmeltingJob(tile, toSmelt, smeltResult);
        }
        if (!tile.smeltingJobs.isEmpty() && tile.fuelTime <= 0) {
            for (int k = 0; k < tile.getInventory().getSlots(); ++k) {
                ItemStack fuel = tile.getInventory().getStackInSlot(k);
                if (fuel.func_190926_b() || fuel.func_77973_b() != Items.field_151044_h) continue;
                FolderUtils.get(tile.getInventory().getFolder(k)).remove(1L);
                tile.fuelTime = 1600;
                break;
            }
        }
    }

    public static void writeSmeltNBT(TileFilingCabinet tile, NBTTagCompound tag) {
        if (!SmeltingUtils.canSmelt(tile)) {
            if (!tile.smeltingJobs.isEmpty()) {
                tile.smeltingJobs.clear();
            }
            tile.fuelTime = 0;
            return;
        }
        tag.func_74768_a("RFC_fuelTime", tile.fuelTime);
        NBTTagList tagList = new NBTTagList();
        for (int[] job : tile.smeltingJobs) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74783_a("RFC_smeltingJob", job);
            tagList.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("RFC_smeltList", (NBTBase)tagList);
    }

    public static void readSmeltNBT(TileFilingCabinet tile, NBTTagCompound tag) {
        if (tag.func_74764_b("RFC_smeltList")) {
            NBTTagList tagList = tag.func_150295_c("RFC_smeltList", 11);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int[] job = tagList.func_150306_c(i);
                tile.smeltingJobs.add(job);
            }
        }
        tile.fuelTime = tag.func_74762_e("RFC_fuelTime");
    }

    public static void removeSmeltingJob(TileFilingCabinet tile, int slot) {
        for (int[] job : tile.smeltingJobs) {
            if (job[1] != slot && job[2] != slot) continue;
            tile.smeltingJobs.remove(job);
            break;
        }
    }

    private static void addSmeltingJob(TileFilingCabinet tile, int toSmelt, int smeltResult) {
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        int[] job = new int[]{0, toSmelt, smeltResult};
        tile.smeltingJobs.add(job);
    }

    private static boolean hasSmeltingJob(TileFilingCabinet tile, int toSmeltSlot) {
        for (int[] job : tile.smeltingJobs) {
            if (job[1] != toSmeltSlot) continue;
            return true;
        }
        return false;
    }

    private static void completeSmeltingJob(TileFilingCabinet tile, int[] job, int jobIndex) {
        if (tile.getInventory().getStackInSlot(job[1]).func_190926_b()) {
            tile.smeltingJobs.remove(jobIndex);
            return;
        }
        FolderUtils.get(tile.getInventory().getFolder(job[1])).remove(1L);
        FolderUtils.get(tile.getInventory().getFolder(job[2])).add(1L);
        if (tile.getInventory().getStackInSlot(job[1]).func_190926_b()) {
            tile.smeltingJobs.remove(jobIndex);
            return;
        }
        job[0] = 0;
    }

    public static void incrementSmeltTime(TileFilingCabinet tile) {
        if (tile.fuelTime > 0) {
            --tile.fuelTime;
        } else {
            return;
        }
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        if (!tile.smeltingJobs.isEmpty()) {
            for (int i = 0; i < tile.smeltingJobs.size(); ++i) {
                int[] job = tile.smeltingJobs.get(i);
                job[0] = job[0] + 1;
                if (job[0] < 100) continue;
                SmeltingUtils.completeSmeltingJob(tile, job, i);
            }
        }
    }

    public static String getSmeltingPercentage(TileFilingCabinet tile, int slot) {
        if (tile.smeltingJobs.isEmpty()) {
            return "";
        }
        for (int[] job : tile.smeltingJobs) {
            if (job[1] != slot) continue;
            NumberFormat percentFormatter = NumberFormat.getInstance();
            double calc = 0.0;
            if (job[0] > 0) {
                calc = (double)job[0] / 100.0;
            }
            return " [" + percentFormatter.format(calc *= 100.0) + "%]";
        }
        return "";
    }

    public static boolean isSmelting(TileFilingCabinet tile) {
        return tile.fuelTime > 0;
    }
}

