/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import com.bafomdad.realfilingcabinet.utils.MobUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class FluidUtils {
    public static boolean doPlace(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing facing) {
        if (!NBTUtils.getBoolean(stack, "RFC_placeMode", false)) {
            return false;
        }
        if (!MobUtils.canPlayerChangeStuffHere(world, player, stack, pos, facing)) {
            return false;
        }
        CapabilityFolder cap = FolderUtils.get(stack).getCap();
        if (cap == null) {
            return false;
        }
        long count = cap.getCount();
        if (cap.isFluidStack() && count >= 1000L) {
            pos = pos.func_177972_a(facing);
            Block hitblock = world.func_180495_p(pos).func_177230_c();
            Fluid fluid = cap.getFluidStack().getFluid();
            int l = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
            if (!hitblock.func_176200_f((IBlockAccess)world, pos)) {
                return false;
            }
            if (fluid != null && (hitblock != fluid.getBlock() || hitblock == fluid.getBlock() && l != 0)) {
                if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    cap.setCount(count - 1000L);
                }
                world.func_180501_a(pos, fluid.getBlock().func_176223_P(), 11);
                return true;
            }
        }
        return false;
    }

    public static boolean doDrain(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing facing) {
        if (NBTUtils.getBoolean(stack, "RFC_placeMode", false)) {
            return false;
        }
        if (!MobUtils.canPlayerChangeStuffHere(world, player, stack, pos, facing)) {
            return false;
        }
        CapabilityFolder cap = FolderUtils.get(stack).getCap();
        Block block = world.func_180495_p(pos).func_177230_c();
        int l = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
        if (block instanceof BlockLiquid && l == 0) {
            if (cap.isFluidStack() && cap.getFluidStack().getFluid().getBlock() == block) {
                if (!world.field_72995_K) {
                    cap.setCount(cap.getCount() + 1000L);
                    world.func_175698_g(pos);
                }
                return true;
            }
        } else if (block instanceof IFluidBlock && l == 0) {
            Fluid fluid = ((IFluidBlock)block).getFluid();
            if (cap.isFluidStack() && cap.getFluidStack().getFluid() == fluid) {
                if (!world.field_72995_K) {
                    cap.setCount(cap.getCount() + 1000L);
                    world.func_175698_g(pos);
                }
                return true;
            }
        }
        return false;
    }

    public static FluidStack getFluidFromFolder(TileEntityRFC tile, int slot) {
        ItemStack stack = tile.getInventory().getFolder(slot);
        CapabilityFolder cap = FolderUtils.get(stack).getCap();
        if (cap != null && cap.isFluidStack()) {
            int count = (int)Math.min(Integer.MAX_VALUE, cap.getCount());
            FluidStack fluid = cap.getFluidStack();
            fluid.amount = count;
            return fluid;
        }
        return null;
    }

    public static void togglePlace(ItemStack folder) {
        NBTUtils.setBoolean(folder, "RFC_placeMode", !NBTUtils.getBoolean(folder, "RFC_placeMode", false));
    }
}

