/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.init.RFCIntegration;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.integration.IModCompat;
import com.bafomdad.realfilingcabinet.integration.loaders.TweakerLoader;
import com.bafomdad.realfilingcabinet.inventory.InventoryRFC;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.network.VanillaPacketDispatcher;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AutocraftingUtils {
    private static int outputSize;

    private static IRecipe getRecipeFor(ItemStack stack) {
        if (!stack.func_190926_b()) {
            IRecipe recipe2;
            Optional<IModCompat> opt = RFCIntegration.canLoad(RFCIntegration.CRT);
            if (opt.isPresent() && (recipe2 = TweakerLoader.getTweakedRecipe(stack)) != null) {
                return recipe2;
            }
            for (IRecipe recipe2 : CraftingManager.field_193380_a) {
                if (!(recipe2 instanceof ShapedRecipes) && !(recipe2 instanceof ShapedOreRecipe) && !(recipe2 instanceof ShapelessRecipes) && !(recipe2 instanceof ShapelessOreRecipe) || recipe2.func_77571_b().func_77973_b() != stack.func_77973_b() || recipe2.func_77571_b().func_77981_g() && recipe2.func_77571_b().func_77952_i() != stack.func_77952_i()) continue;
                return recipe2;
            }
        }
        return null;
    }

    private static IItemHandler getFakeInv(TileFilingCabinet tile) {
        ItemStackHandler tempInv = new ItemStackHandler(tile.getInventory().getSlots());
        for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
            ItemStack stack = tile.getInventory().getFolder(i);
            if (stack == ItemStack.field_190927_a) continue;
            tempInv.setStackInSlot(i, tile.getInventory().getFolder(i).func_77946_l());
        }
        return tempInv;
    }

    public static int getOutputSize() {
        return outputSize;
    }

    public static boolean canCraft(ItemStack input, TileFilingCabinet tile) {
        if (AutocraftingUtils.isUncraftable(input, tile)) {
            return false;
        }
        IRecipe recipe = AutocraftingUtils.getRecipeFor(input);
        if (recipe == null) {
            AutocraftingUtils.setUncraftableItem(input, tile);
            return false;
        }
        return AutocraftingUtils.consumeRecipeIngredients(recipe, AutocraftingUtils.getFakeInv(tile));
    }

    public static void doCraft(ItemStack input, IItemHandler inv) {
        IRecipe recipe = AutocraftingUtils.getRecipeFor(input);
        AutocraftingUtils.consumeRecipeIngredients(recipe, inv);
    }

    private static void setUncraftableItem(ItemStack stack, TileFilingCabinet tile) {
        tile.uncraftableItem = stack;
    }

    private static boolean isUncraftable(ItemStack stack, TileFilingCabinet tile) {
        return stack.func_190926_b() || ItemStack.func_185132_d((ItemStack)stack, (ItemStack)tile.uncraftableItem);
    }

    public static boolean consumeRecipeIngredients(IRecipe recipe, IItemHandler inv) {
        NonNullList ingredients = recipe.func_192400_c();
        for (int i = 0; i < ingredients.size(); ++i) {
            boolean flag;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            boolean bl = flag = ingredient.func_193365_a().length > 0;
            if (!flag) continue;
            ItemStack stack = ingredient.func_193365_a()[0];
            if (stack.func_190926_b()) {
                return false;
            }
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(1);
            }
            if (stack.func_77952_i() == -1 || stack.func_77952_i() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            if (AutocraftingUtils.consumeFromInventory(stack, inv)) continue;
            return false;
        }
        outputSize = recipe.func_77571_b().func_190916_E();
        if (inv instanceof InventoryRFC) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(((InventoryRFC)inv).getTile());
        }
        return true;
    }

    public static boolean consumeFromInventory(ItemStack stack, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            CapabilityFolder cap;
            ItemStack folder = inv.getStackInSlot(i);
            if (inv instanceof InventoryRFC) {
                folder = ((InventoryRFC)inv).getFolder(i);
            }
            if (folder.func_190926_b() || (cap = FolderUtils.get(folder).getCap()) == null || !cap.isItemStack() || !stack.func_77969_a(cap.getItemStack()) || cap.getCount() <= 0L) continue;
            boolean consume = true;
            ItemStack container = cap.getItemStack().func_77973_b().getContainerItem(cap.getItemStack());
            if (!container.func_190926_b() && inv instanceof InventoryRFC) {
                if (container == cap.getItemStack()) {
                    consume = false;
                }
                if (consume && !AutocraftingUtils.shuntContainerItem(container, inv)) {
                    AutocraftingUtils.shuntContainerItemOutside(container, inv);
                }
            }
            if (consume) {
                cap.setCount(cap.getCount() - 1L);
                if (cap.getCount() < 0L) {
                    consume = false;
                }
            }
            return consume;
        }
        return false;
    }

    private static boolean shuntContainerItem(ItemStack container, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack folder = ((InventoryRFC)inv).getFolder(i);
            if (folder.func_190926_b() || folder.func_77973_b() != RFCItems.FOLDER || !(FolderUtils.get(folder).getObject() instanceof ItemStack) || !container.func_77969_a((ItemStack)FolderUtils.get(folder).getObject())) continue;
            FolderUtils.get(folder).add(1L);
            return true;
        }
        return false;
    }

    private static void shuntContainerItemOutside(ItemStack container, IItemHandler inv) {
        TileFilingCabinet tile = (TileFilingCabinet)((InventoryRFC)inv).getTile();
        EntityItem ei = new EntityItem(tile.func_145831_w(), (double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 1.5, (double)tile.func_174877_v().func_177952_p() + 0.5, container);
        tile.func_145831_w().func_72838_d((Entity)ei);
    }
}

