/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.api.IEmptyFolder;
import com.bafomdad.realfilingcabinet.api.ISubModel;
import com.bafomdad.realfilingcabinet.helpers.enums.EmptyFolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import com.bafomdad.realfilingcabinet.utils.MobUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemEmptyFolder
extends Item
implements ISubModel,
IEmptyFolder {
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + EmptyFolderType.values()[stack.func_77952_i()].toString().toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < EmptyFolderType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag whatisthis) {
        String str = "";
        switch (stack.func_77952_i()) {
            case 1: {
                str = ".emptyfolder1";
                break;
            }
            case 2: {
                str = ".emptyfolder2";
                break;
            }
            case 3: {
                str = ".emptyfolder3";
                break;
            }
            default: {
                str = ".emptyfolder0";
            }
        }
        list.add(new TextComponentTranslation("tooltip.realfilingcabinet" + str, new Object[0]).func_150254_d());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77952_i() != EmptyFolderType.FLUID.ordinal()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult rtr = this.func_77621_a(world, player, true);
        if (rtr == null || !MobUtils.canPlayerChangeStuffHere(world, player, stack, rtr.func_178782_a(), rtr.field_178784_b)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (rtr.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rtr.func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            int l = state.func_177230_c().func_176201_c(state);
            if ((state.func_177230_c() instanceof BlockLiquid || state.func_177230_c() instanceof IFluidBlock) && l == 0) {
                ItemStack newFolder;
                Fluid fluid;
                if (!world.field_72995_K && (fluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c())) != null && FolderUtils.get(newFolder = this.getFilledFolder(stack)).setObject(new FluidStack(fluid, 1000))) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)newFolder);
                    world.func_175698_g(pos);
                    stack.func_190918_g(1);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && stack.func_77952_i() == EmptyFolderType.MOB.ordinal()) {
            if (!MobUtils.acceptableTargets(target)) {
                return false;
            }
            ItemStack newFolder = this.getFilledFolder(stack);
            if (FolderUtils.get(newFolder).setObject(target)) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)newFolder);
                stack.func_190918_g(1);
                MobUtils.dropMobEquips(player.field_70170_p, target);
                target.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSubModels(Item item) {
        for (int i = 0; i < EmptyFolderType.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EmptyFolderType.values()[i].toString().toLowerCase(), "inventory"));
        }
    }

    @Override
    public ItemStack getFilledFolder(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 0: {
                return new ItemStack(RFCItems.FOLDER, 1, 0);
            }
            case 1: {
                return new ItemStack(RFCItems.FOLDER, 1, 2);
            }
            case 2: {
                return new ItemStack(RFCItems.FOLDER, 1, 3);
            }
            case 3: {
                return new ItemStack(RFCItems.FOLDER, 1, 4);
            }
            case 4: {
                return new ItemStack(RFCItems.FOLDER, 1, 5);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canRecipeTakeStack(ItemStack folder, ItemStack recipeStack) {
        return EmptyFolderType.values()[folder.func_77952_i()].canRecipeTakeStack(recipeStack);
    }
}

