/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.inventory;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.network.VanillaPacketDispatcher;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import com.bafomdad.realfilingcabinet.utils.OreDictUtils;
import com.bafomdad.realfilingcabinet.utils.SmeltingUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryRFC
extends ItemStackHandler {
    final TileEntityRFC tile;

    public InventoryRFC(TileEntityRFC tile, int size) {
        this.tile = tile;
        this.setSize(size);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean oreDict;
        if (this.tile.isCabinetLocked() || stack.func_190926_b()) {
            return stack;
        }
        boolean bl = oreDict = this.tile instanceof TileFilingCabinet && !UpgradeHelper.getUpgrade((TileFilingCabinet)this.tile, "TAG_oredictUpgrade").isEmpty();
        if (oreDict) {
            OreDictUtils.recreateOreDictionary(stack);
            if (OreDictUtils.hasOreDict()) {
                oreDict = OreDictUtils.areItemsEqual(stack, this.getStackFromFolder(slot));
            }
        }
        simulate = oreDict ? false : simulate;
        Object obj = FolderUtils.get((ItemStack)this.stacks.get(slot)).insert(stack, simulate, oreDict);
        if (obj == null) {
            return stack;
        }
        if (!simulate) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
        }
        return (ItemStack)obj;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Object obj;
        boolean creative;
        if (this.tile.isCabinetLocked()) {
            return ItemStack.field_190927_a;
        }
        ItemStack filter = this.tile.getFilter();
        boolean hasFilter = this.tile.getItemFrame() != null;
        boolean bl = creative = this.tile instanceof TileFilingCabinet && UpgradeHelper.isCreative((TileFilingCabinet)this.tile);
        if (!filter.func_190926_b()) {
            boolean oreDict;
            boolean bl2 = oreDict = this.tile instanceof TileFilingCabinet && !UpgradeHelper.getUpgrade((TileFilingCabinet)this.tile, "TAG_oredictUpgrade").isEmpty();
            if (oreDict) {
                OreDictUtils.recreateOreDictionary(filter);
                oreDict = OreDictUtils.hasOreDict();
            }
            for (int i = 0; i < this.getSlots(); ++i) {
                Object obj2;
                ItemStack folderStack = this.getStackFromFolder(i);
                if (oreDict && OreDictUtils.areItemsEqual(filter, folderStack)) {
                    if (hasFilter && slot != i) break;
                    obj2 = FolderUtils.get((ItemStack)this.stacks.get(i)).extract(amount, simulate, creative);
                    if (obj2 instanceof ItemStack) {
                        if (!simulate) {
                            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
                        }
                        return new ItemStack(filter.func_77973_b(), ((ItemStack)obj2).func_190916_E(), filter.func_77952_i());
                    }
                }
                if (!ItemStack.func_179545_c((ItemStack)folderStack, (ItemStack)filter)) continue;
                if (hasFilter && slot != i) break;
                obj2 = FolderUtils.get((ItemStack)this.stacks.get(i)).extract(amount, simulate, creative);
                if (!(obj2 instanceof ItemStack)) continue;
                if (!simulate) {
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
                }
                return (ItemStack)obj2;
            }
        }
        if (!hasFilter && (obj = FolderUtils.get((ItemStack)this.stacks.get(slot)).extract(amount, simulate, creative)) instanceof ItemStack) {
            if (!simulate) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
            }
            return (ItemStack)obj;
        }
        return ItemStack.field_190927_a;
    }

    public TileEntityRFC getTile() {
        return this.tile;
    }

    public ItemStack getStackInSlot(int slot) {
        if (((ItemStack)this.stacks.get(slot)).func_190926_b() || !(((ItemStack)this.stacks.get(slot)).func_77973_b() instanceof IFolder)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackFolder = this.getStackFromFolder(slot);
        ItemStack copystack = new ItemStack(stackFolder.func_77973_b(), 1, stackFolder.func_77952_i());
        if (!stackFolder.func_190926_b()) {
            long count;
            if (stackFolder.func_77942_o()) {
                copystack.func_77982_d(stackFolder.func_77978_p());
            }
            if ((count = FolderUtils.get((ItemStack)this.stacks.get(slot)).getFileSize()) <= 0L) {
                return ItemStack.field_190927_a;
            }
            long extract = Math.min(0x7FFFFFFEL, count);
            copystack.func_190920_e((int)extract);
        }
        return copystack;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        if (stack.func_190926_b() && this.tile instanceof TileFilingCabinet && !this.tile.func_145831_w().field_72995_K && SmeltingUtils.isSmelting((TileFilingCabinet)this.tile)) {
            SmeltingUtils.removeSmeltingJob((TileFilingCabinet)this.tile, slot);
        }
        this.onContentsChanged(slot);
    }

    public ItemStack getStackFromFolder(int slot) {
        ItemStack bucket;
        ItemStack folder = (ItemStack)this.stacks.get(slot);
        Object obj = FolderUtils.get(folder).getObject();
        if (obj instanceof FluidStack && this.tile instanceof TileFilingCabinet && !UpgradeHelper.getUpgrade((TileFilingCabinet)this.tile, "TAG_fluidUpgrade").isEmpty() && !(bucket = FluidUtil.getFilledBucket((FluidStack)((FluidStack)obj))).func_190926_b()) {
            return bucket;
        }
        return obj instanceof ItemStack ? (ItemStack)obj : ItemStack.field_190927_a;
    }

    public ItemStack getFolder(int slot) {
        if (slot >= 0) {
            return (ItemStack)this.stacks.get(slot);
        }
        return ItemStack.field_190927_a;
    }
}

