/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.inventory;

import com.bafomdad.realfilingcabinet.ConfigRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidRFC
implements IFluidHandler {
    TileFilingCabinet tile;
    FluidStack snapshot = null;

    public FluidRFC(TileFilingCabinet tile) {
        this.tile = tile;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidTankProperties[] props = new FluidTankProperties[8];
        for (int i = 0; i < this.tile.getInventory().getSlots(); ++i) {
            ItemStack folder = this.tile.getInventory().getFolder(i);
            CapabilityFolder cap = FolderUtils.get(folder).getCap();
            props[i] = cap != null && cap.isFluidStack() ? new FluidTankProperties(cap.getFluidStack(), Math.max(0x7FFFFFFE, (int)cap.getCount())) : (FluidTankProperties)EmptyFluidHandler.EMPTY_TANK_PROPERTIES;
        }
        return props;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && !this.tile.isCabinetLocked()) {
            for (int i = 0; i < this.tile.getInventory().getSlots(); ++i) {
                Object obj = FolderUtils.get(this.tile.getInventory().getFolder(i)).insert(resource, doFill);
                if (!(obj instanceof FluidStack)) continue;
                return ((FluidStack)obj).amount;
            }
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.tile.isCabinetLocked()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        ItemStack stack = this.tile.getFilter();
        if (stack.func_190926_b()) {
            return null;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid == null) {
            return null;
        }
        for (int i = 0; i < this.tile.getInventory().getSlots(); ++i) {
            FluidStack loopFluid;
            CapabilityFolder cap = FolderUtils.get(this.tile.getInventory().getFolder(i)).getCap();
            if (cap == null || !cap.isFluidStack() || !(loopFluid = cap.getFluidStack()).isFluidEqual(fluid)) continue;
            loopFluid.amount = (int)Math.min(0x7FFFFFFEL, cap.getCount());
            this.takeFluidSnapshot(loopFluid);
            FluidTank tank = new FluidTank(loopFluid, maxDrain);
            FluidStack f = tank.drain(maxDrain, doDrain);
            if (f != null && f.amount > 0 && doDrain && this.snapshot != null && this.snapshot.isFluidEqual(f) && doDrain && !UpgradeHelper.isCreative(this.tile)) {
                if (this.snapshot.getFluid() == FluidRegistry.WATER && this.snapshot.amount >= 3000 && ConfigRFC.infiniteWaterSource) {
                    return f;
                }
                FolderUtils.get(this.tile.getInventory().getFolder(i)).remove(this.snapshot.amount - loopFluid.amount);
            }
            return f;
        }
        return null;
    }

    private void takeFluidSnapshot(FluidStack fluid) {
        this.snapshot = fluid.copy();
    }
}

