/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.init;

import com.bafomdad.realfilingcabinet.TabRFC;
import com.bafomdad.realfilingcabinet.api.RealFilingCabinetAPI;
import com.bafomdad.realfilingcabinet.blocks.BlockFilingCabinet;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.crafting.FolderExtractRecipe;
import com.bafomdad.realfilingcabinet.crafting.FolderMergeRecipe;
import com.bafomdad.realfilingcabinet.crafting.FolderStorageRecipe;
import com.bafomdad.realfilingcabinet.crafting.FolderTapeRecipe;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import com.bafomdad.realfilingcabinet.helpers.enums.MobUpgradeType;
import com.bafomdad.realfilingcabinet.helpers.enums.UpgradeType;
import com.bafomdad.realfilingcabinet.init.RFCBlocks;
import com.bafomdad.realfilingcabinet.init.RFCIntegration;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.init.RFCSounds;
import com.bafomdad.realfilingcabinet.items.ItemAutoFolder;
import com.bafomdad.realfilingcabinet.items.ItemDyedFolder;
import com.bafomdad.realfilingcabinet.items.ItemEmptyDyedFolder;
import com.bafomdad.realfilingcabinet.items.ItemEmptyFolder;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.items.ItemKeys;
import com.bafomdad.realfilingcabinet.items.ItemMagnifyingGlass;
import com.bafomdad.realfilingcabinet.items.ItemMysteryFolder;
import com.bafomdad.realfilingcabinet.items.ItemSuitcase;
import com.bafomdad.realfilingcabinet.items.ItemUpgrades;
import com.bafomdad.realfilingcabinet.items.ItemWhiteoutTape;
import com.bafomdad.realfilingcabinet.items.itemblocks.ItemBlockRFC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="realfilingcabinet")
public class RFCEventRegistry {
    public static List<Block> blocks = new ArrayList<Block>();
    public static List<Item> items = new ArrayList<Item>();
    public static int entityID;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{RFCEventRegistry.registerBlock(new BlockFilingCabinet(), "modelcabinet").func_149711_c(5.0f).func_149752_b(1000.0f)});
        GameRegistry.registerTileEntity(TileFilingCabinet.class, (ResourceLocation)new ResourceLocation("realfilingcabinet", "filingcabinet"));
        RFCIntegration.canLoad(RFCIntegration.BOTANIA).ifPresent(b -> b.registerBlocks(event));
        RFCIntegration.canLoad(RFCIntegration.THAUMCRAFT).ifPresent(b -> b.registerBlocks(event));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RFCEventRegistry.registerItem(new ItemEmptyFolder(), "emptyfolder").func_77625_d(8).func_77627_a(true).func_77656_e(0), RFCEventRegistry.registerItem(new ItemFolder(), "folder", false).func_77625_d(1).func_77627_a(true), RFCEventRegistry.registerItem(new ItemUpgrades(), "upgrade").func_77625_d(16).func_77627_a(true).func_77656_e(0), RFCEventRegistry.registerItem(new ItemMagnifyingGlass(), "magnifyingglass").func_77625_d(1), RFCEventRegistry.registerItem(new ItemWhiteoutTape(), "whiteouttape").func_77625_d(1).func_77656_e(25), RFCEventRegistry.registerItem(new ItemMysteryFolder(), "mysteryfolder").func_77625_d(1), RFCEventRegistry.registerItem(new ItemSuitcase(), "suitcase").func_77625_d(1), RFCEventRegistry.registerItem(new ItemEmptyDyedFolder(), "emptydyedfolder").func_77625_d(8).func_77627_a(true).func_77656_e(0), RFCEventRegistry.registerItem(new ItemDyedFolder(), "dyedfolder", false).func_77625_d(1).func_77627_a(true), RFCEventRegistry.registerItem(new ItemAutoFolder(), "autofolder").func_77625_d(1), RFCEventRegistry.registerItem(new Item(), "debugger").func_77625_d(1), RFCEventRegistry.registerItem(new Item(), "filter").func_77625_d(16), RFCEventRegistry.registerItem(new ItemKeys(), "key").func_77625_d(1).func_77627_a(true).func_77656_e(0), RFCEventRegistry.registerItem(new ItemBlockRFC(RFCBlocks.MODELCABINET), "modelcabinet")});
        RFCIntegration.canLoad(RFCIntegration.BOTANIA).ifPresent(i -> i.registerItems(event));
        RFCIntegration.canLoad(RFCIntegration.THAUMCRAFT).ifPresent(i -> i.registerItems(event));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipe[]{(IRecipe)new FolderStorageRecipe().setRegistryName(new ResourceLocation("realfilingcabinet", "storagefolder")), (IRecipe)new FolderExtractRecipe().setRegistryName(new ResourceLocation("realfilingcabinet", "folderextract")), (IRecipe)new FolderTapeRecipe().setRegistryName(new ResourceLocation("realfilingcabinet", "foldertape")), (IRecipe)new FolderMergeRecipe().setRegistryName(new ResourceLocation("realfilingcabinet", "foldermerge"))});
        RFCIntegration.canLoad(RFCIntegration.BOTANIA).ifPresent(r -> r.registerRecipes(event));
        RFCIntegration.canLoad(RFCIntegration.THAUMCRAFT).ifPresent(r -> r.registerRecipes(event));
        Arrays.stream(UpgradeType.values()).forEach(u -> RealFilingCabinetAPI.registerUpgrade(new ItemStack(RFCItems.UPGRADE, 1, u.ordinal()), u.getTexture(), u.getTag()));
        Arrays.stream(MobUpgradeType.values()).forEach(mu -> RealFilingCabinetAPI.registerMobUpgrade(new ItemStack(RFCItems.UPGRADE, 1, mu.getItemDamage()), mu.getModel(), mu.getTexture(), mu.getTag()));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)RFCEventRegistry.registerEntity("entitycabinet", EntityCabinet.class));
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RFCSounds.SQUEAK, RFCSounds.DRAWER});
    }

    public static <T extends Block> T registerBlock(T newBlock, String name) {
        newBlock.setRegistryName(name);
        newBlock.func_149663_c("realfilingcabinet." + name);
        newBlock.func_149647_a((CreativeTabs)TabRFC.instance);
        blocks.add(newBlock);
        return newBlock;
    }

    public static <T extends Item> T registerItem(T newItem, String name) {
        return RFCEventRegistry.registerItem(newItem, name, true);
    }

    public static <T extends Item> T registerItem(T newItem, String name, boolean creativeTab) {
        newItem.setRegistryName(name);
        newItem.func_77655_b("realfilingcabinet." + name);
        if (creativeTab) {
            newItem.func_77637_a((CreativeTabs)TabRFC.instance);
        }
        items.add(newItem);
        return newItem;
    }

    public static EntityEntry registerEntity(String entityName, Class entity) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.name("realfilingcabinet:" + entityName);
        builder.id(new ResourceLocation("realfilingcabinet", entityName), entityID++);
        builder.tracker(64, 1, true);
        builder.entity(entity);
        return builder.build();
    }
}

