/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.entity;

import com.bafomdad.realfilingcabinet.api.IEntityCabinet;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAIEatItem;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAIHugMob;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAIMoveBackHome;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAISlurp;
import com.bafomdad.realfilingcabinet.helpers.MobUpgradeHelper;
import com.bafomdad.realfilingcabinet.helpers.enums.UpgradeType;
import com.bafomdad.realfilingcabinet.init.RFCBlocks;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EntityCabinet
extends EntityTameable
implements IEntityCabinet {
    private final ItemStackHandler inventory;
    private static final DataParameter<Boolean> YAY = EntityDataManager.func_187226_a(EntityCabinet.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> MODEL = EntityDataManager.func_187226_a(EntityCabinet.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(EntityCabinet.class, (DataSerializer)DataSerializers.field_187194_d);
    public long homePos;
    private boolean isRealEntity = false;
    public String upgrades = "";

    public EntityCabinet(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.inventory = new ItemStackHandler(8);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70178_ae = true;
        this.func_70903_f(true);
        this.field_70180_af.func_187214_a(YAY, (Object)false);
        this.field_70180_af.func_187214_a(MODEL, (Object)String.valueOf(""));
        this.field_70180_af.func_187214_a(TEXTURE, (Object)String.valueOf(""));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, (double)0.6f, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIEatItem(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIHugMob(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISlurp(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveBackHome(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.55);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
    }

    public boolean func_180431_b(DamageSource source) {
        EntityPlayer player;
        if (source == DamageSource.field_76380_i) {
            return false;
        }
        return !(source.func_76346_g() instanceof EntityPlayer) || !source.func_76346_g().func_70093_af() || (player = (EntityPlayer)source.func_76346_g()).func_184614_ca().func_77973_b() != RFCItems.MAGNIFYINGGLASS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.isLegit()) {
            this.func_70106_y();
            return false;
        }
        if (this.func_180425_c().func_177956_o() < 0) {
            BlockPos toHome = BlockPos.func_177969_a((long)this.homePos);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70107_b(toHome.func_177958_n(), toHome.func_177956_o(), toHome.func_177952_p());
            }
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (MobUpgradeHelper.hasUpgrade(this)) {
                MobUpgradeHelper.removeMobUpgrade(player, this);
                return false;
            }
            this.setTile(player);
            return false;
        }
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        if (hand == EnumHand.MAIN_HAND && !(stack = player.func_184614_ca()).func_190926_b() && !this.field_70170_p.field_72995_K) {
            MobUpgradeHelper.setMobUpgrade(player, this, stack);
            return true;
        }
        return false;
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.isRealEntity = tag.func_74767_n("legitEntity");
        this.homePos = tag.func_74763_f("homePos");
        this.upgrades = tag.func_74779_i("RFC_mobUpgrade");
        this.setTexture(tag.func_74779_i("hatTexture"));
        this.setModel(tag.func_74779_i("hatModel"));
        if (tag.func_74764_b("Inventory")) {
            NBTTagList tagList = tag.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                ItemStack stack = new ItemStack(tagList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                this.getInventory().setStackInSlot(i, stack);
            }
            tag.func_82580_o("Inventory");
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74757_a("legitEntity", this.isRealEntity);
        tag.func_74772_a("homePos", this.homePos);
        tag.func_74778_a("RFC_mobUpgrade", this.upgrades);
        tag.func_74778_a("hatTexture", this.getTexture());
        tag.func_74778_a("hatModel", this.getModel());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public void setModel(String modelClassName) {
        this.field_70180_af.func_187227_b(MODEL, (Object)String.valueOf(modelClassName));
    }

    public String getModel() {
        return (String)this.field_70180_af.func_187225_a(MODEL);
    }

    public void setTexture(String resourcePath) {
        this.field_70180_af.func_187227_b(TEXTURE, (Object)String.valueOf(resourcePath));
    }

    public String getTexture() {
        return (String)this.field_70180_af.func_187225_a(TEXTURE);
    }

    public boolean isHatPresent() {
        return !this.getModel().isEmpty() && !this.getTexture().isEmpty();
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public int func_82143_as() {
        return 10;
    }

    public float func_184643_a(PathNodeType nodeType) {
        if (nodeType.func_186289_a() != 0.0f && (nodeType == PathNodeType.LAVA || nodeType == PathNodeType.DANGER_OTHER)) {
            return 0.0f;
        }
        return super.func_184643_a(nodeType);
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (this.hasCapability(cap, side)) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(cap, side);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Object insert(Object toInsert, boolean simulate) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack folder = this.inventory.getStackInSlot(i);
            if (folder.func_190926_b() || !(folder.func_77973_b() instanceof IFolder)) continue;
            return FolderUtils.get(folder).insert(toInsert, simulate);
        }
        return null;
    }

    public void setYay(boolean bool) {
        this.field_70180_af.func_187227_b(YAY, (Object)bool);
    }

    public boolean isYaying() {
        return (Boolean)this.field_70180_af.func_187225_a(YAY);
    }

    public boolean isLegit() {
        return this.isRealEntity;
    }

    public void setLegit() {
        this.isRealEntity = true;
    }

    private void setTile(EntityPlayer player) {
        IBlockState state = RFCBlocks.MODELCABINET.func_176223_P().func_177226_a((IProperty)BlockRFC.FACING, (Comparable)this.func_174811_aO());
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_175623_d(pos)) {
                this.field_70170_p.func_180501_a(pos, state, 2);
                TileFilingCabinet tile = (TileFilingCabinet)this.field_70170_p.func_175625_s(pos);
                if (tile != null) {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        ItemStack folder = this.inventory.getStackInSlot(i);
                        if (!folder.func_190926_b()) {
                            tile.getInventory().setStackInSlot(i, folder);
                        }
                        if (this.func_70902_q() == null) continue;
                        tile.setOwner(this.func_184753_b());
                    }
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(RFCItems.UPGRADE, 1, UpgradeType.LIFE.ordinal()));
                this.func_70106_y();
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.realfilingcabinet.notAir", new Object[0]), true);
            }
        }
    }

    @Override
    public List<String> getInfoOverlay(Entity entity, boolean crouching) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Currently carrying:");
        if (entity instanceof EntityCabinet) {
            for (int i = 0; i < this.getInventory().getSlots(); ++i) {
                ItemStack folder = this.getInventory().getStackInSlot(i);
                if (folder.func_190926_b() || !(folder.func_77973_b() instanceof IFolder)) continue;
                FolderUtils.get(folder).addTooltips(list, crouching);
            }
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase getModelHat() {
        try {
            Class<?> clazz = Class.forName(this.getModel());
            return (ModelBase)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

