/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks;

import com.bafomdad.realfilingcabinet.LogRFC;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileManaCabinet;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.init.RFCSounds;
import com.bafomdad.realfilingcabinet.utils.ManaStorageUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaItem;

public class BlockManaCabinet
extends BlockRFC {
    public BlockManaCabinet() {
        super(Material.field_151576_e);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileManaCabinet();
    }

    @Override
    public void leftClick(TileEntity tile, EntityPlayer player) {
        int maxMana;
        IManaItem manaItem;
        int currentMana;
        TileManaCabinet tmc = (TileManaCabinet)tile;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof IManaItem && (currentMana = (manaItem = (IManaItem)stack.func_77973_b()).getMana(stack)) < (maxMana = manaItem.getMaxMana(stack))) {
            for (int i = 0; i < tmc.getInventory().getSlots(); ++i) {
                int currentManaFolder;
                ItemStack tileStack = tmc.getInventory().getFolder(i);
                if (tileStack.func_77973_b() != RFCItems.FOLDER_MANA || (currentManaFolder = ManaStorageUtils.getManaSize(tileStack)) <= 0) continue;
                int manaToTake = maxMana - currentMana;
                int manaToSet = ManaStorageUtils.takeManaFromFolder(tileStack, manaToTake);
                LogRFC.debug("Mana item: " + currentMana + " / " + maxMana + " - Adding: " + (manaToTake + manaToSet));
                manaItem.addMana(stack, manaToTake + manaToSet);
                tmc.markBlockForUpdate();
                break;
            }
        }
    }

    @Override
    public void rightClick(TileEntity tile, EntityPlayer player, EnumFacing side) {
        TileManaCabinet tmc = (TileManaCabinet)tile;
        ItemStack stack = player.func_184614_ca();
        if (!player.func_70093_af() && !stack.func_190926_b()) {
            if (stack.func_77973_b() == RFCItems.FOLDER_MANA && tmc.isOpen) {
                for (int i = 0; i < tmc.getInventory().getSlots(); ++i) {
                    ItemStack tileStack = tmc.getInventory().getFolder(i);
                    if (!tileStack.func_190926_b()) continue;
                    tmc.getInventory().setStackInSlot(i, stack);
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    tmc.markBlockForUpdate();
                    break;
                }
            }
            return;
        }
        if (!player.func_70093_af() && stack.func_190926_b()) {
            if (!tmc.func_145831_w().field_72995_K) {
                tmc.isOpen = !tmc.isOpen;
                tmc.func_70296_d();
            }
            player.func_184185_a(RFCSounds.DRAWER, 0.45f, 1.0f);
            tmc.markBlockForUpdate();
            return;
        }
        if (player.func_70093_af() && stack.func_190926_b() && tmc.isOpen) {
            for (int i = tmc.getInventory().getSlots() - 1; i >= 0; --i) {
                ItemStack folder = tmc.getInventory().getFolder(i);
                if (folder.func_190926_b()) continue;
                tmc.getInventory().setStackInSlot(i, ItemStack.field_190927_a);
                player.func_184611_a(EnumHand.MAIN_HAND, folder);
                tmc.markBlockForUpdate();
                break;
            }
        }
    }

    @Override
    public List<String> getInfoOverlay(TileEntity tile, boolean crouching) {
        ArrayList<String> list = new ArrayList<String>();
        if (tile instanceof TileManaCabinet) {
            TileManaCabinet tmc = (TileManaCabinet)tile;
            double count = tmc.getTotalInternalManaPool();
            double calc = 0.0;
            if (count > 0.0) {
                calc = count / 1000000.0;
            }
            NumberFormat percentFormatter = NumberFormat.getPercentInstance();
            String percentOut = percentFormatter.format(calc) + " of a full mana pool";
            list.add(percentOut);
        }
        return list;
    }
}

