/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.additionalbanners.handler;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraftforge.common.util.EnumHelper;

public class PatternHandler {
    public static BannerPattern HASHTAG;
    public static BannerPattern CAP;

    public static void initCraftingBanners() {
        PatternHandler.addCraftingPattern("bread", new ItemStack(Items.field_151025_P));
        PatternHandler.addCraftingPattern("fish", new ItemStack(Items.field_151115_aP));
        PatternHandler.addCraftingPattern("fishn", new ItemStack((Item)Items.field_151112_aM));
        PatternHandler.addCraftingPattern("shield", new ItemStack(Items.field_179570_aq));
        PatternHandler.addCraftingPattern("pot", new ItemStack((Item)Items.field_151068_bn));
        PatternHandler.addCraftingPattern("bed", new ItemStack(Items.field_151104_aV));
        PatternHandler.addCraftingPattern("book", new ItemStack(Items.field_151122_aG));
        PatternHandler.addCraftingPattern("bow", new ItemStack((Item)Items.field_151031_f));
        PatternHandler.addCraftingPattern("bucket", new ItemStack(Items.field_151133_ar));
        PatternHandler.addCraftingPattern("write", new ItemStack(Items.field_151099_bA));
        PatternHandler.addCraftingPattern("wheat", new ItemStack(Items.field_151015_O));
        PatternHandler.addCraftingPattern("paper", new ItemStack(Items.field_151121_aF));
        PatternHandler.addCraftingPattern("shear", new ItemStack((Item)Items.field_151097_aZ));
        PatternHandler.addCraftingPattern("apple", new ItemStack(Items.field_151034_e));
        PatternHandler.addCraftingPattern("egg", new ItemStack(Items.field_151110_aK));
        PatternHandler.addCraftingPattern("sword", new ItemStack(Items.field_151010_B));
        PatternHandler.addCraftingPattern("axe", new ItemStack(Items.field_151006_E));
        PatternHandler.addCraftingPattern("hoe", new ItemStack(Items.field_151013_M));
        PatternHandler.addCraftingPattern("pick", new ItemStack(Items.field_151005_D));
        PatternHandler.addCraftingPattern("shovel", new ItemStack(Items.field_151011_C));
        PatternHandler.addCraftingPattern("boots", new ItemStack((Item)Items.field_151151_aj));
        PatternHandler.addCraftingPattern("legs", new ItemStack((Item)Items.field_151149_ai));
        PatternHandler.addCraftingPattern("chest", new ItemStack((Item)Items.field_151171_ah));
        PatternHandler.addCraftingPattern("helm", new ItemStack((Item)Items.field_151169_ag));
        PatternHandler.addCraftingPattern("horse", new ItemStack(Items.field_151136_bY));
        PatternHandler.addCraftingPattern("pumpkin", new ItemStack(Blocks.field_150423_aK));
        PatternHandler.addCraftingPattern("grass", new ItemStack((Block)Blocks.field_150349_c));
        PatternHandler.addCraftingPattern("pillar", new ItemStack(Blocks.field_150371_ca, 1, 2));
        PatternHandler.addCraftingPattern("cobble", new ItemStack(Blocks.field_150347_e));
        PatternHandler.addCraftingPattern("tag", new ItemStack(Items.field_151057_cb));
        PatternHandler.addCraftingPattern("dragon", new ItemStack(Items.field_185157_bK));
        PatternHandler.addCraftingPattern("squid", new ItemStack(Items.field_179562_cC));
        PatternHandler.addCraftingPattern("planks", new ItemStack(Blocks.field_150344_f));
        PatternHandler.addCraftingPattern("balance", new ItemStack(Items.field_151117_aB));
        PatternHandler.addCraftingPattern("mushred", new ItemStack((Block)Blocks.field_150337_Q));
        HASHTAG = PatternHandler.addCraftingPattern("hashtag", new ItemStack(Blocks.field_150462_ai));
        CAP = PatternHandler.addCraftingPattern("cap", new ItemStack(Item.func_150898_a((Block)Blocks.field_150333_U)));
    }

    public static BannerPattern addBasicPattern(String name) {
        Class[] paramTypes = new Class[]{String.class, String.class};
        Object[] paramValues = new Object[]{"additionalbanners_" + name, "additionalbanners." + name};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static BannerPattern addCraftingPattern(String name, ItemStack craftingStack) {
        Class[] paramTypes = new Class[]{String.class, String.class, ItemStack.class};
        Object[] paramValues = new Object[]{"additionalbanners_" + name, "additionalbanners." + name, craftingStack};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static BannerPattern addDyePattern(String name, String id, String craftingTop, String craftingMid, String craftingBot) {
        Class[] paramTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};
        Object[] paramValues = new Object[]{name, id, craftingTop, craftingMid, craftingBot};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static ItemStack createBanner(EnumDyeColor baseColor, NBTTagList patterns) {
        return ItemBanner.func_190910_a((EnumDyeColor)baseColor, (NBTTagList)patterns);
    }

    public static NBTTagList createPatternList(BannerLayer ... layers) {
        NBTTagList patterns = new NBTTagList();
        for (BannerLayer layer : layers) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Pattern", layer.pattern.func_190993_b());
            tag.func_74768_a("Color", layer.color.func_176767_b());
            patterns.func_74742_a((NBTBase)tag);
        }
        return patterns;
    }

    public static NBTTagList createPatternList(EnumDyeColor color, BannerLayer ... layers) {
        NBTTagList patterns = new NBTTagList();
        for (BannerLayer layer : layers) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Pattern", layer.pattern.func_190993_b());
            tag.func_74768_a("Color", layer.color == EnumDyeColor.WHITE ? color.func_176767_b() : layer.color.func_176767_b());
            patterns.func_74742_a((NBTBase)tag);
        }
        return patterns;
    }

    public static void addCharacters(EnumDyeColor baseColor) {
    }

    public static class BannerLayer {
        private final BannerPattern pattern;
        private final EnumDyeColor color;

        public BannerLayer(BannerPattern pattern, EnumDyeColor color) {
            this.pattern = pattern;
            this.color = color;
        }

        public BannerPattern getPattern() {
            return this.pattern;
        }

        public EnumDyeColor getColor() {
            return this.color;
        }
    }
}

