/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.block.BlockSmallPlatePress;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileCentrifuge;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileChemicalReactor;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileCrystallizer;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileCuttingMachine;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileElectricArcFurnace;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileElectrolyser;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileLathe;
import zmaster587.advancedRocketry.tile.multiblock.machine.TilePrecisionAssembler;
import zmaster587.advancedRocketry.tile.multiblock.machine.TilePrecisionLaserEtcher;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileRollingMachine;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;

public class RecipeHandler {
    private List<Class<? extends TileMultiblockMachine>> machineList = new ArrayList<Class<? extends TileMultiblockMachine>>();

    public void registerMachine(Class<? extends TileMultiblockMachine> clazz) {
        if (!this.machineList.contains(clazz)) {
            this.machineList.add(clazz);
            RecipesMachine.getInstance().recipeList.put(clazz, new LinkedList());
        }
    }

    public void clearAllMachineRecipes() {
        for (Class<? extends TileMultiblockMachine> clazz : this.machineList) {
            RecipesMachine.getInstance().getRecipes(clazz).clear();
        }
    }

    public void registerXMLRecipes() {
        LibVulpes.instance.loadXMLRecipe(TileCuttingMachine.class);
        LibVulpes.instance.loadXMLRecipe(TilePrecisionAssembler.class);
        LibVulpes.instance.loadXMLRecipe(TileChemicalReactor.class);
        LibVulpes.instance.loadXMLRecipe(TileCrystallizer.class);
        LibVulpes.instance.loadXMLRecipe(TileElectrolyser.class);
        LibVulpes.instance.loadXMLRecipe(TileElectricArcFurnace.class);
        LibVulpes.instance.loadXMLRecipe(TileLathe.class);
        LibVulpes.instance.loadXMLRecipe(TileRollingMachine.class);
        LibVulpes.instance.loadXMLRecipe(BlockSmallPlatePress.class);
        LibVulpes.instance.loadXMLRecipe(TileCentrifuge.class);
        LibVulpes.instance.loadXMLRecipe(TilePrecisionLaserEtcher.class);
    }

    public void registerAllMachineRecipes() {
        for (Class<? extends TileMultiblockMachine> clazz : this.machineList) {
            try {
                clazz.newInstance().registerRecipes();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public void createAutoGennedRecipes(HashMap<AllowedProducts, HashSet<String>> modProducts) {
        for (Material material : MaterialRegistry.getAllMaterials()) {
            String str;
            int n;
            String[] n3;
            String[] nugget;
            if (AllowedProducts.getProductByName((String)"ORE").isOfType(material.getAllowedProducts()) && AllowedProducts.getProductByName((String)"INGOT").isOfType(material.getAllowedProducts())) {
                GameRegistry.addSmelting((ItemStack)material.getProduct(AllowedProducts.getProductByName((String)"ORE")), (ItemStack)material.getProduct(AllowedProducts.getProductByName((String)"INGOT")), (float)0.0f);
            }
            if (AllowedProducts.getProductByName((String)"NUGGET").isOfType(material.getAllowedProducts())) {
                nugget = material.getProduct(AllowedProducts.getProductByName((String)"NUGGET"));
                nugget.func_190920_e(9);
                n3 = material.getOreDictNames();
                n = n3.length;
                for (int i = 0; i < n; ++i) {
                    str = n3[i];
                    GameData.register_impl((IForgeRegistryEntry)new ShapelessOreRecipe(null, (ItemStack)nugget, new Object[]{AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + str}).setRegistryName("advancedrocketry", "unpacknugget" + str));
                    GameData.register_impl((IForgeRegistryEntry)new ShapedOreRecipe(null, material.getProduct(AllowedProducts.getProductByName((String)"INGOT")), new Object[]{"ooo", "ooo", "ooo", Character.valueOf('o'), AllowedProducts.getProductByName((String)"NUGGET").name().toLowerCase(Locale.ENGLISH) + str}).setRegistryName("advancedrocketry", "unpackingot" + str));
                }
            }
            if (AllowedProducts.getProductByName((String)"GEM").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n4 = nugget.length;
                for (n = 0; n < n4; ++n) {
                    String str2 = nugget[n];
                    RecipesMachine.getInstance().addRecipe(TileCrystallizer.class, (Object)material.getProduct(AllowedProducts.getProductByName((String)"GEM")), 300, 20, new Object[]{AllowedProducts.getProductByName((String)"DUST").name().toLowerCase(Locale.ENGLISH) + str2});
                }
            }
            if (AllowedProducts.getProductByName((String)"BOULE").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n5 = nugget.length;
                for (n = 0; n < n5; ++n) {
                    String str3 = nugget[n];
                    RecipesMachine.getInstance().addRecipe(TileCrystallizer.class, (Object)material.getProduct(AllowedProducts.getProductByName((String)"BOULE")), 300, 20, new Object[]{AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + str3, AllowedProducts.getProductByName((String)"NUGGET").name().toLowerCase(Locale.ENGLISH) + str3});
                }
            }
            if (AllowedProducts.getProductByName((String)"STICK").isOfType(material.getAllowedProducts()) && AllowedProducts.getProductByName((String)"INGOT").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n6 = nugget.length;
                for (n = 0; n < n6; ++n) {
                    String name = nugget[n];
                    if (!OreDictionary.doesOreNameExist((String)(AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + name))) continue;
                    GameData.register_impl((IForgeRegistryEntry)new ShapedOreRecipe(null, material.getProduct(AllowedProducts.getProductByName((String)"STICK"), 4), new Object[]{"x  ", " x ", "  x", Character.valueOf('x'), AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + name}).setRegistryName("advancedrocketry", "stick" + name));
                    RecipesMachine.getInstance().addRecipe(TileLathe.class, (Object)material.getProduct(AllowedProducts.getProductByName((String)"STICK"), 2), 300, 20, new Object[]{AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + name});
                }
            }
            if (AllowedProducts.getProductByName((String)"PLATE").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n7 = nugget.length;
                for (n = 0; n < n7; ++n) {
                    String oreDictNames = nugget[n];
                    if (!OreDictionary.doesOreNameExist((String)(AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + oreDictNames))) continue;
                    RecipesMachine.getInstance().addRecipe(TileRollingMachine.class, (Object)material.getProduct(AllowedProducts.getProductByName((String)"PLATE")), 300, 20, new Object[]{AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + oreDictNames, new FluidStack(FluidRegistry.WATER, 100)});
                    if (!AllowedProducts.getProductByName((String)"BLOCK").isOfType(material.getAllowedProducts()) && !material.isVanilla()) continue;
                    RecipesMachine.getInstance().addRecipe(BlockSmallPlatePress.class, (Object)material.getProduct(AllowedProducts.getProductByName((String)"PLATE"), 4), 0, 0, new Object[]{AllowedProducts.getProductByName((String)"BLOCK").name().toLowerCase(Locale.ENGLISH) + oreDictNames});
                }
            }
            if (AllowedProducts.getProductByName((String)"SHEET").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n8 = nugget.length;
                for (n = 0; n < n8; ++n) {
                    String oreDictNames = nugget[n];
                    RecipesMachine.getInstance().addRecipe(TileRollingMachine.class, (Object)material.getProduct(AllowedProducts.getProductByName((String)"SHEET")), 300, 200, new Object[]{AllowedProducts.getProductByName((String)"PLATE").name().toLowerCase(Locale.ENGLISH) + oreDictNames, new FluidStack(FluidRegistry.WATER, 100)});
                }
            }
            if (AllowedProducts.getProductByName((String)"COIL").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n9 = nugget.length;
                for (n = 0; n < n9; ++n) {
                    String str4 = nugget[n];
                    GameData.register_impl((IForgeRegistryEntry)new ShapedOreRecipe(null, material.getProduct(AllowedProducts.getProductByName((String)"COIL")), new Object[]{"ooo", "o o", "ooo", Character.valueOf('o'), AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + str4}).setRegistryName("advancedrocketry", "coil" + str4));
                }
            }
            if (AllowedProducts.getProductByName((String)"FAN").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n10 = nugget.length;
                for (n = 0; n < n10; ++n) {
                    String str5 = nugget[n];
                    GameData.register_impl((IForgeRegistryEntry)new ShapedOreRecipe(null, material.getProduct(AllowedProducts.getProductByName((String)"FAN")), new Object[]{"p p", " r ", "p p", Character.valueOf('p'), AllowedProducts.getProductByName((String)"PLATE").name().toLowerCase(Locale.ENGLISH) + str5, Character.valueOf('r'), AllowedProducts.getProductByName((String)"STICK").name().toLowerCase(Locale.ENGLISH) + str5}).setRegistryName("advancedrocketry", "fan" + str5));
                }
            }
            if (AllowedProducts.getProductByName((String)"GEAR").isOfType(material.getAllowedProducts())) {
                nugget = material.getOreDictNames();
                int n2 = nugget.length;
                for (n = 0; n < n2; ++n) {
                    String str6 = nugget[n];
                    GameData.register_impl((IForgeRegistryEntry)new ShapedOreRecipe(null, material.getProduct(AllowedProducts.getProductByName((String)"GEAR")), new Object[]{"sps", " r ", "sps", Character.valueOf('p'), AllowedProducts.getProductByName((String)"PLATE").name().toLowerCase(Locale.ENGLISH) + str6, Character.valueOf('s'), AllowedProducts.getProductByName((String)"STICK").name().toLowerCase(Locale.ENGLISH) + str6, Character.valueOf('r'), AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + str6}).setRegistryName("advancedrocketry", "gear" + str6));
                }
            }
            if (AllowedProducts.getProductByName((String)"BLOCK").isOfType(material.getAllowedProducts())) {
                ItemStack ingot = material.getProduct(AllowedProducts.getProductByName((String)"INGOT"));
                ingot.func_190920_e(9);
                n3 = material.getOreDictNames();
                n = n3.length;
                for (int str6 = 0; str6 < n; ++str6) {
                    str = n3[str6];
                    GameData.register_impl((IForgeRegistryEntry)new ShapelessOreRecipe(null, ingot, new Object[]{AllowedProducts.getProductByName((String)"BLOCK").name().toLowerCase(Locale.ENGLISH) + str}).setRegistryName("advancedrocketry", "unpackblock" + str));
                    GameData.register_impl((IForgeRegistryEntry)new ShapedOreRecipe(null, material.getProduct(AllowedProducts.getProductByName((String)"BLOCK")), new Object[]{"ooo", "ooo", "ooo", Character.valueOf('o'), AllowedProducts.getProductByName((String)"INGOT").name().toLowerCase(Locale.ENGLISH) + str}).setRegistryName("advancedrocketry", "packblock" + str));
                }
            }
            if (!AllowedProducts.getProductByName((String)"DUST").isOfType(material.getAllowedProducts())) continue;
            String[] stringArray = material.getOreDictNames();
            int n4 = stringArray.length;
            for (n = 0; n < n4; ++n) {
                String str7 = stringArray[n];
                if (AllowedProducts.getProductByName((String)"ORE").isOfType(material.getAllowedProducts()) || material.isVanilla()) {
                    ItemStack stack = material.getProduct(AllowedProducts.getProductByName((String)"DUST"));
                    stack.func_190920_e(2);
                    RecipesMachine.getInstance().addRecipe(BlockSmallPlatePress.class, (Object)stack, 0, 0, new Object[]{AllowedProducts.getProductByName((String)"ORE").name().toLowerCase(Locale.ENGLISH) + str7});
                }
                if (!AllowedProducts.getProductByName((String)"INGOT").isOfType(material.getAllowedProducts()) && !material.isVanilla()) continue;
                GameRegistry.addSmelting((ItemStack)material.getProduct(AllowedProducts.getProductByName((String)"DUST")), (ItemStack)material.getProduct(AllowedProducts.getProductByName((String)"INGOT")), (float)0.0f);
            }
        }
        if (ARConfiguration.getCurrentConfig().allowSawmillVanillaWood) {
            for (int i = 0; i < 4; ++i) {
                RecipesMachine.getInstance().addRecipe(TileCuttingMachine.class, (Object)new ItemStack(Blocks.field_150344_f, 6, i), 80, 10, new Object[]{new ItemStack(Blocks.field_150364_r, 1, i)});
            }
            RecipesMachine.getInstance().addRecipe(TileCuttingMachine.class, (Object)new ItemStack(Blocks.field_150344_f, 6, 4), 80, 10, new Object[]{new ItemStack(Blocks.field_150363_s, 1, 0)});
            RecipesMachine.getInstance().addRecipe(TileCuttingMachine.class, (Object)new ItemStack(Blocks.field_150344_f, 6, 5), 80, 10, new Object[]{new ItemStack(Blocks.field_150363_s, 1, 1)});
        }
        if (ARConfiguration.getCurrentConfig().allowMakingItemsForOtherMods) {
            for (Map.Entry entry : modProducts.entrySet()) {
                Material material;
                if (entry.getKey() == AllowedProducts.getProductByName((String)"PLATE")) {
                    for (String str : (HashSet)entry.getValue()) {
                        material = Material.valueOfSafe((String)str.toUpperCase());
                        if (!OreDictionary.doesOreNameExist((String)("ingot" + str)) || OreDictionary.getOres((String)("ingot" + str)).size() <= 0 || !OreDictionary.doesOreNameExist((String)("plate" + str)) || OreDictionary.getOres((String)("plate" + str)).size() <= 0 || material != null && AllowedProducts.getProductByName((String)"PLATE").isOfType(material.getAllowedProducts())) continue;
                        RecipesMachine.getInstance().addRecipe(TileRollingMachine.class, OreDictionary.getOres((String)("plate" + str)).get(0), 300, 20, new Object[]{"ingot" + str, new FluidStack(FluidRegistry.WATER, 100)});
                    }
                    continue;
                }
                if (entry.getKey() != AllowedProducts.getProductByName((String)"STICK")) continue;
                for (String str : (HashSet)entry.getValue()) {
                    ItemStack stackToAdd;
                    material = Material.valueOfSafe((String)str.toUpperCase());
                    if (!OreDictionary.doesOreNameExist((String)("ingot" + str)) || OreDictionary.getOres((String)("ingot" + str)).size() <= 0 || material != null && AllowedProducts.getProductByName((String)"STICK").isOfType(material.getAllowedProducts())) continue;
                    if (OreDictionary.doesOreNameExist((String)("rod" + str)) && OreDictionary.getOres((String)("rod" + str)).size() > 0) {
                        stackToAdd = ((ItemStack)OreDictionary.getOres((String)("rod" + str)).get(0)).func_77946_l();
                        stackToAdd.func_190920_e(2);
                    } else {
                        if (!OreDictionary.doesOreNameExist((String)("stick" + str)) || OreDictionary.getOres((String)("stick" + str)).size() <= 0) continue;
                        stackToAdd = ((ItemStack)OreDictionary.getOres((String)("stick" + str)).get(0)).func_77946_l();
                        stackToAdd.func_190920_e(2);
                    }
                    RecipesMachine.getInstance().addRecipe(TileLathe.class, (Object)stackToAdd, 300, 20, new Object[]{"ingot" + str});
                }
            }
        }
    }
}

