/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.armor.IFillableArmor;
import zmaster587.advancedRocketry.api.armor.IProtectiveArmor;

public class ItemAirUtils
implements IFillableArmor {
    public static final ItemAirUtils INSTANCE = new ItemAirUtils();

    @Override
    public int getAirRemaining(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("air");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("air", 0);
        stack.func_77982_d(nbt);
        return this.getMaxAir(stack);
    }

    @Override
    public void setAirRemaining(@Nonnull ItemStack stack, int amt) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("air", amt);
        stack.func_77982_d(nbt);
    }

    @Override
    public int decrementAir(@Nonnull ItemStack stack, int amt) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int prevAmt = nbt.func_74762_e("air");
        int newAmt = Math.max(prevAmt - amt, 0);
        nbt.func_74768_a("air", newAmt);
        stack.func_77982_d(nbt);
        return prevAmt - newAmt;
    }

    @Override
    public int increment(@Nonnull ItemStack stack, int amt) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int prevAmt = nbt.func_74762_e("air");
        int newAmt = Math.min(prevAmt + amt, this.getMaxAir(stack));
        nbt.func_74768_a("air", newAmt);
        stack.func_77982_d(nbt);
        return newAmt - prevAmt;
    }

    @Override
    public int getMaxAir(@Nonnull ItemStack stack) {
        return ARConfiguration.getCurrentConfig().spaceSuitOxygenTime * 1200;
    }

    public boolean isStackValidAirContainer(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        boolean isEnchanted = false;
        NBTTagList enchList = stack.func_77986_q();
        for (int i = 0; i < enchList.func_74745_c(); ++i) {
            NBTTagCompound compound = enchList.func_150305_b(i);
            boolean bl = isEnchanted = compound.func_74765_d("id") == Enchantment.func_185258_b((Enchantment)AdvancedRocketryAPI.enchantmentSpaceProtection);
            if (isEnchanted) break;
        }
        return isEnchanted;
    }

    public static class ItemAirWrapper
    implements IFillableArmor,
    IProtectiveArmor {
        ItemStack stack;

        public ItemAirWrapper(@Nonnull ItemStack myStack) {
            this.stack = myStack;
        }

        @Override
        public int getAirRemaining(@Nonnull ItemStack stack) {
            return INSTANCE.getAirRemaining(this.stack);
        }

        @Override
        public void setAirRemaining(@Nonnull ItemStack stack, int amt) {
            INSTANCE.setAirRemaining(this.stack, amt);
        }

        @Override
        public int decrementAir(@Nonnull ItemStack stack, int amt) {
            return INSTANCE.decrementAir(this.stack, amt);
        }

        @Override
        public int increment(@Nonnull ItemStack stack, int amt) {
            return INSTANCE.increment(this.stack, amt);
        }

        @Override
        public int getMaxAir(@Nonnull ItemStack stack) {
            return INSTANCE.getMaxAir(this.stack);
        }

        @Override
        public boolean protectsFromSubstance(IAtmosphere atmosphere, @Nonnull ItemStack stack, boolean commitProtection) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemArmor) {
                if (((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.CHEST) {
                    return this.decrementAir(stack, 1) == 1;
                }
                return true;
            }
            return false;
        }
    }
}

