/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.block.multiblock.BlockARHatch;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.tile.TileRocketAssemblingMachine;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleBlockSideSelector;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidHatch;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketFluidLoader
extends TileFluidHatch
implements IInfrastructure,
ITickable,
IButtonInventory,
INetworkMachine,
IGuiCallback {
    EntityRocket rocket;
    ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, 0, "", (IButtonInventory)this, LibVulpes.proxy.getLocalizedString("msg.fluidLoader.loadingState"));
    ZUtils.RedstoneState state = ZUtils.RedstoneState.ON;
    ModuleRedstoneOutputButton inputRedstoneControl = new ModuleRedstoneOutputButton(174, 32, 1, "", (IButtonInventory)this, LibVulpes.proxy.getLocalizedString("msg.fluidLoader.allowLoading"));
    ZUtils.RedstoneState inputstate = ZUtils.RedstoneState.OFF;
    ModuleBlockSideSelector sideSelectorModule;
    private static final int ALLOW_REDSTONEOUT = 2;

    public TileRocketFluidLoader() {
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule = new ModuleBlockSideSelector(90, 15, (IGuiCallback)this, new String[]{LibVulpes.proxy.getLocalizedString("msg.fluidLoader.none"), LibVulpes.proxy.getLocalizedString("msg.fluidLoader.allowredstoneoutput"), LibVulpes.proxy.getLocalizedString("msg.fluidLoader.allowredstoneinput")});
    }

    public TileRocketFluidLoader(int size) {
        super(size);
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule = new ModuleBlockSideSelector(90, 15, (IGuiCallback)this, new String[]{LibVulpes.proxy.getLocalizedString("msg.fluidLoader.none"), LibVulpes.proxy.getLocalizedString("msg.fluidLoader.allowredstoneoutput"), LibVulpes.proxy.getLocalizedString("msg.fluidLoader.allowredstoneinput")});
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getMasterBlock() instanceof TileRocketAssemblingMachine) {
            ((TileRocketAssemblingMachine)this.getMasterBlock()).removeConnectedInfrastructure((TileEntity)this);
        }
    }

    public String getModularInventoryName() {
        return "tile.loader.5.name";
    }

    public boolean allowRedstoneOutputOnSide(EnumFacing facing) {
        return this.sideSelectorModule.getStateForSide(facing.func_176734_d()) == 1;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List list = super.getModules(ID, player);
        list.add(this.redstoneControl);
        list.add(this.inputRedstoneControl);
        list.add(this.sideSelectorModule);
        return list;
    }

    protected boolean getStrongPowerForSides(World world, BlockPos pos) {
        for (int i = 0; i < 6; ++i) {
            if (this.sideSelectorModule.getStateForSide(i) != 2 || world.func_175651_c(pos.func_177972_a(EnumFacing.field_82609_l[i]), EnumFacing.field_82609_l[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.rocket != null) {
            boolean isAllowToOperate = this.inputstate == ZUtils.RedstoneState.OFF || this.isStateActive(this.inputstate, this.getStrongPowerForSides(this.field_145850_b, this.func_174877_v()));
            List<TileEntity> tiles = this.rocket.storage.getFluidTiles();
            boolean rocketFluidFull = false;
            for (TileEntity tile : tiles) {
                FluidStack rocketFluid;
                IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (handler.fill(rocketFluid = handler.drain(1, false), false) > 0) {
                    rocketFluidFull = true;
                }
                if (!isAllowToOperate || (rocketFluid = this.fluidTank.drain(this.fluidTank.getCapacity(), false)) == null || rocketFluid.amount <= 0) continue;
                this.fluidTank.drain(handler.fill(rocketFluid, true), true);
            }
            this.setRedstoneState(!rocketFluidFull);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    protected void setRedstoneState(boolean condition) {
        condition = this.isStateActive(this.state, condition);
        ((BlockARHatch)AdvancedRocketryBlocks.blockLoader).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, condition);
    }

    protected boolean isStateActive(ZUtils.RedstoneState state, boolean condition) {
        if (state == ZUtils.RedstoneState.INVERTED) {
            return !condition;
        }
        if (state == ZUtils.RedstoneState.OFF) {
            return false;
        }
        return condition;
    }

    public boolean onLinkStart(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        if (this.rocket != null) {
            this.rocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("%s %s", new Object[]{new TextComponentTranslation("msg.fluidLoader.link", new Object[0]), ": " + this.func_174877_v().func_177958_n() + " " + this.func_174877_v().func_177956_o() + " " + this.func_174877_v().func_177952_p()}));
        }
        return true;
    }

    public boolean onLinkComplete(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("msg.linker.error.firstMachine", new Object[0]));
        }
        return false;
    }

    @Override
    public void unlinkRocket() {
        this.rocket = null;
        ((BlockARHatch)AdvancedRocketryBlocks.blockLoader).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, false);
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.rocket = (EntityRocket)rocket;
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean linkMission(IMission mission) {
        return false;
    }

    @Override
    public void unlinkMission() {
    }

    @Override
    public int getMaxLinkDistance() {
        return 32;
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        this.inputstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("inputRedstoneState")];
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        nbt.func_74774_a("inputRedstoneState", (byte)this.inputstate.ordinal());
        this.sideSelectorModule.writeToNBT(nbt);
        return nbt;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            this.state = this.redstoneControl.getState();
        }
        if (buttonId == 1) {
            this.inputstate = this.inputRedstoneControl.getState();
        }
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        out.writeByte(this.state.ordinal());
        out.writeByte(this.inputstate.ordinal());
        for (int i = 0; i < 6; ++i) {
            out.writeByte(this.sideSelectorModule.getStateForSide(i));
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        nbt.func_74774_a("state", in.readByte());
        nbt.func_74774_a("inputstate", in.readByte());
        byte[] bytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bytes[i] = in.readByte();
        }
        nbt.func_74773_a("bytes", bytes);
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        this.inputstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("inputstate")];
        byte[] bytes = nbt.func_74770_j("bytes");
        for (int i = 0; i < 6; ++i) {
            this.sideSelectorModule.setStateForSide(i, (int)bytes[i]);
        }
        if (this.rocket == null) {
            this.setRedstoneState(this.state == ZUtils.RedstoneState.INVERTED);
        }
        this.func_70296_d();
        this.field_145850_b.func_175646_b(this.func_174877_v(), (TileEntity)this);
    }

    public void onModuleUpdated(ModuleBase module) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

