/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemOreScanner;

public class SatelliteOreMapping
extends SatelliteBase {
    public static ArrayList<Integer> oreList = new ArrayList();
    private int selectedSlot = -1;

    public void setSelectedSlot(int i) {
        if (this.canFilterOre()) {
            this.selectedSlot = i;
        }
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public String getInfo(World world) {
        return "Operational";
    }

    @Override
    public boolean acceptsItemInConstruction(@Nonnull ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return super.acceptsItemInConstruction(item) || SatelliteProperties.Property.DATA.isOfType(flag);
    }

    @Override
    public boolean isAcceptableControllerItemStack(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemOreScanner;
    }

    @Override
    @Nonnull
    public ItemStack getControllerItemStack(@Nonnull ItemStack satIdChip, SatelliteProperties properties) {
        ItemStack stack = new ItemStack(AdvancedRocketryItems.itemOreScanner);
        ItemOreScanner scanner = (ItemOreScanner)AdvancedRocketryItems.itemOreScanner;
        scanner.setSatelliteID(stack, properties.getId());
        return stack;
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)AdvancedRocketry.instance, 100, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean canBeginScan() {
        return this.battery.extractEnergy(1000, true) == 1000;
    }

    public int[][] scanChunk(World world, int offsetX, int offsetZ, int radius, int blocksPerPixel, @Nonnull ItemStack block, int zoomLevel) {
        blocksPerPixel = Math.max(blocksPerPixel, 1);
        int[][] ret = new int[radius * 2 / blocksPerPixel][radius * 2 / blocksPerPixel];
        if (this.canBeginScan() && this.battery.extractEnergy(375 * zoomLevel, false) == 375 * zoomLevel) {
            this.battery.extractEnergy(1000, false);
            this.battery.extractEnergy(375 * zoomLevel, true);
            for (int z = -radius; z < radius; z += blocksPerPixel) {
                for (int x = -radius; x < radius; x += blocksPerPixel) {
                    int oreCount = 0;
                    int otherCount = 0;
                    for (int y = world.func_72800_K(); y > 0; --y) {
                        for (int deltaY = 0; deltaY < blocksPerPixel; ++deltaY) {
                            for (int deltaZ = 0; deltaZ < blocksPerPixel; ++deltaZ) {
                                BlockPos pos = new BlockPos(x + offsetX, y, z + offsetZ);
                                if (world.func_175623_d(pos)) continue;
                                boolean found = false;
                                IBlockState state = world.func_180495_p(pos);
                                List drops = state.func_177230_c().getDrops((IBlockAccess)world, pos, state, 0);
                                for (ItemStack stack : drops) {
                                    if (stack.func_77973_b() != block.func_77973_b() || stack.func_77952_i() != block.func_77952_i()) continue;
                                    ++oreCount;
                                    found = true;
                                }
                                if (found) continue;
                                ++otherCount;
                            }
                        }
                    }
                    oreCount = (int)((double)oreCount / Math.pow(blocksPerPixel, 2.0));
                    otherCount = (int)((double)otherCount / Math.pow(blocksPerPixel, 2.0));
                    if (Thread.interrupted()) {
                        return null;
                    }
                    ret[(x + radius) / blocksPerPixel][(z + radius) / blocksPerPixel] = (int)((float)oreCount / (float)Math.max(otherCount, 1) * 65535.0f);
                }
            }
        }
        return ret;
    }

    public int[][] scanChunk(World world, int offsetX, int offsetZ, int radius, int blocksPerPixel, int zoomLevel) {
        blocksPerPixel = Math.max(blocksPerPixel, 1);
        int[][] ret = new int[radius * 2 / blocksPerPixel][radius * 2 / blocksPerPixel];
        if (oreList.isEmpty()) {
            String[] strings;
            for (String str : strings = OreDictionary.getOreNames()) {
                if (!str.startsWith("ore") && !str.startsWith("dust") && !str.startsWith("gem")) continue;
                oreList.add(OreDictionary.getOreID((String)str));
            }
        }
        if (this.canBeginScan() && this.battery.extractEnergy(250 * zoomLevel, false) == 250 * zoomLevel) {
            this.battery.extractEnergy(1000, false);
            this.battery.extractEnergy(250 * zoomLevel, true);
            for (int z = -radius; z < radius; z += blocksPerPixel) {
                for (int x = -radius; x < radius; x += blocksPerPixel) {
                    int oreCount = 0;
                    int otherCount = 0;
                    for (int y = world.func_72800_K(); y > 0; --y) {
                        for (int deltaY = 0; deltaY < blocksPerPixel; ++deltaY) {
                            for (int deltaZ = 0; deltaZ < blocksPerPixel; ++deltaZ) {
                                BlockPos pos = new BlockPos(x + offsetX, y, z + offsetZ);
                                if (world.func_175623_d(pos)) continue;
                                boolean exists = false;
                                block6: for (int i : oreList) {
                                    NonNullList itemlist = OreDictionary.getOres((String)OreDictionary.getOreName((int)i));
                                    for (ItemStack item : itemlist) {
                                        if (item.func_77973_b() != Item.func_150898_a((Block)world.func_180495_p(pos).func_177230_c())) continue;
                                        exists = true;
                                        break block6;
                                    }
                                }
                                if (exists) {
                                    ++oreCount;
                                    continue;
                                }
                                ++otherCount;
                            }
                        }
                    }
                    oreCount = (int)((double)oreCount / Math.pow(blocksPerPixel, 2.0));
                    otherCount = (int)((double)otherCount / Math.pow(blocksPerPixel, 2.0));
                    if (Thread.interrupted()) {
                        return null;
                    }
                    ret[(x + radius) / blocksPerPixel][(z + radius) / blocksPerPixel] = (int)((float)oreCount / (float)Math.max(otherCount, 1) * 65535.0f);
                }
            }
        }
        return ret;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public String getName() {
        return "Ore Mapper";
    }

    public int getZoomRadius() {
        return Math.min(this.satelliteProperties.getPowerGeneration() / 4, 7);
    }

    public boolean canFilterOre() {
        return this.satelliteProperties.getMaxDataStorage() == 3000;
    }
}

