/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleStellarBackground;
import zmaster587.advancedRocketry.item.ItemIdWithName;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;
import zmaster587.libVulpes.util.Vector3F;

public class ItemStationChip
extends ItemIdWithName
implements IModularInventory,
IButtonInventory,
INetworkItem {
    private static final String uuidIdentifier = "UUID";
    private static final String SELECTION_ID = "selectionId";
    private static final String DESTINATION = "dests";
    private static final String TMPNAME = "TmpName";
    private static final int BUTTON_ID_CLEAR = 0;
    private static final int BUTTON_ID_DELETE = 1;
    private static final int BUTTON_ID_ADD = 2;
    private static final int BUTTON_ID_OFFSET = 5;

    public ItemStationChip() {
        this.func_77627_a(true);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.field_70170_p.field_72995_K && !stack.func_190926_b() && playerIn.func_70093_af()) {
            playerIn.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARCENTEREDFULLSCREEN.ordinal(), worldIn, -1, -1, -1);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        int offset_all = 96;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b()) {
            modules.add(new ModuleStellarBackground(0, 0, zmaster587.libVulpes.inventory.TextureResources.starryBG));
            LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
            ModuleButton btnAdd = new ModuleButton(76, 64, 2, LibVulpes.proxy.getLocalizedString("msg.label.add"), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
            ModuleButton btnClear = new ModuleButton(76, 100, 0, LibVulpes.proxy.getLocalizedString("msg.label.clear"), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
            ModuleButton btnDelete = new ModuleButton(76, 82, 1, LibVulpes.proxy.getLocalizedString("msg.label.delete"), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
            modules.add((ModuleBase)btnClear);
            modules.add((ModuleBase)btnDelete);
            modules.add((ModuleBase)btnAdd);
            int dimId = DimensionManager.getEffectiveDimId(player.field_70170_p, new BlockPos((Entity)player)).getId();
            List<LandingLocation> list = this.getLandingLocations(stack, dimId);
            int selectedId = this.getSelectionId(stack, dimId);
            int i = 0;
            for (LandingLocation pos : list) {
                ModuleButton button = new ModuleButton(0, i * 18, i + 5, pos.toString(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                list2.add(button);
                if (i == selectedId) {
                    button.setColor(-14483678);
                } else {
                    button.setColor(-56798);
                }
                ++i;
            }
            ModuleContainerPan pan = new ModuleContainerPan(-71, 50, list2, new LinkedList(), null, 512, 256, 0, -48, 258, 256);
            modules.add((ModuleBase)pan);
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "item.stationChip.name";
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            PacketHandler.sendToServer((BasePacket)new PacketItemModifcation((INetworkItem)this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (byte)buttonId));
        }
    }

    private void setTempName(@Nonnull ItemStack stack, String string) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74778_a(TMPNAME, string);
        }
    }

    private String getTempName(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i(TMPNAME);
        }
        return "";
    }

    public void writeDataToNetwork(ByteBuf out, byte id, @Nonnull ItemStack stack) {
        if (id == 2) {
            String str = this.getTempName(stack);
            byte[] byteArray = str.getBytes();
            short len = (short)byteArray.length;
            out.writeShort((int)len);
            out.writeBytes(byteArray, 0, (int)len);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte id, NBTTagCompound nbt, @Nonnull ItemStack stack) {
        if (id == 2) {
            short len = in.readShort();
            byte[] byteArray = new byte[len];
            in.readBytes(byteArray, 0, (int)len);
            nbt.func_74778_a(TMPNAME, new String(byteArray));
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt, @Nonnull ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            int dimId = DimensionManager.getEffectiveDimId(player.field_70170_p, new BlockPos((Entity)player)).getId();
            if (id >= 5) {
                this.setSelectionId(stack, dimId, id - 5);
            } else if (id == 1) {
                int selection = this.getSelectionId(stack, dimId);
                if (selection > 0) {
                    List<LandingLocation> locs = this.getLandingLocations(stack, dimId);
                    if (selection < locs.size()) {
                        locs.remove(selection);
                    }
                    this.setLandingLocations(stack, dimId, locs);
                }
            } else if (id == 0) {
                List<LandingLocation> locs = this.getLandingLocations(stack, dimId);
                LinkedList<LandingLocation> locs2 = new LinkedList<LandingLocation>();
                locs2.add(locs.get(0));
                this.setLandingLocations(stack, dimId, locs2);
            } else if (id == 2 && player.func_130014_f_().field_73011_w.getDimension() == dimId) {
                List<LandingLocation> locs = this.getLandingLocations(stack, dimId);
                BlockPos pos = player.func_180425_c();
                locs.add(new LandingLocation(nbt.func_74779_i(TMPNAME), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                this.setLandingLocations(stack, dimId, locs);
            }
            player.func_71053_j();
            player.openGui((Object)AdvancedRocketry.instance, GuiHandler.guiId.MODULARFULLSCREEN.ordinal(), player.field_70170_p, -1, -1, -1);
        }
    }

    public boolean canInteractWithContainer(EntityPlayer player) {
        return player.func_184586_b(player.func_184600_cs()).func_77973_b() == this;
    }

    public int getSelectionId(@Nonnull ItemStack stack, int dimid) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            int selectedId;
            nbt = nbt.func_74775_l("dimid" + dimid);
            int size = this.getLandingLocations(stack, dimid).size();
            return size > (selectedId = nbt.func_74762_e(SELECTION_ID)) ? selectedId : 0;
        }
        return 0;
    }

    public void setSelectionId(@Nonnull ItemStack stack, int dimid, int slotId) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            nbt = nbt.func_74775_l("dimid" + dimid);
            nbt.func_74768_a(SELECTION_ID, slotId);
        }
    }

    public List<LandingLocation> getLandingLocations(@Nonnull ItemStack stack, int dimid) {
        NBTTagCompound nbt;
        LinkedList<LandingLocation> retList = new LinkedList<LandingLocation>();
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            nbt = nbt.func_74775_l("dimid" + dimid);
            NBTTagList destList = nbt.func_150295_c(DESTINATION, 10);
            if (nbt.func_74764_b("x")) {
                float x = nbt.func_74760_g("x");
                float y = nbt.func_74760_g("y");
                float z = nbt.func_74760_g("z");
                nbt.func_82580_o("x");
                nbt.func_82580_o("y");
                nbt.func_82580_o("z");
                List<LandingLocation> list2 = this.getLandingLocations(stack, dimid);
                list2.add(0, new LandingLocation("Last", x, y, z));
                this.setLandingLocations(stack, dimid, list2);
            }
            for (NBTBase tag : destList) {
                retList.add(LandingLocation.loadFromNBT((NBTTagCompound)tag));
            }
        }
        return retList;
    }

    public void setLandingLocations(@Nonnull ItemStack stack, int dimid, List<LandingLocation> locations) {
        if (stack.func_77942_o()) {
            String tagName;
            NBTTagCompound stackNBT = stack.func_77978_p();
            NBTTagCompound nbt = stackNBT.func_74764_b(tagName = "dimid" + dimid) ? stackNBT.func_74775_l("dimid" + dimid) : new NBTTagCompound();
            NBTTagList destList = new NBTTagList();
            for (LandingLocation loc : locations) {
                NBTTagCompound nbtTag = new NBTTagCompound();
                loc.saveToNBT(nbtTag);
                destList.func_74742_a((NBTBase)nbtTag);
            }
            nbt.func_74782_a(DESTINATION, (NBTBase)destList);
            stackNBT.func_74782_a(tagName, (NBTBase)nbt);
        }
    }

    public void setTakeoffCoords(@Nonnull ItemStack stack, Vector3F<Float> pos, int dimid, int slot) {
        this.setTakeoffCoords(stack, ((Float)pos.x).floatValue(), ((Float)pos.y).floatValue(), ((Float)pos.z).floatValue(), dimid, slot);
    }

    public void setTakeoffCoords(@Nonnull ItemStack stack, float x, float y, float z, int dimid, int slot) {
        LandingLocation landingLoc = new LandingLocation("Last", x, y, z);
        List<LandingLocation> landingLocList = this.getLandingLocations(stack, dimid);
        if (landingLocList.isEmpty() || slot >= landingLocList.size()) {
            landingLocList.add(landingLoc);
        } else {
            landingLocList.set(slot, landingLoc);
        }
        this.setLandingLocations(stack, dimid, landingLocList);
    }

    public LandingLocation getTakeoffCoords(@Nonnull ItemStack stack, int dimid) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            List<LandingLocation> landingLocList = this.getLandingLocations(stack, dimid);
            int id = this.getSelectionId(stack, dimid);
            if (landingLocList.isEmpty()) {
                return null;
            }
            LandingLocation loc = id < landingLocList.size() && id > 0 ? landingLocList.get(id) : landingLocList.get(0);
            return loc;
        }
        return null;
    }

    public static int getUUID(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(uuidIdentifier);
        }
        return 0;
    }

    public static void setUUID(@Nonnull ItemStack stack, int uuid) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a(uuidIdentifier, uuid);
        stack.func_77982_d(nbt);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World player, List<String> list, ITooltipFlag bool) {
        if (ItemStationChip.getUUID(stack) == 0) {
            list.add(ChatFormatting.GRAY + LibVulpes.proxy.getLocalizedString("msg.unprogrammed"));
        } else {
            list.add(ChatFormatting.GREEN + LibVulpes.proxy.getLocalizedString("msg.stationchip.sation") + ItemStationChip.getUUID(stack));
            super.func_77624_a(stack, player, list, bool);
            if (player.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId) {
                EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
                ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(p.func_180425_c());
                if (spaceObject != null) {
                    LandingLocation loc = this.getTakeoffCoords(stack, spaceObject.getOrbitingPlanetId());
                    if (loc != null) {
                        Vector3F<Float> vec = loc.location;
                        list.add("Name: " + loc.name);
                        list.add("X: " + vec.x);
                        list.add("Z: " + vec.z);
                    } else {
                        list.add("Name: N/A");
                        list.add("X: N/A");
                        list.add("Z: N/A");
                    }
                }
            } else {
                LandingLocation loc = this.getTakeoffCoords(stack, player.field_73011_w.getDimension());
                if (loc != null) {
                    Vector3F<Float> vec = loc.location;
                    list.add("Name: " + loc.name);
                    list.add("X: " + vec.x);
                    list.add("Z: " + vec.z);
                } else {
                    list.add("Name: N/A");
                    list.add("X: N/A");
                    list.add("Z: N/A");
                }
            }
            list.add(ChatFormatting.DARK_GRAY + LibVulpes.proxy.getLocalizedString("item.stationchip.openmenu"));
        }
    }

    public static class LandingLocation {
        public String name;
        public Vector3F<Float> location;

        public LandingLocation(String name, Vector3F<Float> location) {
            this.name = name;
            this.location = location;
        }

        public LandingLocation(String name, float x, float y, float z) {
            this.name = name;
            this.location = new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z));
        }

        public LandingLocation() {
            this.name = "";
            this.location = new Vector3F((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }

        public String toString() {
            return String.format("%s: %.0f, %.0f", this.name, this.location.x, this.location.z);
        }

        static LandingLocation loadFromNBT(NBTTagCompound nbt) {
            String name = nbt.func_74779_i("name");
            Vector3F vec = new Vector3F((Object)Float.valueOf(nbt.func_74760_g("x")), (Object)Float.valueOf(nbt.func_74760_g("y")), (Object)Float.valueOf(nbt.func_74760_g("z")));
            return new LandingLocation(name, (Vector3F<Float>)vec);
        }

        void saveToNBT(NBTTagCompound nbt) {
            nbt.func_74778_a("name", this.name);
            nbt.func_74776_a("x", ((Float)this.location.x).floatValue());
            nbt.func_74776_a("y", ((Float)this.location.y).floatValue());
            nbt.func_74776_a("z", ((Float)this.location.z).floatValue());
        }
    }
}

