/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.world.util.MultiData;

public class ItemMultiData
extends Item {
    public void setMaxData(@Nonnull ItemStack stack, int amount) {
        MultiData data = this.getDataStorage(stack);
        data.setMaxData(amount);
        NBTTagCompound nbt = !stack.func_77942_o() ? new NBTTagCompound() : stack.func_77978_p();
        data.writeToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    public int getData(@Nonnull ItemStack stack, DataStorage.DataType type) {
        return this.getDataStorage(stack).getDataAmount(type);
    }

    public int getMaxData(@Nonnull ItemStack stack) {
        return this.getDataStorage(stack).getMaxData();
    }

    private MultiData getDataStorage(@Nonnull ItemStack item) {
        MultiData data = new MultiData();
        if (!item.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            data.writeToNBT(nbt);
        } else {
            data.readFromNBT(item.func_77978_p());
        }
        return data;
    }

    public boolean isFull(@Nonnull ItemStack item, DataStorage.DataType dataType) {
        return this.getDataStorage(item).getMaxData() == this.getData(item, dataType);
    }

    public int addData(@Nonnull ItemStack item, int amount, DataStorage.DataType dataType) {
        MultiData data = this.getDataStorage(item);
        int amt = data.addData(amount, dataType, EnumFacing.DOWN, true);
        NBTTagCompound nbt = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public int removeData(@Nonnull ItemStack item, int amount, DataStorage.DataType dataType) {
        MultiData data = this.getDataStorage(item);
        int amt = data.extractData(amount, dataType, EnumFacing.DOWN, true);
        NBTTagCompound nbt = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public void setData(@Nonnull ItemStack item, int amount, DataStorage.DataType dataType) {
        MultiData data = this.getDataStorage(item);
        data.setDataAmount(amount, dataType);
        NBTTagCompound nbt = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World player, List<String> list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        MultiData data = this.getDataStorage(stack);
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            list.add(data.getDataAmount(type) + " / " + data.getMaxData() + " " + I18n.func_135052_a((String)type.toString(), (Object[])new Object[0]) + " Data");
        }
    }
}

