/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.libVulpes.items.ItemIngredient;

public class ItemData
extends ItemIngredient {
    int maxData;

    public ItemData() {
        super(1);
        this.func_77625_d(1);
    }

    public int getMaxData(int damage) {
        return damage == 0 ? 1000 : 0;
    }

    public int getItemStackLimit(@Nonnull ItemStack stack) {
        return this.getData(stack) == 0 ? super.getItemStackLimit(stack) : 1;
    }

    public int getData(@Nonnull ItemStack stack) {
        return this.getDataStorage(stack).getData();
    }

    public DataStorage.DataType getDataType(@Nonnull ItemStack stack) {
        return this.getDataStorage(stack).getDataType();
    }

    public DataStorage getDataStorage(@Nonnull ItemStack item) {
        DataStorage data = new DataStorage();
        if (!item.func_77942_o()) {
            data.setMaxData(this.getMaxData(item.func_77952_i()));
            NBTTagCompound nbt = new NBTTagCompound();
            data.writeToNBT(nbt);
        } else {
            data.readFromNBT(item.func_77978_p());
        }
        return data;
    }

    public int addData(@Nonnull ItemStack item, int amount, DataStorage.DataType dataType) {
        DataStorage data = this.getDataStorage(item);
        int amt = data.addData(amount, dataType, true);
        NBTTagCompound nbt = new NBTTagCompound();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public int removeData(@Nonnull ItemStack item, int amount, DataStorage.DataType dataType) {
        DataStorage data = this.getDataStorage(item);
        int amt = data.removeData(amount, true);
        NBTTagCompound nbt = new NBTTagCompound();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public void setData(@Nonnull ItemStack item, int amount, DataStorage.DataType dataType) {
        DataStorage data = this.getDataStorage(item);
        data.setData(amount, dataType);
        NBTTagCompound nbt = new NBTTagCompound();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World player, List<String> list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        DataStorage data = this.getDataStorage(stack);
        list.add(data.getData() + " / " + data.getMaxData() + " Data");
        list.add(I18n.func_135052_a((String)data.getDataType().toString(), (Object[])new Object[0]));
    }
}

