/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.render.RenderHelper;

public class ItemAtmosphereAnalzer
extends Item
implements IArmorComponent {
    private static ResourceIcon icon;
    private static ResourceLocation eyeCandySpinner;
    private static String breathable;
    private static String atmtype;
    private static String yes;
    private static String no;

    public void onTick(World world, EntityPlayer player, @Nonnull ItemStack armorStack, IInventory modules, @Nonnull ItemStack componentStack) {
    }

    private List<ITextComponent> getAtmosphereReadout(@Nonnull ItemStack stack, @Nullable AtmosphereType atm, @Nonnull World world) {
        if (atm == null) {
            atm = AtmosphereType.AIR;
        }
        LinkedList<ITextComponent> str = new LinkedList<ITextComponent>();
        Object[] objectArray = new Object[3];
        objectArray[0] = new TextComponentTranslation("msg.atmanal.atmtype", new Object[0]);
        objectArray[1] = new TextComponentTranslation(atm.getUnlocalizedName(), new Object[0]);
        objectArray[2] = new TextComponentString((AtmosphereHandler.currentPressure == -1 ? (DimensionManager.getInstance().isDimensionCreated(world.field_73011_w.getDimension()) ? (float)DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension()).getAtmosphereDensity() / 100.0f : 1.0f) : (float)AtmosphereHandler.currentPressure / 100.0f) + " atm");
        str.add((ITextComponent)new TextComponentTranslation("%s %s %s", objectArray));
        str.add((ITextComponent)new TextComponentTranslation("%s %s", new Object[]{new TextComponentTranslation("msg.atmanal.canbreathe", new Object[0]), atm.isBreathable() ? new TextComponentTranslation("msg.yes", new Object[0]) : new TextComponentTranslation("msg.no", new Object[0])}));
        return str;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.getDimension());
            List<ITextComponent> str = this.getAtmosphereReadout(stack, atmhandler == null ? null : (AtmosphereType)atmhandler.getAtmosphereType((Entity)playerIn), worldIn);
            for (ITextComponent str1 : str) {
                playerIn.func_145747_a(str1);
            }
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public boolean onComponentAdded(World world, @Nonnull ItemStack armorStack) {
        return true;
    }

    public void onComponentRemoved(World world, @Nonnull ItemStack armorStack) {
    }

    public void onArmorDamaged(EntityLivingBase entity, @Nonnull ItemStack armorStack, @Nonnull ItemStack componentStack, DamageSource source, int damage) {
    }

    public boolean isAllowedInSlot(@Nonnull ItemStack componentStack, EntityEquipmentSlot targetSlot) {
        return targetSlot == EntityEquipmentSlot.HEAD;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScreen(@Nonnull ItemStack componentStack, List<ItemStack> modules, RenderGameOverlayEvent event, Gui gui) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int screenX = RocketEventHandler.atmBar.getRenderX();
        int screenY = RocketEventHandler.atmBar.getRenderY();
        List<ITextComponent> str = this.getAtmosphereReadout(componentStack, (AtmosphereType)AtmosphereHandler.currentAtm, (World)Minecraft.func_71410_x().field_71441_e);
        gui.func_73731_b(fontRenderer, str.get(0).func_150254_d(), screenX, screenY, 0xAAFFFF);
        gui.func_73731_b(fontRenderer, str.get(1).func_150254_d(), screenX, screenY + fontRenderer.field_78288_b * 4 / 3, 0xAAFFFF);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(eyeCandySpinner);
        GL11.glTranslatef((float)(screenX + 12), (float)(screenY + 8), (float)0.0f);
        GL11.glRotatef((float)((float)System.currentTimeMillis() / 100.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)-1.0, (double)-16.0, (double)-16.0, (double)16.0, (double)16.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)-1.0, (double)(screenX - 8), (double)(screenY - 12), (double)(screenX + 8), (double)(screenY + 26), (double)0.0, (double)0.25, (double)0.0, (double)1.0);
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)-1.0, (double)(screenX + 8), (double)(screenY - 12), (double)(screenX + 212), (double)(screenY + 26), (double)0.5, (double)0.5, (double)0.0, (double)1.0);
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)-1.0, (double)(screenX + 212), (double)(screenY - 12), (double)(screenX + 228), (double)(screenY + 26), (double)0.75, (double)1.0, (double)0.0, (double)1.0);
        Tessellator.func_178181_a().func_78381_a();
    }

    public ResourceIcon getComponentIcon(@Nonnull ItemStack armorStack) {
        return null;
    }

    static {
        eyeCandySpinner = new ResourceLocation("advancedrocketry:textures/gui/eyeCandy/spinnyThing.png");
        breathable = LibVulpes.proxy.getLocalizedString("msg.atmanal.canbreathe");
        atmtype = LibVulpes.proxy.getLocalizedString("msg.atmanal.atmType");
        yes = LibVulpes.proxy.getLocalizedString("msg.yes");
        no = LibVulpes.proxy.getLocalizedString("msg.no");
    }
}

