/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.client.render.entity.RenderPlanetUIEntity;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererWarpCore;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityUIStar;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.render.RenderHelper;

public class RenderStarUIEntity
extends Render<EntityUIStar>
implements IRenderFactory<EntityUIStar> {
    public RenderStarUIEntity(RenderManager renderManager) {
        super(renderManager);
    }

    public Render<? super EntityUIStar> createRenderFor(RenderManager manager) {
        return new RenderStarUIEntity(manager);
    }

    protected ResourceLocation getEntityTexture(EntityUIStar entity) {
        return DimensionProperties.PlanetIcons.EARTHLIKE.getResource();
    }

    public void doRender(EntityUIStar entity, double x, double y, double z, float entityYaw, float partialTicks) {
        StellarBody body = entity.getStarProperties();
        if (body == null) {
            return;
        }
        float sizeScale = entity.getScale();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)sizeScale, (float)sizeScale, (float)sizeScale);
        RenderHelper.setupPlayerFacingMatrix((double)Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)entity), (double)0.0, (double)-0.45, (double)0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.locationSunNew);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glColor3d((double)body.getColor()[0], (double)body.getColor()[1], (double)body.getColor()[2]);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        Tessellator.func_178181_a().func_78381_a();
        RenderHelper.cleanupPlayerFacingMatrix();
        GL11.glPushMatrix();
        GL11.glScaled((double)0.1, (double)0.1, (double)0.1);
        GlStateManager.func_179112_b((int)770, (int)771);
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179090_x();
        for (int i = 0; i < 4; ++i) {
            float myTime = (float)((long)(i * 4) + entity.field_70170_p.func_82737_E() & 0xFL) / 16.0f;
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)1.0f, (float)(0.2f * (1.0f - myTime)));
            buf.func_181668_a(7, DefaultVertexFormats.field_181708_h);
            RenderHelper.renderTopFace((BufferBuilder)buf, (double)myTime, (double)-0.5, (double)-0.5, (double)0.5, (double)0.5);
            RenderHelper.renderBottomFace((BufferBuilder)buf, (double)((double)myTime - 0.5), (double)-0.5, (double)-0.5, (double)0.5, (double)0.5);
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179098_w();
        if (entity.isSelected()) {
            GlStateManager.func_179090_x();
            double speedRotate = 0.025;
            GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)1.0f, (float)0.6f);
            GL11.glTranslated((double)0.0, (double)-0.75, (double)0.0);
            GL11.glPushMatrix();
            GL11.glRotated((double)(speedRotate * (double)System.currentTimeMillis() % 360.0), (double)0.0, (double)1.0, (double)0.0);
            RendererWarpCore.model.renderOnly("Rotate1");
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotated((double)(180.0 + speedRotate * (double)System.currentTimeMillis() % 360.0), (double)0.0, (double)1.0, (double)0.0);
            RendererWarpCore.model.renderOnly("Rotate1");
            GL11.glPopMatrix();
            GlStateManager.func_179098_w();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        RayTraceResult hitObj = Minecraft.func_71410_x().field_71476_x;
        if (hitObj != null && hitObj.field_72308_g == entity) {
            GL11.glPushMatrix();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslated((double)x, (double)(y + (double)(sizeScale * 0.03f)), (double)z);
            sizeScale = 0.1f * sizeScale;
            GL11.glScaled((double)sizeScale, (double)sizeScale, (double)sizeScale);
            RenderHelper.setupPlayerFacingMatrix((double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.field_72307_f.field_72450_a, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72449_c), (double)0.0, (double)0.0, (double)0.0);
            buffer = Tessellator.func_178181_a().func_178180_c();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderPlanetUIEntity.planetUIFG);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            this.renderMassIndicator(buffer, (float)body.getTemperature() / 200.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderPlanetUIEntity.planetUIBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)1.0, (double)-40.0, (double)-25.0, (double)40.0, (double)55.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0);
            Tessellator.func_178181_a().func_78381_a();
            RenderHelper.cleanupPlayerFacingMatrix();
            RenderHelper.renderTag((double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.field_72307_f.field_72450_a, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72449_c), (String)body.getName(), (double)0.0, (double)0.9, (double)0.0, (int)5);
            RenderHelper.renderTag((double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.field_72307_f.field_72450_a, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72449_c), (String)("Num Planets: " + body.getNumPlanets()), (double)0.0, (double)0.6, (double)0.0, (int)5);
            GL11.glPopMatrix();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    protected void renderMassIndicator(BufferBuilder buffer, float percent) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float maxUV = (1.0f - percent) * 0.5f;
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-20.0, (double)(-5.0f + 41.0f * (1.0f - percent)), (double)20.0, (double)36.0, (double)0.5, (double)0.0, (double)0.5, (double)maxUV);
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void renderATMIndicator(BufferBuilder buffer, float percent) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)6.0, (double)(20.0f + (1.0f - percent) * 33.0f), (double)39.0, (double)53.0, (double)0.5624f, (double)0.984f, (double)0.984f, (double)maxUV);
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void renderTemperatureIndicator(BufferBuilder buffer, float percent) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-38.0, (double)(21.4f + (1.0f - percent) * 33.0f), (double)-4.0, (double)53.0, (double)0.016f, (double)0.4376f, (double)0.984f, (double)maxUV);
        Tessellator.func_178181_a().func_78381_a();
    }
}

