/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.libVulpes.util.HashedBlockPosition;

public abstract class EntityRocketBase
extends Entity {
    protected LinkedList<IInfrastructure> connectedInfrastructure;
    protected Set<HashedBlockPosition> infrastructureCoords;
    public StatsRocket stats;

    public EntityRocketBase(World world) {
        super(world);
    }

    public void unlinkInfrastructure(IInfrastructure tile) {
        this.connectedInfrastructure.remove(tile);
    }

    public void linkInfrastructure(IInfrastructure tile) {
        if (!this.connectedInfrastructure.contains(tile) && tile.linkRocket(this)) {
            this.connectedInfrastructure.add(tile);
        }
    }

    public abstract void prepareLaunch();

    public abstract void launch();

    public abstract int getFuelAmount(@Nullable FuelRegistry.FuelType var1);

    public abstract int addFuelAmount(@Nonnull FuelRegistry.FuelType var1, int var2);

    public abstract void setFuelAmount(@Nonnull FuelRegistry.FuelType var1, int var2);

    public abstract void setFuelConsumptionRate(@Nonnull FuelRegistry.FuelType var1, int var2);

    public abstract int getFuelCapacity(@Nullable FuelRegistry.FuelType var1);

    public abstract int getFuelConsumptionRate(@Nullable FuelRegistry.FuelType var1);

    @Nullable
    public abstract FuelRegistry.FuelType getRocketFuelType();

    public String getTextOverlay() {
        return "";
    }

    public abstract StatsRocket getRocketStats();

    public void onOrbitReached() {
        ISpaceObject station;
        MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketReachesOrbitEvent(this));
        if (this.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && (station = AdvancedRocketryAPI.spaceObjectManager.getSpaceStationFromBlockCoords(this.func_180425_c())) != null) {
            station.setPadStatus((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70161_v), false);
        }
    }

    public void deconstructRocket() {
        MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDismantleEvent(this));
    }
}

