/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.helpers.NonBlockingItems;
import appeng.util.inv.BlockingInventoryAdaptor;
import appeng.util.inv.ItemHandlerIterator;
import appeng.util.inv.ItemSlot;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class BlockingItemHandler
extends BlockingInventoryAdaptor {
    protected final IItemHandler itemHandler;
    private final String domain;

    public BlockingItemHandler(IItemHandler itemHandler, String domain) {
        this.itemHandler = itemHandler;
        this.domain = domain;
    }

    boolean isBlockableItem(ItemStack stack) {
        Object2ObjectOpenHashMap<Item, IntSet> map = NonBlockingItems.INSTANCE.getMap().get(this.domain);
        if (map.get((Object)stack.func_77973_b()) != null) {
            return !((IntSet)map.get((Object)stack.func_77973_b())).contains(stack.func_77960_j());
        }
        return true;
    }

    @Override
    public boolean containsBlockingItems() {
        int slots = this.itemHandler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !this.isBlockableItem(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new ItemHandlerIterator(this.itemHandler);
    }
}

