/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.SortOrder;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.stats.Stats;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.GuiHostType;
import appeng.fluids.util.AEFluidStack;
import appeng.hooks.TickHandler;
import appeng.integration.Integrations;
import appeng.integration.modules.bogosorter.InventoryBogoSortModule;
import appeng.integration.modules.gregtech.ToolClass;
import appeng.me.GridAccessException;
import appeng.me.GridNode;
import appeng.me.helpers.AENetworkProxy;
import appeng.util.BlockUpdate;
import appeng.util.LookDirection;
import appeng.util.helpers.ItemComparisonHelper;
import appeng.util.helpers.P2PHelper;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import cofh.api.item.IToolHammer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import ic2.api.item.ICustomDamageItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="ic2.api.item.ICustomDamageItem", modid="IC2")
public class Platform {
    public static final Block AIR_BLOCK = Blocks.field_150350_a;
    public static final int DEF_OFFSET = 16;
    private static final boolean CLIENT_INSTALL = FMLCommonHandler.instance().getSide().isClient();
    private static final Random RANDOM_GENERATOR = new Random();
    private static final WeakHashMap<World, EntityPlayer> FAKE_PLAYERS = new WeakHashMap();
    private static final ItemComparisonHelper ITEM_COMPARISON_HELPER = new ItemComparisonHelper();
    private static final P2PHelper P2P_HELPER = new P2PHelper();
    private static Method reflectGTgetMTE;
    public static final boolean GTLoaded;

    public static ItemComparisonHelper itemComparisons() {
        return ITEM_COMPARISON_HELPER;
    }

    public static P2PHelper p2p() {
        return P2P_HELPER;
    }

    public static Random getRandom() {
        return RANDOM_GENERATOR;
    }

    public static float getRandomFloat() {
        return RANDOM_GENERATOR.nextFloat();
    }

    public static String formatPowerLong(long n, boolean isRate) {
        double p = (double)n / 100.0;
        PowerUnits displayUnits = AEConfig.instance().selectedPowerUnit();
        p = PowerUnits.AE.convertTo(displayUnits, p);
        String[] preFixes = new String[]{"k", "M", "G", "T", "P", "T", "P", "E", "Z", "Y"};
        String unitName = displayUnits.name();
        String level = "";
        for (int offset = 0; p > 1000.0 && offset < preFixes.length; p /= 1000.0, ++offset) {
            level = preFixes[offset];
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(p) + ' ' + level + unitName + (isRate ? "/t" : "");
    }

    public static AEPartLocation crossProduct(AEPartLocation forward, AEPartLocation up) {
        int west_x = forward.yOffset * up.zOffset - forward.zOffset * up.yOffset;
        int west_y = forward.zOffset * up.xOffset - forward.xOffset * up.zOffset;
        int west_z = forward.xOffset * up.yOffset - forward.yOffset * up.xOffset;
        switch (west_x + west_y * 2 + west_z * 3) {
            case 1: {
                return AEPartLocation.EAST;
            }
            case -1: {
                return AEPartLocation.WEST;
            }
            case 2: {
                return AEPartLocation.UP;
            }
            case -2: {
                return AEPartLocation.DOWN;
            }
            case 3: {
                return AEPartLocation.SOUTH;
            }
            case -3: {
                return AEPartLocation.NORTH;
            }
        }
        return AEPartLocation.INTERNAL;
    }

    public static EnumFacing crossProduct(EnumFacing forward, EnumFacing up) {
        int west_x = forward.func_96559_d() * up.func_82599_e() - forward.func_82599_e() * up.func_96559_d();
        int west_y = forward.func_82599_e() * up.func_82601_c() - forward.func_82601_c() * up.func_82599_e();
        int west_z = forward.func_82601_c() * up.func_96559_d() - forward.func_96559_d() * up.func_82601_c();
        switch (west_x + west_y * 2 + west_z * 3) {
            case 1: {
                return EnumFacing.EAST;
            }
            case -1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.UP;
            }
            case -2: {
                return EnumFacing.DOWN;
            }
            case 3: {
                return EnumFacing.SOUTH;
            }
            case -3: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.NORTH;
    }

    public static <T extends Enum> T rotateEnum(T ce, boolean backwards, EnumSet validOptions) {
        while (!validOptions.contains(ce = backwards ? Platform.prevEnum(ce) : Platform.nextEnum(ce)) || Platform.isNotValidSetting(ce)) {
        }
        return ce;
    }

    private static <T extends Enum> T prevEnum(T ce) {
        EnumSet valList = EnumSet.allOf(ce.getClass());
        int pLoc = ce.ordinal() - 1;
        if (pLoc < 0) {
            pLoc = valList.size() - 1;
        }
        if (pLoc < 0 || pLoc >= valList.size()) {
            pLoc = 0;
        }
        int pos = 0;
        for (Object g : valList) {
            if (pos == pLoc) {
                return (T)((Enum)g);
            }
            ++pos;
        }
        return null;
    }

    public static <T extends Enum> T nextEnum(T ce) {
        EnumSet valList = EnumSet.allOf(ce.getClass());
        int pLoc = ce.ordinal() + 1;
        if (pLoc >= valList.size()) {
            pLoc = 0;
        }
        if (pLoc < 0 || pLoc >= valList.size()) {
            pLoc = 0;
        }
        int pos = 0;
        for (Object g : valList) {
            if (pos == pLoc) {
                return (T)((Enum)g);
            }
            ++pos;
        }
        return null;
    }

    private static boolean isNotValidSetting(Enum e) {
        if (e == SortOrder.INVTWEAKS && !Integrations.invTweaks().isEnabled() && !InventoryBogoSortModule.isLoaded()) {
            return true;
        }
        boolean isJEI = e == SearchBoxMode.JEI_AUTOSEARCH || e == SearchBoxMode.JEI_AUTOSEARCH_KEEP || e == SearchBoxMode.JEI_MANUAL_SEARCH || e == SearchBoxMode.JEI_MANUAL_SEARCH_KEEP;
        return isJEI && !Integrations.jei().isEnabled();
    }

    public static void openGUI(@Nonnull EntityPlayer p, @Nullable TileEntity tile, @Nullable AEPartLocation side, @Nonnull GuiBridge type) {
        if (Platform.isClient()) {
            return;
        }
        int x = 0;
        int y = 0;
        int z = Integer.MIN_VALUE;
        if (tile != null) {
            x = tile.func_174877_v().func_177958_n();
            y = tile.func_174877_v().func_177956_o();
            z = tile.func_174877_v().func_177952_p();
        } else if (p.field_71070_bA instanceof IInventorySlotAware) {
            x = ((IInventorySlotAware)p.field_71070_bA).getInventorySlot();
            y = ((IInventorySlotAware)p.field_71070_bA).isBaubleSlot() ? 1 : 0;
        } else {
            x = p.field_71071_by.field_70461_c;
        }
        if (type.getType().isItem() && tile == null || type.hasPermissions(tile, x, y, z, side, p)) {
            if (tile == null && type.getType() == GuiHostType.ITEM) {
                p.openGui((Object)AppEng.instance(), type.ordinal() << 4, p.func_130014_f_(), x, 0, 0);
            } else if (tile == null || type.getType() == GuiHostType.ITEM) {
                if (tile != null) {
                    p.openGui((Object)AppEng.instance(), type.ordinal() << 4 | 8, p.func_130014_f_(), x, y, z);
                } else {
                    p.openGui((Object)AppEng.instance(), type.ordinal() << 4, p.func_130014_f_(), x, y, z);
                }
            } else {
                p.openGui((Object)AppEng.instance(), type.ordinal() << 4 | side.ordinal(), tile.func_145831_w(), x, y, z);
            }
        }
    }

    public static void openGUI(@Nonnull EntityPlayer p, int slot, @Nonnull GuiBridge type, boolean isBauble) {
        if (Platform.isClient()) {
            return;
        }
        if (type.getType().isItem()) {
            p.openGui((Object)AppEng.instance(), type.ordinal() << 4, p.func_130014_f_(), slot, isBauble ? 1 : 0, Integer.MIN_VALUE);
        }
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean isClientInstall() {
        return CLIENT_INSTALL;
    }

    public static boolean hasPermissions(DimensionalCoord dc, EntityPlayer player) {
        return dc.getWorld().canMineBlockBody(player, dc.getPos());
    }

    public static boolean hasPermissions(World world, BlockPos pos, EntityPlayer player) {
        return world.canMineBlockBody(player, pos);
    }

    public static boolean isBlockAir(World w, BlockPos pos) {
        try {
            return w.func_180495_p(pos).func_177230_c().isAir(w.func_180495_p(pos), (IBlockAccess)w, pos);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static ItemStack[] getBlockDrops(World w, BlockPos pos) {
        List out = new ArrayList();
        IBlockState state = w.func_180495_p(pos);
        if (state != null) {
            out = state.func_177230_c().getDrops((IBlockAccess)w, pos, state, 0);
        }
        if (out == null) {
            return new ItemStack[0];
        }
        return out.toArray(new ItemStack[out.size()]);
    }

    public static AEPartLocation cycleOrientations(AEPartLocation dir, boolean upAndDown) {
        if (upAndDown) {
            switch (dir) {
                case NORTH: {
                    return AEPartLocation.SOUTH;
                }
                case SOUTH: {
                    return AEPartLocation.EAST;
                }
                case EAST: {
                    return AEPartLocation.WEST;
                }
                case WEST: {
                    return AEPartLocation.NORTH;
                }
                case UP: {
                    return AEPartLocation.UP;
                }
                case DOWN: {
                    return AEPartLocation.DOWN;
                }
                case INTERNAL: {
                    return AEPartLocation.INTERNAL;
                }
            }
        } else {
            switch (dir) {
                case UP: {
                    return AEPartLocation.DOWN;
                }
                case DOWN: {
                    return AEPartLocation.NORTH;
                }
                case NORTH: {
                    return AEPartLocation.SOUTH;
                }
                case SOUTH: {
                    return AEPartLocation.EAST;
                }
                case EAST: {
                    return AEPartLocation.WEST;
                }
                case WEST: {
                    return AEPartLocation.UP;
                }
                case INTERNAL: {
                    return AEPartLocation.INTERNAL;
                }
            }
        }
        return AEPartLocation.INTERNAL;
    }

    public static NBTTagCompound openNbtData(ItemStack i) {
        NBTTagCompound compound = i.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            i.func_77982_d(compound);
        }
        return compound;
    }

    public static void spawnDrops(World w, BlockPos pos, List<ItemStack> drops) {
        if (Platform.isServer()) {
            for (ItemStack i : drops) {
                if (i.func_190926_b() || i.func_190916_E() <= 0) continue;
                double offset_x = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_y = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_z = (Platform.getRandomInt() % 32 - 16) / 82;
                EntityItem ei = new EntityItem(w, 0.5 + offset_x + (double)pos.func_177958_n(), 0.5 + offset_y + (double)pos.func_177956_o(), 0.2 + offset_z + (double)pos.func_177952_p(), i.func_77946_l());
                w.func_72838_d((Entity)ei);
            }
        }
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static int getRandomInt() {
        return Math.abs(RANDOM_GENERATOR.nextInt());
    }

    public static boolean isModLoaded(String modid) {
        try {
            return Loader.isModLoaded((String)modid);
        }
        catch (Throwable throwable) {
            for (ModContainer f : Loader.instance().getActiveModList()) {
                if (!f.getModId().equals(modid)) continue;
                return true;
            }
            return false;
        }
    }

    public static ItemStack findMatchingRecipeOutput(InventoryCrafting ic, World world) {
        return CraftingManager.func_82787_a((InventoryCrafting)ic, (World)world);
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getTooltip(Object o) {
        if (o == null) {
            return new ArrayList<String>();
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        if (o instanceof AEItemStack) {
            AEItemStack ais = (AEItemStack)o;
            return ais.getToolTip();
        }
        if (!(o instanceof ItemStack)) {
            return new ArrayList<String>();
        }
        itemStack = (ItemStack)o;
        try {
            ITooltipFlag.TooltipFlags tooltipFlag = Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            return itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)tooltipFlag);
        }
        catch (Exception errB) {
            return new ArrayList<String>();
        }
    }

    public static String getModId(IAEItemStack is) {
        if (is == null) {
            return "** Null";
        }
        String n = ((AEItemStack)is).getModID();
        return n == null ? "** Null" : n;
    }

    public static String getModId(IAEFluidStack fs) {
        if (fs == null || fs.getFluidStack() == null) {
            return "** Null";
        }
        String n = FluidRegistry.getModId((FluidStack)fs.getFluidStack());
        return n == null ? "** Null" : n;
    }

    public static String getItemDisplayName(Object o) {
        if (o == null) {
            return "** Null";
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        if (o instanceof AEItemStack) {
            String n = ((AEItemStack)o).getDisplayName();
            return n == null ? "** Null" : n;
        }
        if (!(o instanceof ItemStack)) {
            return "**Invalid Object";
        }
        itemStack = (ItemStack)o;
        try {
            String name = itemStack.func_82833_r();
            if (name == null || name.isEmpty()) {
                name = itemStack.func_77973_b().func_77667_c(itemStack);
            }
            return name == null ? "** Null" : name;
        }
        catch (Exception errA) {
            try {
                String n = itemStack.func_77977_a();
                return n == null ? "** Null" : n;
            }
            catch (Exception errB) {
                return "** Exception";
            }
        }
    }

    public static String getFluidDisplayName(Object o) {
        if (o == null) {
            return "** Null";
        }
        FluidStack fluidStack = null;
        if (o instanceof AEFluidStack) {
            fluidStack = ((AEFluidStack)o).getFluidStack();
        } else if (o instanceof FluidStack) {
            fluidStack = (FluidStack)o;
        } else {
            return "**Invalid Object";
        }
        String n = fluidStack.getLocalizedName();
        if (n == null || "".equalsIgnoreCase(n)) {
            n = fluidStack.getUnlocalizedName();
        }
        return n == null ? "** Null" : n;
    }

    public static boolean isWrench(EntityPlayer player, ItemStack eq, BlockPos pos) {
        if (!eq.func_190926_b()) {
            try {
                if (eq.func_77973_b() instanceof IToolHammer) {
                    return ((IToolHammer)eq.func_77973_b()).isUsable(eq, (EntityLivingBase)player, pos);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (eq.func_77973_b() instanceof IAEWrench) {
                IAEWrench wrench = (IAEWrench)eq.func_77973_b();
                return wrench.canWrench(eq, player, pos);
            }
        }
        return false;
    }

    public static boolean isChargeable(ItemStack i) {
        if (i.func_190926_b()) {
            return false;
        }
        Item it = i.func_77973_b();
        if (it instanceof IAEItemPowerStorage) {
            return ((IAEItemPowerStorage)it).getPowerFlow(i) != AccessRestriction.READ;
        }
        return false;
    }

    public static EntityPlayer getPlayer(WorldServer w) {
        if (w == null) {
            throw new InvalidParameterException("World is null.");
        }
        EntityPlayer wrp = FAKE_PLAYERS.get(w);
        if (wrp != null) {
            return wrp;
        }
        FakePlayer p = FakePlayerFactory.getMinecraft((WorldServer)w);
        FAKE_PLAYERS.put((World)w, (EntityPlayer)p);
        return p;
    }

    public static int MC2MEColor(int color) {
        switch (color) {
            case 4: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 15: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 2: {
                return 6;
            }
        }
        return -1;
    }

    public static int findEmpty(RegistryNamespaced registry, int minId, int maxId) {
        for (int x = minId; x < maxId; ++x) {
            if (registry.func_148754_a(x) != null) continue;
            return x;
        }
        return -1;
    }

    public static int findEmpty(Object[] l) {
        for (int x = 0; x < l.length; ++x) {
            if (l[x] != null) continue;
            return x;
        }
        return -1;
    }

    @Nullable
    public static <T> T pickRandom(Collection<T> outs) {
        if (outs.isEmpty()) {
            return null;
        }
        int index = RANDOM_GENERATOR.nextInt(outs.size());
        return (T)Iterables.get(outs, (int)index, null);
    }

    public static AEPartLocation rotateAround(AEPartLocation forward, AEPartLocation axis) {
        if (axis == AEPartLocation.INTERNAL || forward == AEPartLocation.INTERNAL) {
            return forward;
        }
        switch (forward) {
            case DOWN: {
                switch (axis) {
                    case DOWN: {
                        return forward;
                    }
                    case UP: {
                        return forward;
                    }
                    case NORTH: {
                        return AEPartLocation.EAST;
                    }
                    case SOUTH: {
                        return AEPartLocation.WEST;
                    }
                    case EAST: {
                        return AEPartLocation.NORTH;
                    }
                    case WEST: {
                        return AEPartLocation.SOUTH;
                    }
                }
                break;
            }
            case UP: {
                switch (axis) {
                    case NORTH: {
                        return AEPartLocation.WEST;
                    }
                    case SOUTH: {
                        return AEPartLocation.EAST;
                    }
                    case EAST: {
                        return AEPartLocation.SOUTH;
                    }
                    case WEST: {
                        return AEPartLocation.NORTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.WEST;
                    }
                    case DOWN: {
                        return AEPartLocation.EAST;
                    }
                    case EAST: {
                        return AEPartLocation.UP;
                    }
                    case WEST: {
                        return AEPartLocation.DOWN;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.EAST;
                    }
                    case DOWN: {
                        return AEPartLocation.WEST;
                    }
                    case EAST: {
                        return AEPartLocation.DOWN;
                    }
                    case WEST: {
                        return AEPartLocation.UP;
                    }
                }
                break;
            }
            case EAST: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.NORTH;
                    }
                    case DOWN: {
                        return AEPartLocation.SOUTH;
                    }
                    case NORTH: {
                        return AEPartLocation.UP;
                    }
                    case SOUTH: {
                        return AEPartLocation.DOWN;
                    }
                }
            }
            case WEST: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.SOUTH;
                    }
                    case DOWN: {
                        return AEPartLocation.NORTH;
                    }
                    case NORTH: {
                        return AEPartLocation.DOWN;
                    }
                    case SOUTH: {
                        return AEPartLocation.UP;
                    }
                }
            }
        }
        return forward;
    }

    public static EnumFacing rotateAround(EnumFacing forward, EnumFacing axis) {
        switch (forward) {
            case DOWN: {
                switch (axis) {
                    case DOWN: {
                        return forward;
                    }
                    case UP: {
                        return forward;
                    }
                    case NORTH: {
                        return EnumFacing.EAST;
                    }
                    case SOUTH: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.NORTH;
                    }
                    case WEST: {
                        return EnumFacing.SOUTH;
                    }
                }
                break;
            }
            case UP: {
                switch (axis) {
                    case NORTH: {
                        return EnumFacing.WEST;
                    }
                    case SOUTH: {
                        return EnumFacing.EAST;
                    }
                    case EAST: {
                        return EnumFacing.SOUTH;
                    }
                    case WEST: {
                        return EnumFacing.NORTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (axis) {
                    case UP: {
                        return EnumFacing.WEST;
                    }
                    case DOWN: {
                        return EnumFacing.EAST;
                    }
                    case EAST: {
                        return EnumFacing.UP;
                    }
                    case WEST: {
                        return EnumFacing.DOWN;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (axis) {
                    case UP: {
                        return EnumFacing.EAST;
                    }
                    case DOWN: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.DOWN;
                    }
                    case WEST: {
                        return EnumFacing.UP;
                    }
                }
                break;
            }
            case EAST: {
                switch (axis) {
                    case UP: {
                        return EnumFacing.NORTH;
                    }
                    case DOWN: {
                        return EnumFacing.SOUTH;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                }
            }
            case WEST: {
                switch (axis) {
                    case UP: {
                        return EnumFacing.SOUTH;
                    }
                    case DOWN: {
                        return EnumFacing.NORTH;
                    }
                    case NORTH: {
                        return EnumFacing.DOWN;
                    }
                    case SOUTH: {
                        return EnumFacing.UP;
                    }
                }
            }
        }
        return forward;
    }

    @SideOnly(value=Side.CLIENT)
    public static String gui_localize(String string) {
        return I18n.func_74838_a((String)string);
    }

    public static LookDirection getPlayerRay(EntityPlayer playerIn, float eyeOffset) {
        double reachDistance = 5.0;
        double x = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q);
        double y = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double z = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s);
        float playerPitch = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C);
        float playerYaw = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B);
        float yawRayX = MathHelper.func_76126_a((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = MathHelper.func_76134_b((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -MathHelper.func_76134_b((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = MathHelper.func_76126_a((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        if (playerIn instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d from = new Vec3d(x, y, z);
        Vec3d to = from.func_72441_c((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return new LookDirection(from, to);
    }

    public static RayTraceResult rayTrace(EntityPlayer p, boolean hitBlocks, boolean hitEntities) {
        World w = p.func_130014_f_();
        float f = 1.0f;
        float f1 = p.field_70127_C + (p.field_70125_A - p.field_70127_C) * 1.0f;
        float f2 = p.field_70126_B + (p.field_70177_z - p.field_70126_B) * 1.0f;
        double d0 = p.field_70169_q + (p.field_70165_t - p.field_70169_q) * 1.0;
        double d1 = p.field_70167_r + (p.field_70163_u - p.field_70167_r) * 1.0 + 1.62 - p.func_70033_W();
        double d2 = p.field_70166_s + (p.field_70161_v - p.field_70166_s) * 1.0;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 32.0;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * 32.0, (double)f6 * 32.0, (double)f8 * 32.0);
        AxisAlignedBB bb = new AxisAlignedBB(Math.min(vec3.field_72450_a, vec31.field_72450_a), Math.min(vec3.field_72448_b, vec31.field_72448_b), Math.min(vec3.field_72449_c, vec31.field_72449_c), Math.max(vec3.field_72450_a, vec31.field_72450_a), Math.max(vec3.field_72448_b, vec31.field_72448_b), Math.max(vec3.field_72449_c, vec31.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
        Entity entity = null;
        double closest = 9999999.0;
        if (hitEntities) {
            List list = w.func_72839_b((Entity)p, bb);
            for (int l = 0; l < list.size(); ++l) {
                double nd;
                Entity entity1 = (Entity)list.get(l);
                if (entity1.field_70128_L || entity1 == p || entity1 instanceof EntityItem || !entity1.func_70089_S() || entity1.func_184215_y((Entity)p)) continue;
                f1 = 0.3f;
                AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                RayTraceResult RayTraceResult2 = boundingBox.func_72327_a(vec3, vec31);
                if (RayTraceResult2 == null || !((nd = vec3.func_72436_e(RayTraceResult2.field_72307_f)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
        }
        RayTraceResult pos = null;
        Vec3d vec = null;
        if (hitBlocks) {
            vec = new Vec3d(d0, d1, d2);
            pos = w.func_72901_a(vec3, vec31, true);
        }
        if (entity != null && pos != null && pos.field_72307_f.func_72436_e(vec) > closest) {
            pos = new RayTraceResult(entity);
        } else if (entity != null && pos == null) {
            pos = new RayTraceResult(entity);
        }
        return pos;
    }

    public static <T extends IAEStack<T>> T poweredExtraction(IEnergySource energy, IMEInventory<T> cell, T request, IActionSource src) {
        return Platform.poweredExtraction(energy, cell, request, src, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T poweredExtraction(IEnergySource energy, IMEInventory<T> cell, T request, IActionSource src, Actionable mode) {
        double energyFactor;
        double availablePower;
        long itemToExtract;
        Preconditions.checkNotNull((Object)energy);
        Preconditions.checkNotNull(cell);
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)((Object)mode));
        T possible = cell.extractItems(request.copy(), Actionable.SIMULATE, src);
        long retrieved = 0L;
        if (possible != null) {
            retrieved = possible.getStackSize();
        }
        if ((itemToExtract = Math.min((long)((availablePower = energy.extractAEPower((double)retrieved / (energyFactor = Math.max(1.0, (double)cell.getChannel().transferFactor())), Actionable.SIMULATE, PowerMultiplier.CONFIG)) * energyFactor + 0.9), retrieved)) > 0L) {
            if (mode == Actionable.MODULATE) {
                energy.extractAEPower((double)retrieved / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
                possible.setStackSize(itemToExtract);
                Object ret = cell.extractItems(possible, Actionable.MODULATE, src);
                if (ret != null) {
                    src.player().ifPresent(player -> Stats.ItemsExtracted.addToPlayer((EntityPlayer)player, (int)ret.getStackSize()));
                }
                return ret;
            }
            return possible.setStackSize(itemToExtract);
        }
        return null;
    }

    public static <T extends IAEStack<T>> T poweredInsert(IEnergySource energy, IMEInventory<T> cell, T input, IActionSource src) {
        return Platform.poweredInsert(energy, cell, input, src, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T poweredInsert(IEnergySource energy, IMEInventory<T> cell, T input, IActionSource src, Actionable mode) {
        double energyFactor;
        double availablePower;
        long itemToAdd;
        Preconditions.checkNotNull((Object)energy);
        Preconditions.checkNotNull(cell);
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)((Object)mode));
        T possible = cell.injectItems(input, Actionable.SIMULATE, src);
        long stored = input.getStackSize();
        if (possible != null) {
            stored -= possible.getStackSize();
        }
        if ((itemToAdd = Math.min((long)((availablePower = energy.extractAEPower((double)stored / (energyFactor = Math.max(1.0, (double)cell.getChannel().transferFactor())), Actionable.SIMULATE, PowerMultiplier.CONFIG)) * energyFactor + 0.9), stored)) > 0L) {
            if (mode == Actionable.MODULATE) {
                energy.extractAEPower((double)stored / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (itemToAdd < input.getStackSize()) {
                    long original = input.getStackSize();
                    Object leftover = input.copy();
                    T split = input.copy();
                    leftover.decStackSize(itemToAdd);
                    split.setStackSize(itemToAdd);
                    leftover.add(cell.injectItems(split, Actionable.MODULATE, src));
                    src.player().ifPresent(player -> {
                        long diff = original - leftover.getStackSize();
                        Stats.ItemsInserted.addToPlayer((EntityPlayer)player, (int)diff);
                    });
                    return leftover;
                }
                Object ret = cell.injectItems(input, Actionable.MODULATE, src);
                src.player().ifPresent(player -> {
                    long diff = ret == null ? input.getStackSize() : input.getStackSize() - ret.getStackSize();
                    Stats.ItemsInserted.addToPlayer((EntityPlayer)player, (int)diff);
                });
                return ret;
            }
            T ret = input.copy().setStackSize(input.getStackSize() - itemToAdd);
            return ret != null && ret.getStackSize() > 0L ? (T)ret : null;
        }
        return input;
    }

    public static void postChanges(IStorageGrid gs, ItemStack removed, ItemStack added, IActionSource src) {
        for (IStorageChannel<IAEStack<?>> chan : AEApi.instance().storage().storageChannels()) {
            ICellInventoryHandler<IAEStack<?>> myInv;
            IItemList<IAEStack<?>> myChanges = chan.createList();
            if (!removed.func_190926_b() && (myInv = AEApi.instance().registries().cell().getCellInventory(removed, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
                for (IAEStack<?> is : myChanges) {
                    is.setStackSize(-is.getStackSize());
                }
            }
            if (!added.func_190926_b() && (myInv = AEApi.instance().registries().cell().getCellInventory(added, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
            }
            gs.postAlterationOfStoredItems(chan, myChanges, src);
        }
    }

    public static <T extends IAEStack<T>> void postListChanges(IItemList<T> before, IItemList<T> after, IMEMonitorHandlerReceiver<T> meMonitorPassthrough, IActionSource source) {
        ArrayList<IAEStack> changes = new ArrayList<IAEStack>();
        for (IAEStack is : before) {
            is.setStackSize(-is.getStackSize());
        }
        for (IAEStack is : after) {
            before.add(is);
        }
        for (IAEStack is : before) {
            if (is.getStackSize() == 0L) continue;
            changes.add(is);
        }
        if (!changes.isEmpty()) {
            meMonitorPassthrough.postChange(null, changes, source);
        }
    }

    public static boolean securityCheck(GridNode a, GridNode b) {
        boolean b_isSecure;
        if (a.getLastSecurityKey() == -1L && b.getLastSecurityKey() == -1L) {
            return true;
        }
        if (a.getLastSecurityKey() == b.getLastSecurityKey()) {
            return true;
        }
        boolean a_isSecure = Platform.isPowered(a.getGrid()) && a.getLastSecurityKey() != -1L;
        boolean bl = b_isSecure = Platform.isPowered(b.getGrid()) && b.getLastSecurityKey() != -1L;
        if (AEConfig.instance().isFeatureEnabled(AEFeature.LOG_SECURITY_AUDITS)) {
            String locationA = a.getGridBlock().isWorldAccessible() ? a.getGridBlock().getLocation().toString() : "notInWorld";
            String locationB = b.getGridBlock().isWorldAccessible() ? b.getGridBlock().getLocation().toString() : "notInWorld";
            AELog.info("Audit: Node A [isSecure=%b, key=%d, playerID=%d, location={%s}] vs Node B[isSecure=%b, key=%d, playerID=%d, location={%s}]", a_isSecure, a.getLastSecurityKey(), a.getPlayerID(), locationA, b_isSecure, b.getLastSecurityKey(), b.getPlayerID(), locationB);
        }
        if (a_isSecure && b_isSecure) {
            return false;
        }
        if (!a_isSecure && b_isSecure) {
            return Platform.checkPlayerPermissions(b.getGrid(), a.getPlayerID());
        }
        if (a_isSecure && !b_isSecure) {
            return Platform.checkPlayerPermissions(a.getGrid(), b.getPlayerID());
        }
        return true;
    }

    private static boolean isPowered(IGrid grid) {
        if (grid == null) {
            return false;
        }
        IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        return eg.isNetworkPowered();
    }

    private static boolean checkPlayerPermissions(IGrid grid, int playerID) {
        if (grid == null) {
            return true;
        }
        ISecurityGrid gs = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        if (gs == null) {
            return true;
        }
        if (!gs.isAvailable()) {
            return true;
        }
        return gs.hasPermission(playerID, SecurityPermissions.BUILD);
    }

    public static void configurePlayer(EntityPlayer player, AEPartLocation side, TileEntity tile) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case DOWN: {
                pitch = 90.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case INTERNAL: {
                break;
            }
            case UP: {
                pitch = 90.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
            }
        }
        player.field_70165_t = (double)tile.func_174877_v().func_177958_n() + 0.5;
        player.field_70163_u = (double)tile.func_174877_v().func_177956_o() + 0.5;
        player.field_70161_v = (double)tile.func_174877_v().func_177952_p() + 0.5;
        player.field_70727_aS = player.field_70726_aT = pitch;
        player.field_70125_A = player.field_70726_aT;
        player.field_71107_bF = player.field_71109_bG = yaw;
        player.field_70177_z = player.field_71109_bG;
    }

    public static boolean canAccess(AENetworkProxy gridProxy, IActionSource src) {
        try {
            if (src.player().isPresent()) {
                return gridProxy.getSecurity().hasPermission(src.player().get(), SecurityPermissions.BUILD);
            }
            if (src.machine().isPresent()) {
                IActionHost te = src.machine().get();
                IGridNode n = te.getActionableNode();
                if (n == null) {
                    return false;
                }
                int playerID = n.getPlayerID();
                return gridProxy.getSecurity().hasPermission(playerID, SecurityPermissions.BUILD);
            }
            return false;
        }
        catch (GridAccessException gae) {
            return false;
        }
    }

    public static ItemStack extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, IMEMonitor<IAEItemStack> src, World w, IRecipe r, ItemStack output, InventoryCrafting ci, ItemStack providedTemplate, int slot, IItemList<IAEItemStack> items, Actionable realForFake, IPartitionList<IAEItemStack> filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            ItemStack extracted;
            IAEItemStack ae_ext;
            if (providedTemplate == null) {
                return ItemStack.field_190927_a;
            }
            AEItemStack ae_req = AEItemStack.fromItemStack(providedTemplate);
            ae_req.setStackSize(1L);
            if ((filter == null || filter.isListed(ae_req)) && (ae_ext = src.extractItems(ae_req, realForFake, mySrc)) != null && !(extracted = ae_ext.createItemStack()).func_190926_b()) {
                energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                return extracted;
            }
            boolean bl = checkFuzzy = ae_req.getOre().isPresent() || providedTemplate.func_77952_i() == Short.MAX_VALUE || providedTemplate.func_77942_o() || providedTemplate.func_77984_f();
            if (items != null && checkFuzzy) {
                for (IAEItemStack x : items) {
                    ItemStack sh = x.getDefinition();
                    if (!Platform.itemComparisons().isEqualItemType(providedTemplate, sh) && !ae_req.sameOre(x) || ItemStack.func_179545_c((ItemStack)sh, (ItemStack)output)) continue;
                    ItemStack cp = sh.func_77946_l();
                    cp.func_190920_e(1);
                    ci.func_70299_a(slot, cp);
                    if (r.func_77569_a(ci, w) && ItemStack.func_179545_c((ItemStack)r.func_77572_b(ci), (ItemStack)output)) {
                        IAEItemStack ex;
                        IAEItemStack ax = x.copy();
                        ax.setStackSize(1L);
                        if ((filter == null || filter.isListed(ax)) && (ex = src.extractItems(ax, realForFake, mySrc)) != null) {
                            energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                            return ex.createItemStack();
                        }
                    }
                    ci.func_70299_a(slot, providedTemplate);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getContainerItem(ItemStack stackInSlot) {
        if (stackInSlot == null) {
            return ItemStack.field_190927_a;
        }
        Item i = stackInSlot.func_77973_b();
        if (i == null || !i.hasContainerItem(stackInSlot)) {
            if (stackInSlot.func_190916_E() > 1) {
                stackInSlot.func_190920_e(stackInSlot.func_190916_E() - 1);
                return stackInSlot;
            }
            return ItemStack.field_190927_a;
        }
        ItemStack ci = i.getContainerItem(stackInSlot.func_77946_l());
        if (!ci.func_190926_b() && ci.func_77984_f() && ci.func_77952_i() == ci.func_77958_k()) {
            ci = ItemStack.field_190927_a;
        }
        return ci;
    }

    public static void notifyBlocksOfNeighbors(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            TickHandler.INSTANCE.addCallable(world, new BlockUpdate(pos));
        }
    }

    public static boolean canRepair(AEFeature type, ItemStack a, ItemStack b) {
        if (b.func_190926_b() || a.func_190926_b()) {
            return false;
        }
        if (type == AEFeature.CERTUS_QUARTZ_TOOLS) {
            IItemDefinition certusQuartzCrystal = AEApi.instance().definitions().materials().certusQuartzCrystal();
            return certusQuartzCrystal.isSameAs(b);
        }
        if (type == AEFeature.NETHER_QUARTZ_TOOLS) {
            return Items.field_151128_bU == b.func_77973_b();
        }
        return false;
    }

    public static List<ItemStack> findPreferred(ItemStack[] is) {
        IParts parts = AEApi.instance().definitions().parts();
        for (ItemStack stack : is) {
            if (parts.cableGlass().sameAs(AEColor.TRANSPARENT, stack)) {
                return Collections.singletonList(stack);
            }
            if (parts.cableCovered().sameAs(AEColor.TRANSPARENT, stack)) {
                return Collections.singletonList(stack);
            }
            if (parts.cableSmart().sameAs(AEColor.TRANSPARENT, stack)) {
                return Collections.singletonList(stack);
            }
            if (!parts.cableDenseSmart().sameAs(AEColor.TRANSPARENT, stack)) continue;
            return Collections.singletonList(stack);
        }
        return Lists.newArrayList((Object[])is);
    }

    public static void sendChunk(Chunk c, int verticalBits) {
        try {
            WorldServer ws = (WorldServer)c.func_177412_p();
            PlayerChunkMap pm = ws.func_184164_w();
            PlayerChunkMapEntry playerInstance = pm.func_187301_b(c.field_76635_g, c.field_76647_h);
            if (playerInstance != null) {
                playerInstance.func_187267_a((Packet)new SPacketChunkData(c, verticalBits));
            }
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
    }

    public static float getEyeOffset(EntityPlayer player) {
        assert (player.field_70170_p.field_72995_K) : "Valid only on client";
        return (float)(player.field_70163_u + (double)player.func_70047_e() - (double)player.getDefaultEyeHeight());
    }

    public static boolean isRecipePrioritized(ItemStack what) {
        IMaterials materials = AEApi.instance().definitions().materials();
        boolean isPurified = materials.purifiedCertusQuartzCrystal().isSameAs(what);
        isPurified |= materials.purifiedFluixCrystal().isSameAs(what);
        return isPurified |= materials.purifiedNetherQuartzCrystal().isSameAs(what);
    }

    public static boolean isGTDamageableItem(Item item) {
        return GTLoaded && ToolClass.getGTToolClass().isAssignableFrom(item.getClass());
    }

    public static MetaTileEntity getMetaTileEntity(IBlockAccess world, BlockPos pos) {
        if (reflectGTgetMTE == null) {
            try {
                reflectGTgetMTE = ReflectionHelper.findMethod(BlockMachine.class, (String)"getMetaTileEntity", null, (Class[])new Class[]{IBlockAccess.class, BlockPos.class});
            }
            catch (ReflectionHelper.UnableToFindMethodException e) {
                reflectGTgetMTE = ReflectionHelper.findMethod(GTUtility.class, (String)"getMetaTileEntity", null, (Class[])new Class[]{IBlockAccess.class, BlockPos.class});
            }
        } else {
            try {
                return (MetaTileEntity)reflectGTgetMTE.invoke((Object)reflectGTgetMTE, world, pos);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isIC2DamageableItem(Item item) {
        return Platform.isModLoaded("IC2") && item instanceof ICustomDamageItem;
    }

    static {
        GTLoaded = Platform.isModLoaded("gregtech");
    }
}

