/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.config.IncludeExclude;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IClientHelper;
import appeng.core.localization.GuiText;
import appeng.fluids.items.FluidDummyItem;
import appeng.fluids.util.AEFluidStack;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import appeng.util.item.AEStack;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;

public class ApiClientHelper
implements IClientHelper {
    private static final String[] NUMBER_FORMATS = new String[]{"#.000", "#.00", "#.0", "#"};

    @Override
    public <T extends IAEStack<T>> void addCellInformation(ICellInventoryHandler<T> handler, List<String> lines) {
        block15: {
            IItemList<AEItemStack> itemList;
            ICellInventory cellInventory;
            block14: {
                if (handler == null) {
                    return;
                }
                cellInventory = handler.getCellInv();
                if (cellInventory != null) {
                    lines.add(cellInventory.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
                    lines.add(cellInventory.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
                }
                itemList = cellInventory.getChannel().createList();
                if (!handler.isPreformatted()) break block14;
                String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                if (handler.isFuzzy()) {
                    lines.add("[" + GuiText.Partitioned.getLocal() + "] - " + list + ' ' + GuiText.Fuzzy.getLocal());
                } else {
                    lines.add("[" + GuiText.Partitioned.getLocal() + "] - " + list + ' ' + GuiText.Precise.getLocal());
                }
                if (handler.isSticky()) {
                    lines.add(GuiText.Sticky.getLocal());
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_82882_x && !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) break block15;
                IItemHandler iItemHandler = cellInventory.getConfigInventory();
                cellInventory.getAvailableItems(itemList);
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    Object stocked;
                    AEStack ais;
                    ItemStack is = iItemHandler.getStackInSlot(i);
                    if (is.func_190926_b()) continue;
                    if (cellInventory.getChannel() instanceof IItemStorageChannel) {
                        if (!handler.isFuzzy()) {
                            ais = AEItemStack.fromItemStack(is);
                            stocked = itemList.findPrecise((AEItemStack)ais);
                            lines.add("[" + is.func_82833_r() + "]: " + (stocked == null ? "0" : ReadableNumberConverter.INSTANCE.toWideReadableForm(stocked.getStackSize())));
                            continue;
                        }
                        ais = AEItemStack.fromItemStack(is);
                        stocked = itemList.findFuzzy((AEItemStack)ais, handler.getCellInv().getFuzzyMode());
                        int[] ids = OreDictionary.getOreIDs((ItemStack)is);
                        long size = 0L;
                        Iterator iterator = stocked.iterator();
                        while (iterator.hasNext()) {
                            IAEItemStack ist = (IAEItemStack)iterator.next();
                            size += ist.getStackSize();
                        }
                        if (is.func_77973_b().func_77645_m()) {
                            lines.add("[" + is.func_82833_r() + "]: " + size);
                            continue;
                        }
                        if (ids.length <= 0) continue;
                        StringBuilder sb = new StringBuilder();
                        for (int j : ids) {
                            sb.append(OreDictionary.getOreName((int)j)).append(", ");
                        }
                        lines.add("[{" + sb.substring(0, sb.length() - 2) + "}]: " + ReadableNumberConverter.INSTANCE.toWideReadableForm(size));
                        continue;
                    }
                    if (!(cellInventory.getChannel() instanceof IFluidStorageChannel)) continue;
                    ais = is.func_77973_b() instanceof FluidDummyItem ? AEFluidStack.fromFluidStack(((FluidDummyItem)is.func_77973_b()).getFluidStack(is)) : AEFluidStack.fromFluidStack(FluidUtil.getFluidContained((ItemStack)is));
                    stocked = (IAEFluidStack)((Object)itemList.findPrecise((AEItemStack)ais));
                    lines.add("[" + is.func_82833_r() + "]: " + (stocked == null ? "0" : this.fluidStackSize(stocked.getStackSize())));
                }
                break block15;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                cellInventory.getAvailableItems(itemList);
                for (IAEStack iAEStack : itemList) {
                    if (iAEStack instanceof IAEItemStack) {
                        lines.add(((IAEItemStack)iAEStack).getDefinition().func_82833_r() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(iAEStack.getStackSize()));
                        continue;
                    }
                    if (!(iAEStack instanceof IAEFluidStack)) continue;
                    lines.add(((IAEFluidStack)iAEStack).getFluidStack().getLocalizedName() + ": " + this.fluidStackSize(iAEStack.getStackSize()));
                }
            }
        }
    }

    private String fluidStackSize(long size) {
        String unit = size >= 1000L ? "B" : "mB";
        int log = (int)Math.floor(Math.log10(size)) / 2;
        int index = Math.max(0, Math.min(3, log));
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(NUMBER_FORMATS[index]);
        format.setDecimalFormatSymbols(symbols);
        format.setRoundingMode(RoundingMode.DOWN);
        String formatted = format.format((double)size / 1000.0);
        return formatted.concat(unit);
    }
}

