/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.Size1Slot;
import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotDisconnected;
import appeng.client.me.SlotME;
import appeng.client.render.StackSizeRenderer;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlot;
import appeng.container.slot.SlotCraftingTerm;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotInaccessible;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketSwapSlots;
import appeng.fluids.client.render.FluidStackSizeRenderer;
import appeng.fluids.container.slots.IMEFluidSlot;
import appeng.helpers.InventoryAction;
import appeng.integration.modules.jei.JEIPlugin;
import appeng.items.misc.ItemEncodedPattern;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Optional;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.api.MouseTweaksIgnore;

@MouseTweaksIgnore
public abstract class AEBaseGui
extends GuiContainer {
    private final List<InternalSlotME> meSlots = new ArrayList<InternalSlotME>();
    private final Set<Slot> drag_click = new HashSet<Slot>();
    private final StackSizeRenderer stackSizeRenderer = new StackSizeRenderer();
    private final FluidStackSizeRenderer fluidStackSizeRenderer = new FluidStackSizeRenderer();
    private GuiScrollbar myScrollBar = null;
    private boolean disableShiftClick = false;
    private Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    private ItemStack dbl_whichItem = ItemStack.field_190927_a;
    private Slot bl_clicked;
    private Stopwatch lastClicked = Stopwatch.createStarted();
    private List<IGhostIngredientHandler.Target<Object>> hoveredIngredientTargets = new ArrayList<IGhostIngredientHandler.Target<Object>>();
    private Object bookmarkedIngredient;
    private boolean isDraggingJeiGhostItem;
    private boolean haltDragging = false;
    private boolean isJeiGhostItem;
    protected final List<GuiCustomSlot> guiSlots = new ArrayList<GuiCustomSlot>();

    public void setJeiGhostItem(boolean jeiGhostItem) {
        this.isJeiGhostItem = jeiGhostItem;
    }

    public Object getBookmarkedIngredient() {
        return this.bookmarkedIngredient;
    }

    public List<GuiCustomSlot> getGuiSlots() {
        return this.guiSlots;
    }

    public AEBaseGui(Container container) {
        super(container);
    }

    protected static String join(Collection<String> toolTip, String delimiter) {
        Joiner joiner = Joiner.on((String)delimiter);
        return joiner.join(toolTip);
    }

    protected int getQty(GuiButton btn) {
        try {
            DecimalFormat df = new DecimalFormat("+#;-#");
            return df.parse(btn.field_146126_j).intValue();
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        List<Slot> slots = this.getInventorySlots();
        Iterator<Slot> i = slots.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof SlotME)) continue;
            i.remove();
        }
        for (InternalSlotME me : this.meSlots) {
            slots.add((Slot)new SlotME(me));
        }
    }

    private List<Slot> getInventorySlots() {
        return this.field_147002_h.field_75151_b;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        GlStateManager.func_179126_j();
        for (GuiCustomSlot c : this.guiSlots) {
            this.drawGuiSlot(c, mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179097_i();
        for (GuiCustomSlot c : this.guiSlots) {
            this.drawTooltip(c, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        GlStateManager.func_179121_F();
        this.func_191948_b(mouseX, mouseY);
        for (GuiCustomSlot c : this.field_146292_n) {
            if (!(c instanceof ITooltip)) continue;
            this.drawTooltip(c, mouseX, mouseY);
        }
        GlStateManager.func_179126_j();
        if (Platform.isModLoaded("jei")) {
            this.bookmarkedJEIghostItem(mouseX, mouseY);
        }
        GlStateManager.func_179097_i();
    }

    public List<Rectangle> getJEIExclusionArea() {
        return Collections.emptyList();
    }

    @Optional.Method(modid="jei")
    void bookmarkedJEIghostItem(int mouseX, int mouseY) {
        if (!this.isJeiGhostItem) {
            this.bookmarkedIngredient = JEIPlugin.runtime.getBookmarkOverlay().getIngredientUnderMouse();
        }
        if (this.bookmarkedIngredient != null) {
            this.hoveredIngredientTargets = JEIPlugin.aeGuiHandler.getTargets(this, this.bookmarkedIngredient, false);
            ItemStack dragItem = ItemStack.field_190927_a;
            if (this.hoveredIngredientTargets.size() > 0) {
                if (AEBaseGui.func_146272_n() && Mouse.isButtonDown((int)0) && this.lastClicked.elapsed(TimeUnit.MILLISECONDS) > 200L) {
                    this.lastClicked = Stopwatch.createStarted();
                    JEIPlugin.aeGuiHandler.getTargets(this, this.bookmarkedIngredient, true);
                } else if (Mouse.isButtonDown((int)0) && this.lastClicked.elapsed(TimeUnit.MILLISECONDS) > 200L) {
                    this.lastClicked = Stopwatch.createStarted();
                    if (this.bookmarkedIngredient instanceof ItemStack) {
                        dragItem = (ItemStack)this.bookmarkedIngredient;
                    } else if (this.bookmarkedIngredient instanceof FluidStack) {
                        dragItem = FluidUtil.getFilledBucket((FluidStack)((FluidStack)this.bookmarkedIngredient));
                    }
                    this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(dragItem.func_77946_l());
                    this.isJeiGhostItem = true;
                }
                this.drawTargets(mouseX, mouseY);
            }
        }
    }

    private void drawTargets(int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        for (IGhostIngredientHandler.Target<Object> target : this.hoveredIngredientTargets) {
            Rectangle area = target.getArea();
            Color color = area.contains(mouseX, mouseY) ? new Color(76, 201, 25, 128) : new Color(19, 201, 10, 64);
            Gui.func_73734_a((int)area.x, (int)area.y, (int)(area.x + area.width), (int)(area.y + area.height), (int)color.getRGB());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
    }

    protected void drawGuiSlot(GuiCustomSlot slot, int mouseX, int mouseY, float partialTicks) {
        if (slot.isSlotEnabled()) {
            int left = slot.xPos();
            int top = slot.yPos();
            int right = left + slot.getWidth();
            int bottom = top + slot.getHeight();
            slot.drawContent(this.field_146297_k, mouseX, mouseY, partialTicks);
            if (this.func_146978_c(left, top, slot.getWidth(), slot.getHeight(), mouseX, mouseY) && slot.canClick((EntityPlayer)this.field_146297_k.field_71439_g)) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(left, top, right, bottom, -2130706433, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
            }
        }
    }

    private void drawTooltip(ITooltip tooltip, int mouseX, int mouseY) {
        int x = tooltip.xPos();
        int y = tooltip.yPos();
        if (x < mouseX && x + tooltip.getWidth() > mouseX && tooltip.isVisible() && y < mouseY && y + tooltip.getHeight() > mouseY) {
            String msg;
            if (y < 15) {
                y = 15;
            }
            if ((msg = tooltip.getMessage()) != null) {
                this.drawTooltip(x + 11, y + 4, msg);
            }
        }
    }

    protected void drawTooltip(int x, int y, String message) {
        String[] lines = message.split("\n");
        this.drawTooltip(x, y, Arrays.asList(lines));
    }

    protected void drawTooltip(int x, int y, List<String> lines) {
        if (lines.isEmpty()) {
            return;
        }
        lines = Lists.newArrayList(lines);
        lines.set(0, TextFormatting.WHITE + (String)lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            lines.set(i, TextFormatting.GRAY + (String)lines.get(i));
        }
        this.drawHoveringText(lines, x, y, this.field_146289_q);
    }

    protected final void func_146979_b(int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getScrollBar() != null) {
            this.getScrollBar().draw(this);
        }
        this.drawFG(ox, oy, x, y);
    }

    public abstract void drawFG(int var1, int var2, int var3, int var4);

    protected final void func_146976_a(float f, int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBG(ox, oy, x, y);
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            IOptionalSlot optionalSlot;
            if (!(slot instanceof IOptionalSlot) || !(optionalSlot = (IOptionalSlot)slot).isRenderDisabled()) continue;
            AppEngSlot aeSlot = (AppEngSlot)slot;
            if (aeSlot.isSlotEnabled()) {
                this.func_73729_b(ox + aeSlot.field_75223_e - 1, oy + aeSlot.field_75221_f - 1, optionalSlot.getSourceX() - 1, optionalSlot.getSourceY() - 1, 18, 18);
                continue;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            GlStateManager.func_179147_l();
            this.func_73729_b(ox + aeSlot.field_75223_e - 1, oy + aeSlot.field_75221_f - 1, optionalSlot.getSourceX() - 1, optionalSlot.getSourceY() - 1, 18, 18);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (GuiCustomSlot guiCustomSlot : this.guiSlots) {
            guiCustomSlot.drawBackground(ox, oy);
        }
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        this.drag_click.clear();
        if (btn == 1) {
            for (Object o : this.field_146292_n) {
                GuiButton guibutton = (GuiButton)o;
                if (!guibutton.func_146116_c(this.field_146297_k, xCoord, yCoord)) continue;
                super.func_73864_a(xCoord, yCoord, 0);
                return;
            }
        }
        for (GuiCustomSlot slot : this.guiSlots) {
            if (!this.func_146978_c(slot.xPos(), slot.yPos(), slot.getWidth(), slot.getHeight(), xCoord, yCoord) || !slot.canClick((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            slot.slotClicked(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), btn);
        }
        if (this.getScrollBar() != null) {
            this.getScrollBar().click(this, xCoord - this.field_147003_i, yCoord - this.field_147009_r);
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.drag_click.clear();
        this.haltDragging = false;
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146273_a(int x, int y, int c, long d) {
        Slot slot = this.getSlot(x, y);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.getScrollBar() != null) {
            this.getScrollBar().click(this, x - this.field_147003_i, y - this.field_147009_r);
        }
        if (slot instanceof SlotFake && !itemstack.func_190926_b()) {
            if (this.drag_click.add(slot)) {
                PacketInventoryAction p = new PacketInventoryAction(c == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, slot.field_75222_d, 0L);
                NetworkHandler.instance().sendToServer(p);
            }
        } else if (slot instanceof SlotDisconnected) {
            if (!this.haltDragging && this.drag_click.add(slot)) {
                if (!itemstack.func_190926_b() && slot.func_75211_c().func_190926_b()) {
                    InventoryAction action = slot.func_75219_a() == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    PacketInventoryAction p = new PacketInventoryAction(action, slot.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                    NetworkHandler.instance().sendToServer(p);
                }
            } else if (AEBaseGui.func_146272_n()) {
                for (Slot dr : this.drag_click) {
                    InventoryAction action = null;
                    if (!slot.func_75211_c().func_190926_b()) {
                        action = InventoryAction.SHIFT_CLICK;
                    }
                    if (action == null) continue;
                    PacketInventoryAction p = new PacketInventoryAction(action, dr.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                    NetworkHandler.instance().sendToServer(p);
                }
            }
        } else {
            super.func_146273_a(x, y, c, d);
        }
    }

    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        PacketInventoryAction p;
        PacketInventoryAction p2;
        InventoryAction action;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.isJeiGhostItem && this.isDraggingJeiGhostItem) {
            for (IGhostIngredientHandler.Target<Object> target : this.hoveredIngredientTargets) {
                int y;
                int x;
                Rectangle area = target.getArea();
                if (!area.contains(x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1)) continue;
                target.accept(this.bookmarkedIngredient);
                break;
            }
            this.isJeiGhostItem = false;
            this.isDraggingJeiGhostItem = false;
            ItemStack dragItem = ItemStack.field_190927_a;
            if (JEIPlugin.runtime.getBookmarkOverlay().getIngredientUnderMouse() != null) {
                this.bookmarkedJEIghostItem(Mouse.getX(), this.field_146297_k.field_71440_d - Mouse.getY());
                if (this.bookmarkedIngredient instanceof ItemStack) {
                    dragItem = (ItemStack)this.bookmarkedIngredient;
                } else if (this.bookmarkedIngredient instanceof FluidStack) {
                    dragItem = FluidUtil.getFilledBucket((FluidStack)((FluidStack)this.bookmarkedIngredient));
                }
                this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(dragItem.func_77946_l());
                this.isJeiGhostItem = true;
            } else {
                this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(dragItem);
            }
        } else if (slot instanceof SlotFake) {
            InventoryAction action2;
            InventoryAction inventoryAction = action2 = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            if (this.drag_click.size() > 1) {
                return;
            }
            PacketInventoryAction p3 = new PacketInventoryAction(action2, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p3);
            return;
        }
        if (slot instanceof SlotPatternTerm) {
            if (mouseButton == 6) {
                return;
            }
            try {
                NetworkHandler.instance().sendToServer(((SlotPatternTerm)slot).getRequest(AEBaseGui.func_146272_n()));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        } else if (slot instanceof SlotCraftingTerm) {
            if (mouseButton == 6) {
                return;
            }
            action = null;
            action = AEBaseGui.func_146272_n() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            p2 = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p2);
            return;
        }
        if (Keyboard.isKeyDown((int)57) && this.enableSpaceClicking()) {
            IAEItemStack stack = null;
            if (slot instanceof SlotME) {
                stack = ((SlotME)slot).getAEStack();
            }
            int slotNum = this.getInventorySlots().size();
            if (!(slot instanceof SlotME) && slot != null) {
                slotNum = slot.field_75222_d;
            }
            ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
            p = new PacketInventoryAction(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof SlotDisconnected) {
            if (this.drag_click.size() >= 1) {
                return;
            }
            action = null;
            switch (clickType) {
                case PICKUP: {
                    if (mouseButton == 1) {
                        action = InventoryAction.SPLIT_OR_PLACE_SINGLE;
                        break;
                    }
                    action = InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!player.field_71075_bZ.field_75098_d) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                p2 = new PacketInventoryAction(action, slot.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                NetworkHandler.instance().sendToServer(p2);
            }
            return;
        }
        if (slot instanceof SlotME) {
            action = null;
            IAEItemStack stack = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack == null || action != InventoryAction.PICKUP_OR_SET_DOWN || stack.getStackSize() != 0L && !GuiScreen.func_175283_s() || !player.field_71071_by.func_70445_o().func_190926_b()) break;
                    action = InventoryAction.AUTO_CRAFT;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    stack = ((SlotME)slot).getAEStack();
                    break;
                }
                case CLONE: {
                    IAEItemStack slotItem;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack != null && stack.isCraftable()) {
                        action = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    if (!player.field_71075_bZ.field_75098_d || (slotItem = ((SlotME)slot).getAEStack()) == null) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
                p = new PacketInventoryAction(action, this.getInventorySlots().size(), 0L);
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        if (!this.disableShiftClick && AEBaseGui.func_146272_n() && mouseButton == 0) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem.func_190926_b() || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 250L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot != null ? (slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a) : ItemStack.field_190927_a;
            } else if (!this.dbl_whichItem.func_190926_b()) {
                List<Slot> slots = this.getInventorySlots();
                for (Slot inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.func_82869_a((EntityPlayer)this.field_146297_k.field_71439_g) || !inventorySlot.func_75216_d() || !inventorySlot.isSameInventory(slot) || !Container.func_94527_a((Slot)inventorySlot, (ItemStack)this.dbl_whichItem, (boolean)true)) continue;
                    this.func_184098_a(inventorySlot, inventorySlot.field_75222_d, 0, ClickType.QUICK_MOVE);
                }
                this.dbl_whichItem = ItemStack.field_190927_a;
            }
            this.disableShiftClick = false;
        }
        if (clickType == ClickType.PICKUP && this.isJeiGhostItem && !this.isDraggingJeiGhostItem) {
            this.isDraggingJeiGhostItem = true;
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    protected boolean func_146983_a(int keyCode) {
        Slot theSlot = this.getSlotUnderMouse();
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (keyCode != this.field_146297_k.field_71474_y.field_151456_ac[j].func_151463_i()) continue;
                List<Slot> slots = this.getInventorySlots();
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv() || s.func_82869_a(((AEBaseContainer)this.field_147002_h).getPlayerInv().field_70458_d)) continue;
                    return false;
                }
                if (theSlot.func_75219_a() == 64) {
                    this.func_184098_a(theSlot, theSlot.field_75222_d, j, ClickType.SWAP);
                    return true;
                }
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv()) continue;
                    NetworkHandler.instance().sendToServer(new PacketSwapSlots(s.field_75222_d, theSlot.field_75222_d));
                    return true;
                }
            }
        }
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    protected Slot getSlot(int mouseX, int mouseY) {
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public abstract void drawBG(int var1, int var2, int var3, int var4);

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && AEBaseGui.func_146272_n()) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.mouseWheelEvent(x, y, i / Math.abs(i));
        } else if (i != 0 && this.getScrollBar() != null) {
            this.getScrollBar().wheel(i);
        }
    }

    protected void mouseWheelEvent(int x, int y, int wheel) {
        ItemStack stack;
        IAEItemStack item;
        Slot slot = this.getSlot(x, y);
        if (slot instanceof SlotME && (item = ((SlotME)slot).getAEStack()) != null) {
            ((AEBaseContainer)this.field_147002_h).setTargetStack(item);
            InventoryAction direction = wheel > 0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = Math.abs(wheel);
            int inventorySize = this.getInventorySlots().size();
            for (int h = 0; h < times; ++h) {
                PacketInventoryAction p = new PacketInventoryAction(direction, inventorySize, 0L);
                NetworkHandler.instance().sendToServer(p);
            }
        }
        if (slot instanceof SlotFake && (stack = slot.func_75211_c()) != ItemStack.field_190927_a) {
            PacketInventoryAction p;
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                InventoryAction direction = wheel > 0 ? InventoryAction.DOUBLE : InventoryAction.HALVE;
                p = new PacketInventoryAction(direction, slot.field_75222_d, 0L);
            } else {
                InventoryAction direction = wheel > 0 ? InventoryAction.PLACE_SINGLE : InventoryAction.PICKUP_SINGLE;
                p = new PacketInventoryAction(direction, slot.field_75222_d, 0L);
            }
            NetworkHandler.instance().sendToServer(p);
        }
    }

    protected boolean enableSpaceClicking() {
        return true;
    }

    public void bindTexture(String base, String file) {
        ResourceLocation loc = new ResourceLocation(base, "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    protected void drawItem(int x, int y, ItemStack is) {
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        this.field_146296_j.func_180450_b(is, x, y);
        GlStateManager.func_179097_i();
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected String getGuiDisplayName(String in) {
        return this.hasCustomInventoryName() ? this.getInventoryName() : in;
    }

    private boolean hasCustomInventoryName() {
        if (this.field_147002_h instanceof AEBaseContainer) {
            return ((AEBaseContainer)this.field_147002_h).getCustomName() != null;
        }
        return false;
    }

    private String getInventoryName() {
        return ((AEBaseContainer)this.field_147002_h).getCustomName();
    }

    public void func_146977_a(Slot s) {
        if (s instanceof SlotME) {
            try {
                this.field_73735_i = 100.0f;
                this.field_146296_j.field_77023_b = 100.0f;
                if (!this.isPowered()) {
                    AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
                }
                this.field_73735_i = 0.0f;
                this.field_146296_j.field_77023_b = 0.0f;
                super.func_146977_a((Slot)new Size1Slot((SlotME)s));
                this.stackSizeRenderer.renderStackSize(this.field_146289_q, ((SlotME)s).getAEStack(), s.field_75223_e, s.field_75221_f);
            }
            catch (Exception err) {
                AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
            }
            return;
        }
        if (s instanceof IMEFluidSlot && ((IMEFluidSlot)s).shouldRenderAsFluid()) {
            IMEFluidSlot slot = (IMEFluidSlot)s;
            IAEFluidStack fs = slot.getAEFluidStack();
            if (fs != null && this.isPowered()) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179084_k();
                Fluid fluid = fs.getFluid();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
                float red = (float)(fluid.getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(fluid.getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(fluid.getColor() & 0xFF) / 255.0f;
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                this.func_175175_a(s.field_75223_e, s.field_75221_f, sprite, 16, 16);
                GlStateManager.func_179145_e();
                GlStateManager.func_179147_l();
                this.fluidStackSizeRenderer.renderStackSize(this.field_146289_q, fs, s.field_75223_e, s.field_75221_f);
            } else if (!this.isPowered()) {
                AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
            }
            return;
        }
        try {
            AppEngSlot aes;
            ItemStack is = s.func_75211_c();
            if (s instanceof AppEngSlot && (((AppEngSlot)s).renderIconWithItem() || is.func_190926_b()) && ((AppEngSlot)s).shouldDisplay() && (aes = (AppEngSlot)s).getIcon() >= 0) {
                this.bindTexture("guis/states.png");
                try {
                    int uv_y = (int)Math.floor(aes.getIcon() / 16);
                    int uv_x = aes.getIcon() - uv_y * 16;
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float par1 = aes.field_75223_e;
                    float par2 = aes.field_75221_f;
                    float par3 = uv_x * 16;
                    float par4 = uv_y * 16;
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder vb = tessellator.func_178180_c();
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    float f1 = 0.00390625f;
                    float f = 0.00390625f;
                    float par6 = 16.0f;
                    vb.func_181662_b((double)(par1 + 0.0f), (double)(par2 + 16.0f), (double)this.field_73735_i).func_187315_a((double)((par3 + 0.0f) * 0.00390625f), (double)((par4 + 16.0f) * 0.00390625f)).func_181666_a(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    float par5 = 16.0f;
                    vb.func_181662_b((double)(par1 + 16.0f), (double)(par2 + 16.0f), (double)this.field_73735_i).func_187315_a((double)((par3 + 16.0f) * 0.00390625f), (double)((par4 + 16.0f) * 0.00390625f)).func_181666_a(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    vb.func_181662_b((double)(par1 + 16.0f), (double)(par2 + 0.0f), (double)this.field_73735_i).func_187315_a((double)((par3 + 16.0f) * 0.00390625f), (double)((par4 + 0.0f) * 0.00390625f)).func_181666_a(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    vb.func_181662_b((double)(par1 + 0.0f), (double)(par2 + 0.0f), (double)this.field_73735_i).func_187315_a((double)((par3 + 0.0f) * 0.00390625f), (double)((par4 + 0.0f) * 0.00390625f)).func_181666_a(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    tessellator.func_78381_a();
                }
                catch (Exception uv_y) {
                    // empty catch block
                }
            }
            if (!is.func_190926_b() && s instanceof AppEngSlot) {
                if (((AppEngSlot)s).getIsValid() == AppEngSlot.hasCalculatedValidness.NotAvailable) {
                    boolean isValid;
                    boolean bl = isValid = s.func_75214_a(is) || s instanceof SlotOutput || s instanceof AppEngCraftingSlot || s instanceof SlotDisabled || s instanceof SlotInaccessible || s instanceof SlotFake || s instanceof SlotRestrictedInput || s instanceof SlotDisconnected;
                    if (isValid && s instanceof SlotRestrictedInput) {
                        try {
                            isValid = ((SlotRestrictedInput)s).isValid(is, (World)this.field_146297_k.field_71441_e);
                        }
                        catch (Exception err) {
                            AELog.debug(err);
                        }
                    }
                    ((AppEngSlot)s).setIsValid(isValid ? AppEngSlot.hasCalculatedValidness.Valid : AppEngSlot.hasCalculatedValidness.Invalid);
                }
                if (((AppEngSlot)s).getIsValid() == AppEngSlot.hasCalculatedValidness.Invalid) {
                    this.field_73735_i = 100.0f;
                    this.field_146296_j.field_77023_b = 100.0f;
                    GlStateManager.func_179140_f();
                    AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66FF6666);
                    GlStateManager.func_179145_e();
                    this.field_73735_i = 0.0f;
                    this.field_146296_j.field_77023_b = 0.0f;
                }
            }
            if (s instanceof SlotPlayerInv || s instanceof SlotPlayerHotBar) {
                if (!is.func_190926_b() && is.func_77973_b() instanceof ItemEncodedPattern) {
                    ItemEncodedPattern iep = (ItemEncodedPattern)is.func_77973_b();
                    ItemStack out = iep.getOutput(is);
                    if (!out.func_190926_b()) {
                        AppEngSlot appEngSlot = (AppEngSlot)s;
                        appEngSlot.setDisplay(true);
                        appEngSlot.setReturnAsSingleStack(true);
                        this.field_73735_i = 100.0f;
                        this.field_146296_j.field_77023_b = 100.0f;
                        if (!this.isPowered()) {
                            AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
                        }
                        this.field_73735_i = 0.0f;
                        this.field_146296_j.field_77023_b = 0.0f;
                        super.func_146977_a(s);
                        if (AEBaseGui.func_146272_n()) {
                            this.stackSizeRenderer.renderStackSize(this.field_146289_q, AEItemStack.fromItemStack(out), s.field_75223_e, s.field_75221_f);
                        } else {
                            super.func_146977_a(s);
                        }
                        return;
                    }
                } else {
                    super.func_146977_a(s);
                }
            } else {
                if (s instanceof AppEngSlot) {
                    AppEngSlot appEngSlot = (AppEngSlot)s;
                    if (s.func_75211_c().func_190926_b()) {
                        super.func_146977_a(s);
                        return;
                    }
                    appEngSlot.setDisplay(true);
                    appEngSlot.setReturnAsSingleStack(true);
                    this.field_73735_i = 100.0f;
                    this.field_146296_j.field_77023_b = 100.0f;
                    if (!this.isPowered()) {
                        AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
                    }
                    this.field_73735_i = 0.0f;
                    this.field_146296_j.field_77023_b = 0.0f;
                    super.func_146977_a(s);
                    this.stackSizeRenderer.renderStackSize(this.field_146289_q, AEItemStack.fromItemStack(appEngSlot.getDisplayStack()), s.field_75223_e, s.field_75221_f);
                    return;
                }
                super.func_146977_a(s);
            }
            return;
        }
        catch (Exception err) {
            AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
            super.func_146977_a(s);
            return;
        }
    }

    protected boolean isPowered() {
        return true;
    }

    public void bindTexture(String file) {
        ResourceLocation loc = new ResourceLocation("appliedenergistics2", "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    protected GuiScrollbar getScrollBar() {
        return this.myScrollBar;
    }

    protected void setScrollBar(GuiScrollbar myScrollBar) {
        this.myScrollBar = myScrollBar;
    }

    protected List<InternalSlotME> getMeSlots() {
        return this.meSlots;
    }
}

